/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.supplychain.invoice.importer.parser;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openconcerto.modules.supplychain.invoice.importer.AbstractInvoiceParser;
import org.openconcerto.modules.supplychain.invoice.importer.Invoice;
import org.openconcerto.modules.supplychain.invoice.importer.Page;
import org.openconcerto.modules.supplychain.invoice.importer.ParserUtils;

public class TechDataInvoiceParser
extends AbstractInvoiceParser {
    private final List<Date> dates = new ArrayList<Date>();
    private boolean numberIsNear = false;
    private boolean pageNumberNear = false;
    private boolean numberAndDateIsNext = false;

    @Override
    public boolean parse(Page page) {
        for (String line : page.getLines()) {
            System.err.println("TechDataInvoiceParser.parse()" + line);
        }
        if (!page.contains("tech data") && !page.contains("techdata")) {
            return false;
        }
        if (page.contains("Avoir de Retour")) {
            return false;
        }
        Invoice invoice = this.getInvoice();
        List<String> lines = page.getLines();
        invoice.setSupplierName("Tech Data");
        invoice.setTypePayment(8);
        try {
            for (String line : lines) {
                List<BigDecimal> listTax;
                List<BigDecimal> listAmount;
                List<BigDecimal> listWithTax;
                int total;
                int number;
                Pattern p;
                Matcher m;
                boolean b;
                String text = line.toLowerCase();
                System.err.println(text);
                if (text.contains("num\u00e9ro de note")) {
                    this.numberAndDateIsNext = true;
                } else if ((text.contains("date") || text.contains("dme")) && (text.contains("document") || text.contains("docmnmn"))) {
                    this.numberIsNear = true;
                } else if (invoice.getInvoiceNumber() == null && this.numberIsNear) {
                    String cText = text.replace('!', '/').replace(']', '/');
                    String[] split = cText.split("\\/");
                    if (split.length > 2) {
                        if (split[0].trim().length() > 8) {
                            String n = split[0];
                            invoice.setInvoiceNumber(n.trim());
                        }
                        if (invoice.getDate() == null) {
                            String strDate = split[1].trim();
                            Date d = ParserUtils.parseDate(strDate);
                            System.out.println("TechDataInvoiceParser.parse() " + strDate + " -> " + d + "  old:" + invoice.getDate() + " ");
                            if (d != null) {
                                invoice.setDate(d);
                                this.numberIsNear = false;
                                this.addHighlight(page, line);
                            }
                        }
                    }
                } else if (invoice.getInvoiceNumber() == null && this.numberAndDateIsNext) {
                    String nAndDate;
                    String[] split = text.split(" ");
                    if (split[0].trim().length() > 8) {
                        String n = split[0];
                        invoice.setInvoiceNumber(n.trim());
                    }
                    if ((nAndDate = text.substring(text.length() - 10)).charAt(0) != '1' && nAndDate.charAt(0) != '2' && nAndDate.charAt(0) != '3') {
                        nAndDate = nAndDate.substring(1);
                    }
                    Date d = ParserUtils.parseDate(nAndDate);
                    System.out.println("TechDataInvoiceParser.parse() " + nAndDate + " -> " + d + "  old:" + invoice.getDate() + " ");
                    if (d != null) {
                        invoice.setDate(d);
                        this.numberIsNear = false;
                        this.addHighlight(page, line);
                    }
                }
                if (invoice.getTotalPage() == -1 && text.contains("page") && text.contains("(") && (b = (m = (p = Pattern.compile(".*page.*(\\d+)\\((\\d+)\\).*")).matcher(text)).matches()) && m.groupCount() >= 2 && (number = Integer.valueOf(m.group(1)).intValue()) <= (total = Integer.valueOf(m.group(2)).intValue())) {
                    page.setPageNumber(number);
                    invoice.setTotalPage(total);
                    this.addHighlight(page, line);
                }
                if (invoice.getTotalPage() == -1 && text.contains("page")) {
                    this.pageNumberNear = true;
                } else if (this.pageNumberNear && text.contains("(") && (b = (m = (p = Pattern.compile(".*page.*(\\d+)\\((\\d+)\\).*")).matcher(text)).matches()) && m.groupCount() >= 2) {
                    number = Integer.valueOf(m.group(1));
                    total = Integer.valueOf(m.group(2));
                    this.pageNumberNear = false;
                    this.addHighlight(page, line);
                    if (number <= total) {
                        page.setPageNumber(number);
                        invoice.setTotalPage(total);
                        this.addHighlight(page, line);
                    }
                }
                if (invoice.getAmountWithTax() == null && (text.contains("net a payer") || text.contains("neta payer") || text.contains("netapayer")) && (listWithTax = this.getDecimalsInLine(this.strip(text, '.'))).size() > 0) {
                    invoice.setAmountWithTax(listWithTax.get(0));
                    this.addHighlight(page, line);
                }
                if (text.trim().startsWith("bases") && this.getInvoice().getAmount() == null && (listAmount = this.getDecimalsInLine(this.strip(text, '.'))).size() > 0) {
                    invoice.setAmount(listAmount.get(0));
                    this.addHighlight(page, line);
                }
                if (!text.trim().startsWith("total t.v.a.") || this.getInvoice().getTax() != null || (listTax = this.getDecimalsInLine(this.strip(text, '.'))).size() <= 0) continue;
                invoice.setTax(listTax.get(0));
                this.addHighlight(page, line);
            }
            this.missValueCalcul();
            invoice.setHighlight(this.getHighlight());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private String strip(String text, char c) {
        StringBuilder b = new StringBuilder(text.length());
        int i = 0;
        while (i < text.length()) {
            char cc = text.charAt(i);
            if (cc != c) {
                b.append(cc);
            }
            ++i;
        }
        return b.toString().trim();
    }

    @Override
    public void reset() {
        super.reset();
        this.dates.clear();
        this.numberIsNear = false;
        this.pageNumberNear = false;
    }

    @Override
    protected boolean checkInvoiceNumber(String invoiceNumber) {
        return invoiceNumber.length() > 8;
    }
}

