/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.supplychain.invoice.importer.parser;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openconcerto.modules.supplychain.invoice.importer.AbstractInvoiceParser;
import org.openconcerto.modules.supplychain.invoice.importer.Invoice;
import org.openconcerto.modules.supplychain.invoice.importer.Page;
import org.openconcerto.modules.supplychain.invoice.importer.ParserUtils;

public class OVHInvoiceParser
extends AbstractInvoiceParser {
    private final List<Date> dates = new ArrayList<Date>();
    private boolean pageNumberNear = false;

    @Override
    public boolean parse(Page page) {
        if (!page.contains("ovh") && !page.contains("22424761419")) {
            return false;
        }
        if (page.contains("Avoir de Retour")) {
            return false;
        }
        Invoice invoice = this.getInvoice();
        List<String> lines = page.getLines();
        invoice.setSupplierName("OVH");
        try {
            for (String line : lines) {
                List<BigDecimal> listAmount;
                List<BigDecimal> listWithTax;
                int total;
                int number;
                Pattern p;
                Matcher m;
                boolean b;
                String trim;
                int i;
                String text = line.toLowerCase();
                System.err.println(text);
                if (invoice.getInvoiceNumber() == null && text.startsWith("r\u00e9f\u00e9rence de la facture") && (i = text.indexOf(58)) > 6) {
                    invoice.setInvoiceNumber(text.substring(i + 1).trim());
                }
                if (invoice.getInvoiceNumber() == null && text.startsWith("facture") && !text.contains("payable") && !text.contains("n\u00b0") && text.length() > 16 && (trim = text.substring(8).trim()).length() < 12) {
                    invoice.setInvoiceNumber(trim);
                }
                if (invoice.getInvoiceNumber() == null && text.startsWith("facture") && text.contains("n\u00b0") && text.length() > 16) {
                    trim = text.substring(10).trim();
                    int i2 = trim.indexOf("du");
                    if (i2 > 0) {
                        trim = trim.substring(0, i2);
                    }
                    if (trim.length() < 12) {
                        invoice.setInvoiceNumber(trim);
                    }
                }
                if (invoice.getDate() == null && (text.startsWith("date d'\u00e9mission :") || text.startsWith("date :"))) {
                    i = text.indexOf(58);
                    String strDate = text.substring(i).trim();
                    Date d = ParserUtils.parseDate(strDate);
                    System.out.println("OVHInvoiceParser.parse() " + strDate + " -> " + d + "  old:" + invoice.getDate() + " ");
                    if (d != null) {
                        invoice.setDate(d);
                        this.addHighlight(page, line);
                    }
                }
                if (invoice.getTotalPage() == -1 && text.contains("page") && text.contains("(") && (b = (m = (p = Pattern.compile(".*page.*(\\d+)\\((\\d+)\\).*")).matcher(text)).matches()) && m.groupCount() >= 2 && (number = Integer.valueOf(m.group(1)).intValue()) <= (total = Integer.valueOf(m.group(2)).intValue())) {
                    page.setPageNumber(number);
                    invoice.setTotalPage(total);
                    this.addHighlight(page, line);
                }
                if (invoice.getTotalPage() == -1 && text.contains("page")) {
                    this.pageNumberNear = true;
                } else if (this.pageNumberNear && text.contains("(") && (b = (m = (p = Pattern.compile(".*page.*(\\d+)\\((\\d+)\\).*")).matcher(text)).matches()) && m.groupCount() >= 2) {
                    number = Integer.valueOf(m.group(1));
                    total = Integer.valueOf(m.group(2));
                    this.pageNumberNear = false;
                    this.addHighlight(page, line);
                    if (number <= total) {
                        page.setPageNumber(number);
                        invoice.setTotalPage(total);
                        this.addHighlight(page, line);
                    }
                }
                if (invoice.getAmountWithTax() == null && text.startsWith("total ttc") && (listWithTax = this.getDecimalsInLine(text)).size() > 0) {
                    invoice.setAmountWithTax(listWithTax.get(0));
                    this.addHighlight(page, line);
                }
                if (invoice.getAmountWithTax() == null && text.startsWith("total de la facture ttc") && (listWithTax = this.getDecimalsInLine(text)).size() > 0) {
                    invoice.setAmountWithTax(listWithTax.get(0));
                    this.addHighlight(page, line);
                }
                if (invoice.getAmountWithTax() == null && text.contains("montant") && text.contains("sera") && (listWithTax = this.getDecimalsInLine(text)).size() > 0) {
                    invoice.setAmountWithTax(listWithTax.get(0));
                    this.addHighlight(page, line);
                }
                if (text.trim().startsWith("prix ht") && this.getInvoice().getAmount() == null && (listAmount = this.getDecimalsInLine(text)).size() > 0) {
                    invoice.setAmount(listAmount.get(0));
                    this.addHighlight(page, line);
                }
                if (text.trim().startsWith("total de la facture ht") && (listAmount = this.getDecimalsInLine(text)).size() > 0) {
                    invoice.setAmount(listAmount.get(0));
                    this.addHighlight(page, line);
                }
                if (text.trim().startsWith("tva") && this.getInvoice().getTax() == null) {
                    List<BigDecimal> listTax;
                    if (text.contains(")")) {
                        text = text.substring(text.indexOf(")") + 1, text.length());
                    }
                    if ((listTax = this.getDecimalsInLine(text)).size() > 0) {
                        invoice.setTax(listTax.get(0));
                        this.addHighlight(page, line);
                    }
                }
                if (this.getInvoice().getTypePayment() >= 0 || !text.contains("sera pr\u00e9lev\u00e9") && !text.contains("a \u00e9t\u00e9 pr\u00e9lev\u00e9") && !text.startsWith("pr\u00e9lev\u00e9 sur votre")) continue;
                invoice.setTypePayment(10);
            }
            this.missValueCalcul();
            invoice.setHighlight(this.getHighlight());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private String strip(String text, char c) {
        StringBuilder b = new StringBuilder(text.length());
        int i = 0;
        while (i < text.length()) {
            char cc = text.charAt(i);
            if (cc != c) {
                b.append(cc);
            }
            ++i;
        }
        return b.toString().trim();
    }

    @Override
    public void reset() {
        super.reset();
        this.dates.clear();
        this.pageNumberNear = false;
    }

    @Override
    protected boolean checkInvoiceNumber(String invoiceNumber) {
        return invoiceNumber.toLowerCase().contains("fr");
    }
}

