/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.supplychain.invoice.importer.parser;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openconcerto.modules.supplychain.invoice.importer.AbstractInvoiceParser;
import org.openconcerto.modules.supplychain.invoice.importer.Invoice;
import org.openconcerto.modules.supplychain.invoice.importer.Page;
import org.openconcerto.modules.supplychain.invoice.importer.ParserUtils;

public class IngramInvoiceParser
extends AbstractInvoiceParser {
    private final List<Date> dates = new ArrayList<Date>();
    private boolean nextIsPageNumber = false;
    private boolean nextIsDate = false;
    private boolean nextIsTransporteur = false;
    private boolean nextIsInvoiceNumber = false;

    @Override
    public boolean parse(Page page) {
        if (!page.contains("ingram")) {
            return false;
        }
        if (page.contains("Avoir de Retour")) {
            return false;
        }
        Invoice invoice = this.getInvoice();
        List<String> lines = page.getLines();
        invoice.setSupplierName("Ingram");
        invoice.setTypePayment(8);
        try {
            String previousLine = "";
            for (String line : lines) {
                List<BigDecimal> listAmount;
                List<BigDecimal> listWithTax;
                String text = line.toLowerCase();
                System.err.println(text);
                if (text.startsWith("fr") && invoice.getTotalPage() == -1) {
                    this.nextIsPageNumber = true;
                } else if (invoice.getTotalPage() == -1 && this.nextIsPageNumber) {
                    invoice.setTotalPage(Integer.parseInt(line));
                    this.nextIsPageNumber = false;
                    this.nextIsDate = true;
                } else if (invoice.getDate() == null && !text.trim().equals("") && this.nextIsDate) {
                    Date d = ParserUtils.parseDate(text);
                    if (d != null) {
                        this.dates.add(d);
                        invoice.setDate(d);
                        this.addHighlight(page, line);
                    }
                    this.nextIsTransporteur = true;
                } else if (this.nextIsTransporteur) {
                    this.nextIsTransporteur = false;
                    this.nextIsInvoiceNumber = true;
                } else if (this.nextIsInvoiceNumber && invoice.getInvoiceNumber() == null) {
                    this.getInvoice().setInvoiceNumber(text);
                    this.nextIsInvoiceNumber = false;
                }
                if (invoice.getAmountWithTax() == null && (text.contains("net a payer") || text.contains("neta payer") || text.contains("netapayer")) && (listWithTax = this.getDecimalsInLine(this.strip(text, '.'))).size() > 0) {
                    invoice.setAmountWithTax(listWithTax.get(0));
                    this.addHighlight(page, line);
                }
                if (text.trim().startsWith("bases") && this.getInvoice().getAmount() == null && (listAmount = this.getDecimalsInLine(this.strip(text, '.'))).size() > 0) {
                    invoice.setAmount(listAmount.get(0));
                    this.addHighlight(page, line);
                }
                if (text.trim().startsWith("code tva:") && text.contains("%") && text.contains("=") && this.getInvoice().getTax() == null) {
                    int i = text.indexOf(61);
                    int j = text.indexOf(37);
                    String str = text.substring(i + 1, j);
                    System.out.println("amount is in : " + previousLine);
                    int i1 = str.indexOf(44);
                    String amount = previousLine.substring(i1 + 3);
                    int i2 = amount.indexOf(44);
                    amount = amount.substring(i2 + 3);
                    int i3 = amount.indexOf(44);
                    amount = amount.substring(i3 + 3);
                    System.out.println("amount is in : " + amount);
                    int i4 = amount.indexOf(44);
                    amount = amount.substring(0, i4 + 3);
                    System.out.println("amount is in : " + amount);
                    this.getInvoice().setAmount(super.getDecimalsInLine(amount).get(0));
                    this.getInvoice().setTax(new BigDecimal(str).divide(BigDecimal.valueOf(100L)).multiply(this.getInvoice().getAmount()));
                }
                previousLine = line;
            }
            this.missValueCalcul();
            invoice.setHighlight(this.getHighlight());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private String strip(String text, char c) {
        StringBuilder b = new StringBuilder(text.length());
        int i = 0;
        while (i < text.length()) {
            char cc = text.charAt(i);
            if (cc != c) {
                b.append(cc);
            }
            ++i;
        }
        return b.toString().trim();
    }

    @Override
    public void reset() {
        super.reset();
        this.dates.clear();
        this.nextIsDate = false;
    }

    @Override
    protected boolean checkInvoiceNumber(String invoiceNumber) {
        return invoiceNumber.length() > 8;
    }
}

