/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.supplychain.invoice.importer.parser;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openconcerto.modules.supplychain.invoice.importer.AbstractInvoiceParser;
import org.openconcerto.modules.supplychain.invoice.importer.Invoice;
import org.openconcerto.modules.supplychain.invoice.importer.Page;
import org.openconcerto.modules.supplychain.invoice.importer.ParserUtils;

public class AmazonInvoiceParser
extends AbstractInvoiceParser {
    @Override
    public boolean parse(Page page) {
        if (!page.contains("Amazon")) {
            return false;
        }
        Invoice invoice = this.getInvoice();
        List<String> lines = page.getLines();
        invoice.setSupplierName("Amazon");
        invoice.setTypePayment(3);
        boolean nextLineIsTotalEtTVA = false;
        boolean nextLineIsTotal = false;
        boolean nextLineIsTotalTVA = false;
        try {
            for (String line : lines) {
                Object cleanNumberString4;
                int i;
                BigDecimal tva;
                String cleanNumberString2;
                String s2;
                ArrayList<String> tmp;
                String s;
                String cleanNumberString3;
                Date d;
                String n;
                String text = line.toLowerCase();
                System.err.println("AmazonInvoiceParser.parse()" + text);
                if (nextLineIsTotalEtTVA) {
                    System.err.println("AmazonInvoiceParser.parse() look a total :" + text);
                    String[] split = text.split("\\s+");
                    ArrayList<String> l = new ArrayList<String>();
                    String[] stringArray = split;
                    int n2 = split.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        String string = stringArray[n3];
                        System.err.println("AmazonInvoiceParser.parse() part : " + string);
                        if (string.contains(",")) {
                            l.add(ParserUtils.getCleanNumberString(string));
                        }
                        ++n3;
                    }
                    System.err.println("AmazonInvoiceParser.parse() look a total ->" + l);
                    if (l.size() == 2) {
                        invoice.setAmount(new BigDecimal((String)l.get(0)));
                        invoice.setTax(new BigDecimal((String)l.get(1)));
                    }
                    nextLineIsTotalEtTVA = false;
                    continue;
                }
                if (nextLineIsTotal) {
                    invoice.setAmountWithTax(new BigDecimal(ParserUtils.getCleanNumberString(text)));
                    nextLineIsTotal = false;
                    continue;
                }
                if (nextLineIsTotalTVA) {
                    if (text.contains("%")) {
                        nextLineIsTotalTVA = false;
                        continue;
                    }
                    invoice.setTax(new BigDecimal(ParserUtils.getCleanNumberString(text)));
                    nextLineIsTotalTVA = false;
                    continue;
                }
                if (this.getInvoice().getInvoiceNumber() == null) {
                    System.err.println("AmazonInvoiceParser.parse() look a number :" + text);
                    if (text.contains("inv-fr-")) {
                        int index = text.indexOf("inv-fr-");
                        String s3 = "";
                        int i2 = index;
                        while (i2 >= 0) {
                            char c = text.charAt(i2);
                            if (!Character.isLetter(c) && c != '-') break;
                            s3 = String.valueOf(c) + s3;
                            --i2;
                        }
                        int count = 0;
                        int i3 = index + 1;
                        while (i3 < text.length()) {
                            char c = text.charAt(i3);
                            if (count > 12 && Character.isLetter(c)) break;
                            if (Character.isDigit(c) || Character.isLetter(c) || c == '-') {
                                s3 = String.valueOf(s3) + c;
                            }
                            ++count;
                            ++i3;
                        }
                        System.err.println("AmazonInvoiceParser.parse()----->" + s3);
                        this.setInvoiceNumber(invoice, s3);
                        continue;
                    }
                    if (text.contains("ro de la facture")) {
                        int i4 = text.indexOf("ro de la facture");
                        System.err.println("\n\n\nAmazonInvoiceParser.parse()1 " + text + " i:" + i4);
                        n = text.substring(i4 + "ro de la facture".length(), text.length()).trim();
                        String[] split = n.split("\\s+");
                        String invoiceNumber = split[0];
                        if (!invoiceNumber.trim().isEmpty() && invoiceNumber.trim().length() > 5) {
                            this.setInvoiceNumber(invoice, invoiceNumber);
                        }
                    }
                    if (text.contains("ro de facture")) {
                        int i5 = text.indexOf("ro de facture");
                        System.err.println("AmazonInvoiceParser.parse() 2" + text + " i:" + i5);
                        n = text.substring(i5 + "ro de facture".length() + 1, text.length()).trim();
                        String[] split = n.split("\\s+");
                        String invoiceNumber = split[0];
                        if (!invoiceNumber.trim().isEmpty() && invoiceNumber.trim().length() > 5) {
                            this.setInvoiceNumber(invoice, invoiceNumber);
                        }
                    }
                    if (text.contains("euvins")) {
                        int i6 = text.indexOf("euvins");
                        n = text.substring(i6, text.length()).trim();
                        String[] split = n.split("\\s+");
                        this.setInvoiceNumber(invoice, split[0]);
                    }
                    if (text.startsWith("facture")) {
                        text = text.replace(',', ' ');
                        String[] split = text.split("\\s+");
                        System.err.println("AmazonInvoiceParser.parse()" + split.length);
                        if (split.length == 6) {
                            Date d2 = ParserUtils.parseDate(String.valueOf(split[3]) + " " + split[4] + " " + split[5]);
                            if (d2 != null) {
                                invoice.setDate(d2);
                            }
                            this.setInvoiceNumber(invoice, split[2]);
                        } else {
                            n = split[split.length - 1];
                            this.setInvoiceNumber(invoice, n);
                            this.addHighlight(page, line);
                        }
                    }
                }
                if (this.getInvoice().getDate() == null && text.contains("de la provision")) {
                    int i7 = text.indexOf("de la provision");
                    System.err.println("AmazonInvoiceParser.parse()3 " + text + " i:" + i7);
                    n = text.substring(i7 + "de la provision".length() + 1, text.length()).trim();
                    String[] split = n.split("\\s+");
                    Date d3 = ParserUtils.parseDate(split[0]);
                    if (d3 != null) {
                        invoice.setDate(d3);
                    }
                }
                if (this.getInvoice().getDate() == null && (d = ParserUtils.parseDate(text)) != null) {
                    invoice.setDate(d);
                }
                if (text.contains("re\u00e7u (r\u00e9gl\u00e9)")) {
                    invoice.setInvoiceNumber("Recu");
                    this.addHighlight(page, line);
                }
                if (text.startsWith("bon de commande")) {
                    invoice.setInvoiceNumber("Commande");
                    this.addHighlight(page, line);
                }
                if (invoice.getAmount() == null && text.equals("taux tva total ht tva")) {
                    nextLineIsTotalEtTVA = true;
                    continue;
                }
                if (invoice.getAmountWithTax() == null && text.equals("total:")) {
                    nextLineIsTotal = true;
                    continue;
                }
                if (invoice.getTax() == null && text.equals("tva total")) {
                    nextLineIsTotalTVA = true;
                    continue;
                }
                if (invoice.getAmount() == null && invoice.getTax() == null && invoice.getAmountWithTax() == null && text.startsWith("total:") && !(cleanNumberString3 = ParserUtils.getCleanNumberString(s = text.substring(6).trim())).trim().isEmpty()) {
                    BigDecimal ttc = new BigDecimal(cleanNumberString3);
                    invoice.setAmountWithTax(ttc);
                }
                if (invoice.getAmount() == null && invoice.getTax() == null && invoice.getAmountWithTax() != null && text.contains("\u20ac")) {
                    String[] split = text.split("\\s+");
                    tmp = new ArrayList<String>();
                    int i8 = 0;
                    while (i8 < split.length) {
                        if (split[i8].contains(",")) {
                            tmp.add(split[i8]);
                        }
                        ++i8;
                    }
                    if (tmp.size() > 1) {
                        String s4 = ((String)tmp.get(0)).replace('.', ' ').replace(',', '.');
                        String cleanNumberString4 = ParserUtils.getCleanNumberString(s4);
                        BigDecimal ht = new BigDecimal(cleanNumberString4);
                        invoice.setAmount(ht);
                        s2 = ((String)tmp.get(1)).replace('.', ' ').replace(',', '.');
                        cleanNumberString2 = ParserUtils.getCleanNumberString(s2);
                        tva = new BigDecimal(cleanNumberString2);
                        invoice.setTax(tva);
                    }
                }
                if (invoice.getAmount() != null || invoice.getTax() != null || invoice.getAmountWithTax() != null || !text.startsWith("eur ")) continue;
                String[] split = text.split("\\s+");
                tmp = new ArrayList();
                if (split.length != 12 && split.length != 8) {
                    i = 0;
                    while (i < split.length) {
                        if (split[i].contains(",")) {
                            tmp.add(split[i]);
                        }
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < split.length) {
                        if (split[i].contains(".")) {
                            tmp.add(split[i].replace('.', ','));
                        }
                        ++i;
                    }
                }
                System.err.print("AmazonInvoiceParser.parse() amount :");
                for (String string : tmp) {
                    System.err.print(String.valueOf(string) + " ");
                }
                System.err.println();
                if (tmp.size() > 3) {
                    if (tmp.size() > 1) {
                        String s5 = ((String)tmp.get(1)).replace('.', ' ').replace(',', '.');
                        cleanNumberString4 = ParserUtils.getCleanNumberString(s5);
                        BigDecimal ht = new BigDecimal((String)cleanNumberString4);
                        invoice.setAmount(ht);
                    }
                    if (tmp.size() > 3) {
                        String s6 = ((String)tmp.get(3)).replace('.', ' ').replace(',', '.');
                        cleanNumberString4 = ParserUtils.getCleanNumberString(s6);
                        BigDecimal tva2 = new BigDecimal((String)cleanNumberString4);
                        invoice.setTax(tva2);
                    }
                    if (tmp.size() > 4) {
                        String s7 = ((String)tmp.get(4)).replace('.', ' ').replace(',', '.');
                        cleanNumberString4 = ParserUtils.getCleanNumberString(s7);
                        BigDecimal ttc = new BigDecimal((String)cleanNumberString4);
                        invoice.setAmountWithTax(ttc);
                    }
                }
                if (tmp.size() == 3) {
                    String s8 = ((String)tmp.get(1)).replace('.', ' ').replace(',', '.');
                    cleanNumberString4 = ParserUtils.getCleanNumberString(s8);
                    BigDecimal ht = new BigDecimal((String)cleanNumberString4);
                    invoice.setAmount(ht);
                    s2 = ((String)tmp.get(2)).replace('.', ' ').replace(',', '.');
                    cleanNumberString2 = ParserUtils.getCleanNumberString(s2);
                    tva = new BigDecimal(cleanNumberString2);
                    invoice.setTax(tva);
                    invoice.setAmountWithTax(ht.add(tva));
                }
                if (tmp.size() == 6 || tmp.size() == 4) {
                    String s9 = ((String)tmp.get(0)).replace('.', ' ').replace(',', '.');
                    cleanNumberString4 = ParserUtils.getCleanNumberString(s9);
                    BigDecimal ht = new BigDecimal((String)cleanNumberString4);
                    invoice.setAmount(ht);
                    s2 = ((String)tmp.get(1)).replace('.', ' ').replace(',', '.');
                    cleanNumberString2 = ParserUtils.getCleanNumberString(s2);
                    tva = new BigDecimal(cleanNumberString2);
                    invoice.setTax(tva);
                    invoice.setAmountWithTax(ht.add(tva));
                }
                this.addHighlight(page, line);
            }
            invoice.setHighlight(this.getHighlight());
            if (lines.size() < 8) {
                this.setInvoiceNumber(invoice, "Page vide");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void setInvoiceNumber(Invoice invoice, String number) {
        if (this.checkInvoiceNumber(number)) {
            invoice.setInvoiceNumber(number);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.needModePage = true;
    }

    @Override
    protected boolean checkInvoiceNumber(String invoiceNumber) {
        if (invoiceNumber.contains("commande")) {
            return false;
        }
        return invoiceNumber != null && invoiceNumber.trim().length() > 8;
    }
}

