/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.supplychain.invoice.importer;

import java.util.Calendar;
import java.util.Date;

public class ParserUtils {
    public static Date parseDate(String text) {
        Date result = null;
        if (text.length() == 8) {
            text = String.valueOf(text.substring(0, 2)) + "." + text.substring(2, 4) + "." + text.substring(4, 8);
        } else {
            result = ParserUtils.getFromFrenchDate(text);
            if (result != null) {
                return result;
            }
            text = text.replace("/", ".").replace("\\", ".").replace("'", ".").replace("-", ".").replace("\u2018", ".").replace(" ", "");
        }
        System.out.println("ParserUtils.parseDate() " + text);
        int textLength = text.length();
        StringBuilder date = new StringBuilder();
        int i = 0;
        while (i < textLength) {
            String charac = text.substring(i, i + 1);
            if (ParserUtils.isInteger(charac)) {
                date.append(charac);
                int j = i + 1;
                while (j < textLength && date.length() < 10) {
                    String charac2 = text.substring(j, j + 1);
                    if (charac2.equals(".") || ParserUtils.isInteger(charac2)) {
                        date.append(charac2);
                    } else if (!charac2.equals(" ")) break;
                    ++j;
                }
                String[] testDate = date.toString().split("\\.");
                Calendar c = Calendar.getInstance();
                c.clear();
                int year = -1;
                if (testDate.length > 2) {
                    try {
                        int day = Integer.parseInt(testDate[0]);
                        int month = Integer.parseInt(testDate[1]) - 1;
                        year = testDate[2].length() == 2 ? Integer.parseInt("20" + testDate[2]) : Integer.parseInt(testDate[2]);
                        if (month > 12 && month <= 31 && day <= 12) {
                            int swap = month;
                            month = day;
                            day = swap;
                        }
                        if (month < 12 && month >= 0 && day <= 31 && day > 0 && year > 2000 && year < 4000) {
                            c.set(5, day);
                            c.set(2, month);
                            c.set(1, year);
                            result = c.getTime();
                            break;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                date.delete(0, date.length());
            }
            ++i;
        }
        return result;
    }

    public static final String getCleanNumberString(String s) {
        if (s.indexOf(46) >= 0 && s.indexOf(44) >= 0) {
            s = s.replace('.', ' ').replace(',', '.');
        } else if (s.indexOf(46) < 0 && s.indexOf(44) >= 0) {
            s = s.replace(',', '.');
        }
        StringBuilder b = new StringBuilder();
        int length = s.length();
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            if (Character.isDigit(c) || c == '.') {
                b.append(c);
            }
            ++i;
        }
        return b.toString();
    }

    public static final boolean isLong(String text) {
        try {
            Long.parseLong(text);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static final boolean isInteger(String text) {
        try {
            Integer.parseInt(text);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean compareDate(Date date1, Date date2) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        int year1 = cal.get(1);
        int month1 = cal.get(2);
        int day1 = cal.get(5);
        cal.setTime(date2);
        int year2 = cal.get(1);
        int month2 = cal.get(2);
        int day2 = cal.get(5);
        return year1 == year2 && month1 == month2 && day1 == day2;
    }

    private static Date getFromFrenchDate(String frenchText) {
        System.err.println("ParserUtils.getFromFrenchDate()" + frenchText);
        int i = frenchText.lastIndexOf("20");
        if (i < 4) {
            return null;
        }
        if (frenchText.substring(i - 2, i).equals("20")) {
            i -= 2;
        }
        int year = -1;
        if (i != -1 && frenchText.length() >= i + 4) {
            try {
                year = Integer.parseInt(frenchText.substring(i, i + 4));
            }
            catch (Exception exception) {
                // empty catch block
            }
            frenchText = frenchText.toLowerCase();
            int month = ParserUtils.getFrenchMonth(frenchText.substring(0, i));
            if (year < 2000 || month < 0) {
                return null;
            }
            String[] split = frenchText.split("\\s+");
            Calendar d = Calendar.getInstance();
            int day = 0;
            int j = 0;
            while (j < split.length) {
                String sDay = split[j];
                try {
                    day = Integer.parseInt(sDay);
                    if (day > 0 && day < 32) {
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (day != year && (day = Integer.parseInt(sDay = sDay.substring(0, 2))) > 0 && day < 32) {
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++j;
            }
            if (day > 0) {
                d.set(year, month, day, 0, 0, 0);
            } else {
                d.set(year, month, 1, 0, 0, 0);
            }
            System.err.println("ParserUtils.getFromFrenchDate()" + frenchText + " ->" + d.getTime());
            return d.getTime();
        }
        return null;
    }

    private static int getFrenchMonth(String frenchDate) {
        int month = -1;
        if (frenchDate.contains("anvier")) {
            month = 0;
        } else if (frenchDate.contains("vrier")) {
            month = 1;
        } else if (frenchDate.contains("mars")) {
            month = 2;
        } else if (frenchDate.contains("avr")) {
            month = 3;
        } else if (frenchDate.contains("mai")) {
            month = 4;
        } else if (frenchDate.contains("juin") || frenchDate.contains("ju1n") || frenchDate.contains("ju") && frenchDate.contains("n")) {
            month = 5;
        } else if (frenchDate.contains("llet") || frenchDate.contains("ju") && frenchDate.contains("et")) {
            month = 6;
        } else if (frenchDate.contains("ao")) {
            month = 7;
        } else if (frenchDate.contains("sept")) {
            month = 8;
        } else if (frenchDate.contains("oct") || frenchDate.contains("obre")) {
            month = 9;
        } else if (frenchDate.contains("novem")) {
            month = 10;
        } else if (frenchDate.contains("cembre") || frenchDate.contains("d\u00e9cer\ufb01bre")) {
            month = 11;
        }
        return month;
    }

    public int LevenshteinDistance(String s0, String s1) {
        int len0 = s0.length() + 1;
        int len1 = s1.length() + 1;
        int[] cost = new int[len0];
        int[] newcost = new int[len0];
        int i = 0;
        while (i < len0) {
            cost[i] = i;
            ++i;
        }
        int j = 1;
        while (j < len1) {
            newcost[0] = j;
            int i2 = 1;
            while (i2 < len0) {
                int match = s0.charAt(i2 - 1) == s1.charAt(j - 1) ? 0 : 1;
                int cost_replace = cost[i2 - 1] + match;
                int cost_insert = cost[i2] + 1;
                int cost_delete = newcost[i2 - 1] + 1;
                newcost[i2] = Math.min(Math.min(cost_insert, cost_delete), cost_replace);
                ++i2;
            }
            int[] swap = cost;
            cost = newcost;
            newcost = swap;
            ++j;
        }
        return cost[len0 - 1];
    }
}

