/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.supplychain.invoice.importer;

import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.parser.PdfTextExtractor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.openconcerto.modules.supplychain.invoice.importer.Page;
import org.openconcerto.modules.supplychain.invoice.importer.parser.TechDataInvoiceParser;

public class PDFToText {
    public List<Page> parsePdf(File pdfFile) throws IOException {
        ArrayList<Page> result = new ArrayList<Page>();
        FileInputStream fileInputStream = new FileInputStream(pdfFile);
        try {
            PdfReader reader = new PdfReader((InputStream)fileInputStream);
            PdfTextExtractor e = new PdfTextExtractor(reader);
            int i = 1;
            while (i <= reader.getNumberOfPages()) {
                try {
                    String lines = e.getTextFromPage(i);
                    System.err.println(lines);
                    Page p = new Page(pdfFile, this.extractLines(lines));
                    result.add(p);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    System.err.println("PDFToText.parsePdf() unable to parse page " + pdfFile.getName());
                }
                ++i;
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (result.isEmpty()) {
            PDDocument doc = PDDocument.load((File)pdfFile);
            String s = new PDFTextStripper().getText(doc);
            Page p = new Page(pdfFile, this.extractLines(s));
            result.add(p);
            doc.close();
        }
        fileInputStream.close();
        return result;
    }

    private List<String> extractLines(String lines) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        BufferedReader r = new BufferedReader(new StringReader(lines));
        String s = r.readLine();
        while (s != null) {
            result.add(s.trim());
            s = r.readLine();
        }
        return result;
    }

    public static void main(String[] args) throws IOException {
        List<Page> pages = new PDFToText().parsePdf(new File("n:/Facture_2016-11-00486.pdf"));
        TechDataInvoiceParser parser = new TechDataInvoiceParser();
        for (Page p : pages) {
            parser.parse(p);
        }
        System.err.println("PDFToText.main() " + parser.getInvoice().toString());
    }
}

