/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.supplychain.invoice.importer;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class PDFSplitter {
    public static void split(File f) throws Exception {
        System.out.println("Reading " + f.getAbsolutePath());
        FileInputStream fileInputStream = new FileInputStream(f);
        PdfReader reader = new PdfReader((InputStream)fileInputStream);
        int n = reader.getNumberOfPages();
        System.out.println("Number of pages : " + n);
        if (n > 1) {
            int i = 0;
            while (i < n) {
                String inFile = f.getName();
                String outFile = String.valueOf(inFile.substring(0, inFile.length() - 4)) + "-" + String.format("%03d", i + 1) + ".pdf";
                System.out.println("Writing " + outFile);
                Document document = new Document(reader.getPageSizeWithRotation(1));
                PdfCopy writer = new PdfCopy(document, (OutputStream)new FileOutputStream(new File(f.getParentFile(), outFile)));
                document.open();
                PdfImportedPage page = writer.getImportedPage(reader, ++i);
                writer.addPage(page);
                document.close();
                writer.close();
            }
        }
        fileInputStream.close();
        if (n > 1) {
            f.delete();
        }
    }
}

