/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.supplychain.invoice.importer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.generationEcritures.GenerationMvtSaisieAchat;
import org.openconcerto.modules.supplychain.invoice.importer.Invoice;
import org.openconcerto.modules.supplychain.invoice.importer.InvoiceTable;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLBackgroundTableCache;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.TableRef;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.ExceptionHandler;

public class InvoicesFrame
extends JFrame {
    private InvoiceTable table;
    private JButton b;
    private final SQLTable tableAchat;

    InvoicesFrame(SQLTable tableAchat) {
        this.tableAchat = tableAchat;
        final JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.table = new InvoiceTable(tableAchat);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        p.add((Component)this.table, c);
        ++c.gridy;
        c.fill = 0;
        c.anchor = 14;
        c.weighty = 0.0;
        this.b = new JButton("Cr\u00e9er les saisies d'achats");
        p.add((Component)this.b, c);
        this.b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InvoicesFrame.this.b.setEnabled(false);
                InvoicesFrame.this.table.setEnabled(false);
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        List<Invoice> l = InvoicesFrame.this.table.getInvoices();
                        try {
                            InvoicesFrame.this.importInvoices(l);
                            JOptionPane.showMessageDialog(p, "Cr\u00e9ation des achats termin\u00e9e!");
                            InvoicesFrame.this.setVisible(false);
                        }
                        catch (Exception e) {
                            ExceptionHandler.handle((String)"Erreur lors de la cr\u00e9ation des achats", (Throwable)e);
                        }
                    }
                });
                t.start();
            }
        });
        this.setContentPane(p);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                InvoicesFrame f = new InvoicesFrame(null);
                f.pack();
                f.setSize(new Dimension(800, 400));
                f.setLocationRelativeTo(null);
                f.setVisible(true);
            }
        });
    }

    private void importInvoices(final List<Invoice> invoices) {
        HashMap<String, SQLRow> supplierMap = new HashMap<String, SQLRow>();
        SQLTable supplierTable = this.tableAchat.getForeignTable("ID_FOURNISSEUR");
        SQLSelect sel = new SQLSelect();
        sel.addSelectStar((TableRef)supplierTable);
        List result = SQLRowListRSH.execute((SQLSelect)sel);
        for (SQLRow sqlRow : result) {
            supplierMap.put(sqlRow.getString("NOM"), sqlRow);
        }
        int i = 1;
        for (Invoice invoice : invoices) {
            final int n = i++;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    InvoicesFrame.this.b.setText("Import " + n + "/" + invoices.size() + " en cours...");
                }
            });
            if (!invoice.getValid()) continue;
            SQLRow supplierRow = (SQLRow)supplierMap.get(invoice.getSupplierName());
            if (supplierRow != null && invoice.getAmount() != null) {
                int idCompteAchat = this.getIdCompteAchat(supplierRow, this.tableAchat);
                SQLRow r = supplierRow.getForeignRow("ID_MODE_REGLEMENT");
                SQLElement eltModeReglement = Configuration.getInstance().getDirectory().getElement("MODE_REGLEMENT");
                SQLRowValues rowValsMdr = eltModeReglement.createCopy(r.getID());
                rowValsMdr.put("ID_TYPE_REGLEMENT", invoice.getTypePayment());
                if (invoice.getTypePayment() == 3) {
                    rowValsMdr.put("COMPTANT", (Object)true);
                    rowValsMdr.put("AJOURS", 0);
                    rowValsMdr.put("LENJOUR", 0);
                }
                SQLRowValues rowVals = new SQLRowValues(this.tableAchat);
                rowVals.put("ID_FOURNISSEUR", supplierRow.getID());
                rowVals.put("MONTANT_TTC", (Object)invoice.getAmountWithTax().multiply(new BigDecimal(100)).longValue());
                rowVals.put("MONTANT_HT", (Object)invoice.getAmount().multiply(new BigDecimal(100)).longValue());
                long tva = invoice.getTax().multiply(new BigDecimal(100)).longValue();
                rowVals.put("MONTANT_TVA", (Object)tva);
                Integer taxId = invoice.getTaxId();
                if (taxId == -1 && tva != 0L) {
                    BigDecimal tvaTaux = invoice.getTax().divide(invoice.getAmount(), DecimalUtils.HIGH_PRECISION);
                    tvaTaux = tvaTaux.setScale(3, RoundingMode.HALF_UP).movePointRight(2);
                    TaxeCache cache = TaxeCache.getCache();
                    cache.getFirstTaxe();
                    float tvaFloat = tvaTaux.floatValue();
                    System.err.println(invoice.getAmount() + " -- " + invoice.getAmountWithTax() + "--" + invoice.getTax() + " (" + tvaFloat + ")");
                    if (tvaFloat >= 5.4f && tvaFloat <= 5.6f) {
                        tvaFloat = 5.5f;
                    }
                    if (tvaFloat >= 19.8f && tvaFloat <= 20.1f) {
                        tvaFloat = 20.0f;
                    }
                    taxId = cache.getIdFromTaux(Float.valueOf(tvaFloat));
                }
                if (taxId != null) {
                    rowVals.put("ID_TAXE", (Object)taxId);
                    rowVals.put("ID_MODE_REGLEMENT", (Object)rowValsMdr);
                    rowVals.put("ID_COMPTE_PCE", idCompteAchat);
                    rowVals.put("NUMERO_FACTURE", (Object)invoice.getInvoiceNumber());
                    rowVals.put("DATE", (Object)invoice.getDate());
                    try {
                        SQLRow row = rowVals.insert();
                        GenerationMvtSaisieAchat g = new GenerationMvtSaisieAchat(row);
                        g.genereMouvement();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    continue;
                }
                JOptionPane.showMessageDialog(null, "Impossible d'int\u00e9grer la facture " + invoice.getInvoiceNumber());
                continue;
            }
            System.out.println("fournisseur inconnue:" + invoice.getSupplierName());
        }
    }

    private int getIdCompteAchat(SQLRow supplierRow, SQLTable purchaseTable) {
        int idCompteAchat = -1;
        if (supplierRow.isForeignEmpty("ID_COMPTE_PCE_CHARGE")) {
            SQLTable tablePrefCompte = purchaseTable.getTable("PREFS_COMPTE");
            SQLRow rowPrefsCompte = SQLBackgroundTableCache.getInstance().getCacheForTable(tablePrefCompte).getRowFromId(2);
            idCompteAchat = rowPrefsCompte.getInt("ID_COMPTE_PCE_ACHAT");
            if (idCompteAchat <= 1) {
                try {
                    idCompteAchat = ComptePCESQLElement.getIdComptePceDefault((String)"Achats");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        } else {
            idCompteAchat = supplierRow.getForeignID("ID_COMPTE_PCE_CHARGE");
        }
        return idCompteAchat;
    }
}

