/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.supplychain.invoice.importer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.TransferHandler;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openconcerto.erp.core.common.ui.DeviseTableCellRenderer;
import org.openconcerto.modules.supplychain.invoice.importer.AbstractInvoiceParser;
import org.openconcerto.modules.supplychain.invoice.importer.Invoice;
import org.openconcerto.modules.supplychain.invoice.importer.PDFToText;
import org.openconcerto.modules.supplychain.invoice.importer.Page;
import org.openconcerto.modules.supplychain.invoice.importer.parser.AmazonInvoiceParser;
import org.openconcerto.modules.supplychain.invoice.importer.parser.IngramInvoiceParser;
import org.openconcerto.modules.supplychain.invoice.importer.parser.OVHInvoiceParser;
import org.openconcerto.modules.supplychain.invoice.importer.parser.TechDataInvoiceParser;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.ui.ReloadPanel;
import org.openconcerto.ui.table.TimestampTableCellEditor;

public class InvoiceTable
extends JPanel {
    List<Invoice> invoices = new ArrayList<Invoice>();
    final DefaultTableModel dm;
    final ReloadPanel comp = new ReloadPanel();
    private JLabel info;
    private SQLTable tableAchat;

    public InvoiceTable(SQLTable tableAchat) {
        this.tableAchat = tableAchat;
        this.dm = new DefaultTableModel(){

            @Override
            public int getRowCount() {
                return InvoiceTable.this.getInvoicesSize();
            }

            @Override
            public int getColumnCount() {
                return 8;
            }

            @Override
            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return "Date";
                    }
                    case 1: {
                        return "Fournisseur";
                    }
                    case 2: {
                        return "Num\u00e9ro de facture";
                    }
                    case 3: {
                        return "Montant HT";
                    }
                    case 4: {
                        return "Montant TVA";
                    }
                    case 5: {
                        return "Montant TTC";
                    }
                    case 6: {
                        return "Pay\u00e9 par";
                    }
                    case 7: {
                        return "Fichier";
                    }
                }
                return "" + column;
            }

            @Override
            public Object getValueAt(int row, int column) {
                if (!SwingUtilities.isEventDispatchThread()) {
                    throw new IllegalStateException();
                }
                Invoice i = InvoiceTable.this.getInvoice(row);
                if (column == 0) {
                    return i.getDate();
                }
                if (column == 1) {
                    return i.getSupplierName();
                }
                if (column == 2) {
                    return i.getInvoiceNumber();
                }
                if (column == 3) {
                    return i.getAmount();
                }
                if (column == 4) {
                    return i.getTax();
                }
                if (column == 5) {
                    return i.getAmountWithTax();
                }
                if (column == 6) {
                    return i.getTypePaymentAsString();
                }
                if (column == 7) {
                    return i.getFileName();
                }
                return "?";
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 0) {
                    return Date.class;
                }
                if (columnIndex == 1) {
                    return String.class;
                }
                if (columnIndex == 2) {
                    return String.class;
                }
                if (columnIndex == 3) {
                    return BigDecimal.class;
                }
                if (columnIndex == 4) {
                    return BigDecimal.class;
                }
                if (columnIndex == 5) {
                    return BigDecimal.class;
                }
                if (columnIndex == 6) {
                    return String.class;
                }
                if (columnIndex == 6) {
                    return String.class;
                }
                return super.getColumnClass(columnIndex);
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        JTable t = new JTable(this.dm);
        t.setAutoCreateRowSorter(true);
        t.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value != null) {
                    DateFormat f = SimpleDateFormat.getDateInstance(1);
                    value = f.format(value);
                }
                this.setHorizontalTextPosition(4);
                this.setHorizontalAlignment(4);
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        });
        t.getColumnModel().getColumn(0).setCellEditor((TableCellEditor)new TimestampTableCellEditor(false));
        t.getColumnModel().getColumn(3).setCellRenderer((TableCellRenderer)new DeviseTableCellRenderer(){});
        t.getColumnModel().getColumn(7).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (!InvoiceTable.this.invoices.get(row).getValid()) {
                    c.setBackground(new Color(250, 220, 230));
                } else if (!isSelected) {
                    c.setBackground(Color.WHITE);
                }
                return c;
            }
        });
        t.getColumnModel().getColumn(0).setMinWidth(110);
        t.getColumnModel().getColumn(1).setMinWidth(200);
        t.getColumnModel().getColumn(2).setMinWidth(120);
        t.getColumnModel().getColumn(3).setMinWidth(60);
        t.getColumnModel().getColumn(4).setMinWidth(60);
        t.getColumnModel().getColumn(5).setMinWidth(60);
        t.getColumnModel().getColumn(6).setMinWidth(40);
        t.getColumnModel().getColumn(7).setMinWidth(60);
        t.setRowHeight(t.getRowHeight() + 4);
        t.setIntercellSpacing(new Dimension(8, 2));
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        c.gridwidth = 2;
        this.add((Component)new JLabelBold("Factures"), c);
        ++c.gridy;
        this.add((Component)new JLabel("Glissez vos factures (PDFs) dans la fen\u00eatre pour les analyser."), c);
        ++c.gridy;
        c.weighty = 1.0;
        c.fill = 1;
        this.add((Component)new JScrollPane(t), c);
        ++c.gridy;
        c.weighty = 0.0;
        c.gridwidth = 1;
        this.comp.setMode(2);
        this.info = new JLabel();
        this.add((Component)this.info, c);
        ++c.gridx;
        this.add((Component)this.comp, c);
        this.setTransferHandler(this.createTransfertHandler());
    }

    private TransferHandler createTransfertHandler() {
        TransferHandler handler = new TransferHandler(){

            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                return support.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport support) {
                if (!this.canImport(support)) {
                    return false;
                }
                Transferable t = support.getTransferable();
                try {
                    List l = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                    InvoiceTable.this.importFiles(l);
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
                return true;
            }
        };
        return handler;
    }

    protected int getInvoicesSize() {
        return this.invoices.size();
    }

    public Invoice getInvoice(int index) {
        return this.invoices.get(index);
    }

    public void add(Invoice invoice) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException();
        }
        this.invoices.add(invoice);
        this.dm.fireTableDataChanged();
    }

    @Override
    public void removeAll() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException();
        }
        this.invoices.clear();
        this.dm.fireTableDataChanged();
    }

    public void setModeRunning() {
        this.comp.setMode(0);
    }

    public void setModeCompleted() {
        this.comp.setMode(2);
    }

    public void importFiles(final List<File> fileList) throws IOException {
        this.setModeRunning();
        SwingWorker<List<Invoice>, List<Invoice>> w = new SwingWorker<List<Invoice>, List<Invoice>>(){

            @Override
            protected List<Invoice> doInBackground() throws Exception {
                ArrayList<Invoice> result = new ArrayList();
                try {
                    block2: for (File file : fileList) {
                        System.err.println("InvoiceOCRTable.importFiles() " + file.getAbsolutePath());
                        List<Object> pages = new ArrayList();
                        if (file.getName().toLowerCase().endsWith(".pdf")) {
                            pages = new PDFToText().parsePdf(file);
                        } else if (file.getName().toLowerCase().endsWith(".txt")) {
                            pages = InvoiceTable.this.convertFileToPage(file);
                        } else {
                            JOptionPane.showMessageDialog(null, "Type de fichier non support\u00e9");
                        }
                        ArrayList<AbstractInvoiceParser> parsers = new ArrayList<AbstractInvoiceParser>();
                        parsers.add(new TechDataInvoiceParser());
                        parsers.add(new AmazonInvoiceParser());
                        parsers.add(new OVHInvoiceParser());
                        parsers.add(new IngramInvoiceParser());
                        boolean ok = false;
                        for (final AbstractInvoiceParser parser : parsers) {
                            for (Page page : pages) {
                                ok = parser.parse(page);
                                parser.getInvoice().addPage(page);
                            }
                            if (ok) {
                                System.err.println("InvoiceTable.importFiles(...) " + file.getName() + " valide pour " + parser.getClass().getName());
                                parser.getInvoice().setValid(true);
                                parser.checkInvoice(true);
                                result.add(parser.getInvoice());
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        InvoiceTable.this.add(parser.getInvoice());
                                        InvoiceTable.this.info.setText(String.valueOf((this).InvoiceTable.this.dm.getRowCount()) + " factures import\u00e9es.");
                                    }
                                });
                                continue block2;
                            }
                            System.err.println("InvoiceTable.importFiles(...) " + file.getName() + " non valide pour " + parser.getClass().getName());
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                HashMap<String, Invoice> m = new HashMap<String, Invoice>();
                for (Invoice invoice : result) {
                    m.put(invoice.getInvoiceNumber(), invoice);
                }
                result = new ArrayList(m.values());
                Collections.sort(result);
                return result;
            }

            @Override
            protected void done() {
                InvoiceTable.this.setModeCompleted();
            }
        };
        w.run();
    }

    protected List<Page> convertFileToPage(File file) throws Exception {
        ArrayList<String> lines = new ArrayList<String>();
        InputStreamReader f = new InputStreamReader((InputStream)new FileInputStream(file), "UTF8");
        BufferedReader b = new BufferedReader(f);
        String line = b.readLine();
        while (line != null) {
            System.err.println("InvoiceOCRTable.convertFileToPage()" + line);
            lines.add(line);
            line = b.readLine();
        }
        b.close();
        f.close();
        Page page = new Page(file, lines);
        return Arrays.asList(page);
    }

    public List<Invoice> getInvoices() {
        return new ArrayList<Invoice>(this.invoices);
    }
}

