/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.supplychain.invoice.importer;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.modules.supplychain.invoice.importer.AbstractInvoiceParser;
import org.openconcerto.modules.supplychain.invoice.importer.PDFToText;
import org.openconcerto.modules.supplychain.invoice.importer.Page;
import org.openconcerto.modules.supplychain.invoice.importer.parser.AmazonInvoiceParser;

public class InvoiceRenamer {
    final Map<File, String> map = new HashMap<File, String>();
    final SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");

    InvoiceRenamer() {
    }

    private void dump() {
        for (Map.Entry<File, String> item : this.map.entrySet()) {
            System.out.println(String.valueOf(item.getKey().getName()) + " : " + item.getValue());
            File dest = new File(item.getKey().getParent(), item.getValue());
            boolean b = item.getKey().renameTo(dest);
            System.out.println(String.valueOf(item.getKey().getAbsolutePath()) + "->" + dest.getAbsolutePath() + ":" + b);
        }
    }

    public void rename(File file) throws IOException {
        System.err.println("\n\n----------------------------------------------------------");
        System.err.println("InvoiceRenamer" + file.getAbsolutePath());
        boolean ok = false;
        List<Page> pages = new PDFToText().parsePdf(file);
        ArrayList<AmazonInvoiceParser> parsers = new ArrayList<AmazonInvoiceParser>();
        parsers.add(new AmazonInvoiceParser());
        for (AbstractInvoiceParser abstractInvoiceParser : parsers) {
            for (Page p : pages) {
                ok = abstractInvoiceParser.parse(p);
                abstractInvoiceParser.getInvoice().addPage(p);
            }
            if (ok) {
                System.err.println("InvoiceRenamer" + file.getName() + " valide pour " + abstractInvoiceParser.getClass().getName());
                abstractInvoiceParser.getInvoice().setValid(true);
                abstractInvoiceParser.checkInvoice(true);
                Date d = abstractInvoiceParser.getInvoice().getDate();
                String number = abstractInvoiceParser.getInvoice().getInvoiceNumber();
                if (number == null) {
                    System.err.println("InvoiceRenamer no number");
                    break;
                }
                String value = String.valueOf(this.df.format(d)) + " " + number.toUpperCase() + ".pdf";
                System.err.println("InvoiceRenamer put " + file.getName() + ":" + value);
                this.map.put(file, value);
                break;
            }
            System.err.println("InvoiceRenamer " + file.getName() + " number:" + abstractInvoiceParser.getInvoice().getInvoiceNumber() + " : " + abstractInvoiceParser.getInvoice().getDate());
            System.err.println("InvoiceRenamer " + file.getName() + " non valide pour " + abstractInvoiceParser.getClass().getName());
        }
    }

    public static void main(String[] args) throws IOException {
        InvoiceRenamer renamer = new InvoiceRenamer();
        File dir = new File("Y:\\Factures fournisseurs\\2022\\Amazon");
        File[] files = dir.listFiles();
        if (files == null) {
            System.err.println("InvoiceRenamer no files in " + dir.getAbsolutePath());
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            renamer.rename(file);
            ++n2;
        }
        renamer.dump();
    }
}

