/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.supplychain.invoice.importer;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.modules.supplychain.invoice.importer.Page;
import org.openconcerto.sql.model.SQLRowAccessor;

public class Invoice
implements Comparable<Invoice> {
    private String supplierName;
    private String invoiceNumber;
    private Date date;
    private BigDecimal amount;
    private BigDecimal tax;
    private BigDecimal amountWithTax;
    private int taxId = -1;
    private boolean valid = true;
    private boolean active = true;
    private boolean isNotInvoice = true;
    private boolean containCalculatedValue = false;
    private int totalPage = -1;
    private Map<Page, List<String>> map = new HashMap<Page, List<String>>();
    private final List<Page> pages = new ArrayList<Page>();
    private int typePayment = -1;

    public int getTypePayment() {
        return this.typePayment;
    }

    public String getTypePaymentAsString() {
        if (this.typePayment == 3) {
            return "CB";
        }
        if (this.typePayment == 2) {
            return "Ch\u00e8que";
        }
        if (this.typePayment == 4) {
            return "Esp\u00e8ce";
        }
        if (this.typePayment == 7) {
            return "ind\u00e9fini";
        }
        if (this.typePayment == 5) {
            return "traite";
        }
        if (this.typePayment == 8) {
            return "virement";
        }
        if (this.typePayment == 10) {
            return "pr\u00e9l\u00e8vement";
        }
        return "inconnu";
    }

    public void setTypePayment(int p) {
        this.typePayment = p;
    }

    public String getSupplierName() {
        return this.supplierName;
    }

    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public Date getDate() {
        return this.date;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public BigDecimal getTax() {
        return this.tax;
    }

    public int getTaxId() {
        return this.taxId;
    }

    public BigDecimal getAmountWithTax() {
        return this.amountWithTax;
    }

    public boolean getValid() {
        return this.valid;
    }

    public boolean getActive() {
        return this.active;
    }

    public boolean getContainCalculatedValue() {
        return this.containCalculatedValue;
    }

    public int getTotalPage() {
        return this.totalPage;
    }

    public Map<Page, List<String>> getMap() {
        return this.map;
    }

    public boolean getIsNotInvoice() {
        return this.isNotInvoice;
    }

    public void setIsNotInvoice(boolean isNotInvoice) {
        this.isNotInvoice = isNotInvoice;
    }

    public void setMap(Map<Page, List<String>> map) {
        this.map = map;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber.trim();
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public void setAmountWithTax(BigDecimal amountWithTax) {
        this.amountWithTax = amountWithTax;
    }

    public void setTaxId() {
        BigDecimal realTaxPercent = this.getTaxPercent();
        Integer id = null;
        if (realTaxPercent != null) {
            Set taxes = TaxeCache.getCache().getAllTaxe();
            for (SQLRowAccessor taxe : taxes) {
                BigDecimal taxPercent = new BigDecimal(Float.valueOf(taxe.getFloat("TAUX")).toString()).divide(new BigDecimal(100));
                BigDecimal tempTax = this.amount.multiply(taxPercent).setScale(2, 4);
                if (this.tax.compareTo(tempTax) != 0) continue;
                id = taxe.getInt("ID_TAXE");
                break;
            }
            this.taxId = id != null ? id : -1;
        } else {
            this.taxId = -1;
        }
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setContainCalculatedValue(boolean containCalculatedValue) {
        this.containCalculatedValue = containCalculatedValue;
    }

    public void setTotalPage(int total) {
        this.totalPage = total;
    }

    public void addHighlight(Page page, String line) {
        List<String> l = this.map.get(page);
        if (l == null) {
            l = new ArrayList<String>();
            this.map.put(page, l);
        }
        l.add(line);
    }

    public void setHighlight(Map<Page, List<String>> m) {
        this.map = m;
    }

    public List<String> getHighlight(Page page) {
        List<String> l = this.map.get(page);
        if (l == null) {
            return Collections.emptyList();
        }
        return l;
    }

    public void addPage(Page page) {
        this.pages.add(page);
    }

    public void addPages(List<Page> list) {
        this.pages.addAll(list);
    }

    public Page getPage(int i) {
        return this.pages.get(i);
    }

    public int getPageCount() {
        return this.pages.size();
    }

    public boolean checkNullValue() {
        return this.amount != null && this.tax != null && this.amountWithTax != null && this.invoiceNumber != null && this.date != null;
    }

    public boolean checkAmounts() {
        if (this.amount.add(this.tax).compareTo(this.amountWithTax) != 0) {
            return false;
        }
        return this.amount.compareTo(new BigDecimal(0)) != -1 && this.amountWithTax.compareTo(new BigDecimal(0)) != -1 && this.tax.compareTo(new BigDecimal(0)) != -1;
    }

    public void setNullAmounts() {
        this.amount = null;
        this.tax = null;
        this.amountWithTax = null;
    }

    private BigDecimal getTaxPercent() {
        if (this.tax != null && this.amount != null) {
            return this.tax.divide(this.amount, 10, 4).multiply(new BigDecimal(100)).setScale(2, 4);
        }
        return null;
    }

    public String toString() {
        return String.valueOf(super.toString()) + " : " + this.invoiceNumber + " Fournisseur:" + this.supplierName + " " + this.date + " Total: " + this.amount + " \u20ac HT TVA:" + this.tax + " TTC: " + this.amountWithTax;
    }

    public String getFileName() {
        if (this.pages.size() > 0) {
            return this.pages.get(0).getFileImage().getName();
        }
        return "";
    }

    @Override
    public int compareTo(Invoice o) {
        if (this.getDate() == null) {
            return -1;
        }
        if (o.getDate() == null) {
            return 1;
        }
        return this.getDate().compareTo(o.getDate());
    }
}

