/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.supplychain.invoice.importer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.openconcerto.modules.supplychain.invoice.importer.PDFSplitter;
import org.openconcerto.utils.StreamUtils;
import org.openconcerto.utils.StringUtils;

public class ILMTools {
    public static void main(String[] args) throws Exception {
        File dir = new File("N:\\Amazon2017");
        ILMTools.splitPDF(dir);
        ILMTools.abbyOCR(dir);
    }

    private static void downloadPDFFromMail(File dir) throws Exception {
        File[] files;
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception sc) {
            // empty catch block
        }
        File[] fileArray = files = dir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().toLowerCase().endsWith(".eml")) {
                String name = String.valueOf(file.getName()) + ".pdf";
                BufferedReader bReader = new BufferedReader(new FileReader(file));
                String line = bReader.readLine();
                while (line != null) {
                    File outFile;
                    if ((line = line.trim()).startsWith("Subject")) {
                        line = line.substring(8, line.length()).replace('[', ' ').replace(']', ' ').trim();
                        name = String.valueOf((String)StringUtils.fastSplit((String)line, (char)' ').get(1)) + ".pdf";
                    }
                    if (line.startsWith("https") && line.contains(".pdf") && (!(outFile = new File(dir, name)).exists() || outFile.length() < 500L)) {
                        System.out.println("ILMTools.downloadPDFFromMail() " + line);
                        URL url = new URL(line);
                        URLConnection connection = url.openConnection();
                        InputStream is = connection.getInputStream();
                        StreamUtils.copy((InputStream)is, (File)outFile);
                        if (outFile.length() < 500L) {
                            System.out.println("ILMTools.downloadPDFFromMail() download failed, retrying...");
                            Thread.sleep(5000L);
                            StreamUtils.copy((InputStream)url.openConnection().getInputStream(), (File)outFile);
                            if (outFile.length() < 500L) {
                                System.err.println("ILMTools.downloadPDFFromMail() download failed for " + line);
                            }
                        }
                    }
                    line = bReader.readLine();
                }
                bReader.close();
            }
            ++n2;
        }
    }

    private static void abbyOCR(File dir) throws IOException {
        File[] files;
        File[] fileArray = files = dir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().toLowerCase().endsWith(".pdf")) {
                String filePath = file.getCanonicalPath();
                String filePathOut = String.valueOf(file.getCanonicalPath().substring(0, filePath.length() - 4)) + ".txt";
                if (new File(filePathOut).exists() && new File(filePathOut).length() > 0L) {
                    System.err.println("AmazonTools.abbyOCR() skipping " + filePath);
                } else {
                    System.err.println("AmazonTools.abbyOCR() processing " + filePath);
                    ProcessBuilder builder = new ProcessBuilder("C:\\Program Files (x86)\\ABBYY FineReader 12\\FineCmd.exe", filePath, "/out", filePathOut, "/quit");
                    builder.redirectErrorStream(true);
                    Process process = builder.start();
                    BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String line = null;
                    try {
                        while ((line = input.readLine()) != null) {
                            System.out.println(line);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            ++n2;
        }
    }

    public static void splitPDF(File dir) throws Exception {
        File[] files;
        File[] fileArray = files = dir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().toLowerCase().endsWith(".pdf")) {
                PDFSplitter.split(file);
            }
            ++n2;
        }
    }
}

