/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.supplychain.invoice.importer;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.openconcerto.utils.Base64;

public class DuplicateFileFinder {
    private final File dir;

    public DuplicateFileFinder(File dir) {
        this.dir = dir;
    }

    public static void main(String[] args) throws Exception {
        DuplicateFileFinder f = new DuplicateFileFinder(new File("n:/Amazon2016"));
        List<File> list = f.getSameSize();
        for (File file : list) {
            System.err.println("DuplicateFileFinder.main() " + file.getCanonicalPath());
            file.delete();
        }
    }

    public List<File> getDuplicates() throws Exception {
        HashSet<String> hashes = new HashSet<String>();
        File[] files = this.dir.listFiles();
        if (files == null) {
            throw new IllegalStateException("No files in " + this.dir.getAbsolutePath());
        }
        ArrayList<File> result = new ArrayList<File>();
        int i = 0;
        while (i < files.length) {
            File f = files[i];
            String h = Base64.encodeBytes((byte[])this.createSha1(f));
            if (hashes.contains(h)) {
                result.add(f);
            } else {
                hashes.add(h);
            }
            ++i;
        }
        return result;
    }

    public List<File> getSameSize() throws Exception {
        HashSet<String> hashes = new HashSet<String>();
        File[] files = this.dir.listFiles();
        if (files == null) {
            throw new IllegalStateException("No files in " + this.dir.getAbsolutePath());
        }
        ArrayList<File> result = new ArrayList<File>();
        int i = 0;
        while (i < files.length) {
            File f = files[i];
            String h = "" + f.length();
            if (hashes.contains(h)) {
                result.add(f);
            } else {
                System.err.println("DuplicateFileFinder.getSameSize()" + h + " " + f.getName());
                hashes.add(h);
            }
            ++i;
        }
        return result;
    }

    public byte[] createSha1(File file) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        FileInputStream fis = new FileInputStream(file);
        int n = 0;
        byte[] buffer = new byte[8192];
        while (n != -1) {
            n = ((InputStream)fis).read(buffer);
            if (n <= 0) continue;
            digest.update(buffer, 0, n);
        }
        ((InputStream)fis).close();
        return digest.digest();
    }
}

