/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.supplychain.invoice.importer;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.modules.supplychain.invoice.importer.Invoice;
import org.openconcerto.modules.supplychain.invoice.importer.InvoiceParser;
import org.openconcerto.modules.supplychain.invoice.importer.Page;
import org.openconcerto.modules.supplychain.invoice.importer.ParserUtils;

public abstract class AbstractInvoiceParser
implements InvoiceParser {
    protected boolean valid = false;
    protected boolean needModePage;
    private Invoice invoice;
    private final Map<Page, List<String>> map = new HashMap<Page, List<String>>();

    public AbstractInvoiceParser() {
        this.invoice = new Invoice();
    }

    @Override
    public void reset() {
        this.valid = false;
        this.needModePage = true;
        this.invoice = new Invoice();
        this.map.clear();
    }

    @Override
    public abstract boolean parse(Page var1);

    protected abstract boolean checkInvoiceNumber(String var1);

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public boolean needModePage() {
        return this.needModePage;
    }

    public void addHighlight(Page page, String line) {
        List<String> l = this.map.get(page);
        if (l == null) {
            l = new ArrayList<String>();
            this.map.put(page, l);
        }
        l.add(line);
    }

    public Map<Page, List<String>> getHighlight() {
        return this.map;
    }

    @Override
    public Invoice getInvoice() {
        return this.invoice;
    }

    public void checkInvoice(boolean isValidWithCalculatedValue) {
        this.missValueCalcul();
        if (!this.invoice.checkNullValue()) {
            this.invoice.setValid(false);
        } else if (this.invoice.getContainCalculatedValue() && !isValidWithCalculatedValue) {
            this.invoice.setValid(false);
        } else if (!this.checkInvoiceNumber(this.invoice.getInvoiceNumber())) {
            this.invoice.setValid(false);
        }
        if (this.invoice.getAmount() == null || this.invoice.getAmount().intValue() == 0) {
            this.invoice.setValid(false);
        }
    }

    protected List<BigDecimal> getDecimalsInLine(String text) {
        ArrayList<BigDecimal> listResult = new ArrayList<BigDecimal>();
        StringBuilder result = new StringBuilder();
        int textSize = text.length();
        text = text.replace(",", ".");
        int i = 0;
        while (i < textSize) {
            if (ParserUtils.isInteger(text.substring(i, i + 1))) {
                int firstDot = -1;
                int secondDot = -1;
                int decimalDot = -1;
                String sNumber = "";
                int spaceIndex = text.indexOf(" ", i);
                int dotIndex = text.indexOf(".", i);
                if (dotIndex == spaceIndex + 1) {
                    spaceIndex = text.indexOf(" ", dotIndex);
                }
                if (spaceIndex != -1) {
                    sNumber = text.substring(i, spaceIndex);
                } else {
                    int endNumberIndex = i;
                    while (endNumberIndex < textSize && (endNumberIndex == dotIndex || ParserUtils.isInteger(text.substring(endNumberIndex, endNumberIndex + 1)))) {
                        ++endNumberIndex;
                    }
                    sNumber = text.substring(i, endNumberIndex);
                }
                sNumber = sNumber.replace(" ", "").trim();
                if (ParserUtils.parseDate(sNumber) == null) {
                    if (textSize >= i + 8 && sNumber.length() == 1 && ParserUtils.isInteger(text.substring(i + 2, i + 5))) {
                        sNumber = text.substring(i, i + 8).replace(" ", ".");
                    }
                    firstDot = sNumber.indexOf(".");
                    if (sNumber.length() > firstDot + 1) {
                        secondDot = sNumber.indexOf(".", firstDot + 1);
                    }
                    int n = decimalDot = secondDot == -1 ? firstDot : secondDot;
                    if (decimalDot != -1) {
                        int j = 0;
                        while (j < sNumber.length()) {
                            String character = sNumber.substring(j, j + 1);
                            if (ParserUtils.isInteger(character)) {
                                result.append(character);
                            } else if (decimalDot == j) {
                                result.append(".");
                            }
                            ++j;
                        }
                        if (!result.equals("")) {
                            try {
                                BigDecimal dresult = new BigDecimal(result.toString());
                                listResult.add(dresult);
                            }
                            catch (Exception dresult) {
                                // empty catch block
                            }
                            result.delete(0, result.length());
                        }
                    } else {
                        try {
                            int intValue = Integer.parseInt(sNumber);
                            BigDecimal dresult = new BigDecimal(intValue);
                            listResult.add(dresult);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                i += sNumber.length() - 1;
            }
            ++i;
        }
        return listResult;
    }

    protected void missValueCalcul() {
        if (this.invoice.getAmount() == null) {
            if (this.invoice.getAmountWithTax() != null && this.invoice.getTax() != null) {
                BigDecimal amount = this.invoice.getAmountWithTax().subtract(this.invoice.getTax());
                this.invoice.setAmount(amount);
                this.invoice.setContainCalculatedValue(true);
            }
        } else if (this.invoice.getAmountWithTax() == null) {
            if (this.invoice.getAmount() != null && this.invoice.getTax() != null) {
                BigDecimal amountWithTax = this.invoice.getAmount().add(this.invoice.getTax());
                this.invoice.setAmountWithTax(amountWithTax);
                this.invoice.setContainCalculatedValue(true);
            }
        } else if (this.invoice.getTax() == null && this.invoice.getAmount() != null && this.invoice.getAmountWithTax() != null) {
            BigDecimal tax = this.invoice.getAmountWithTax().subtract(this.invoice.getAmount());
            this.invoice.setTax(tax);
            this.invoice.setContainCalculatedValue(true);
        }
    }
}

