/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.contract.injector;

import java.util.List;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;

public class DevisContratClientSQLInjector
extends SQLInjector {
    public DevisContratClientSQLInjector(DBRoot root) {
        super(root, "DEVIS", "CONTRACT", false);
        SQLTable tableDevis = this.getSource();
        SQLTable tableFactContrat = this.getDestination();
        this.map(tableDevis.getField("ID_CLIENT"), tableFactContrat.getField("ID_CLIENT"));
        this.map(tableDevis.getField("ID_CONTACT"), tableFactContrat.getField("ID_CONTACT"));
        this.map(tableDevis.getField("NUMERO"), tableFactContrat.getField("REFERENCE"));
        this.map(tableDevis.getField("ID_COMMERCIAL"), tableFactContrat.getField("ID_COMMERCIAL"));
        if (tableDevis.contains("CONTRACT_DATE_FIN")) {
            this.map(tableDevis.getField("CONTRACT_DATE_FIN"), tableFactContrat.getField("ACTUAL_END_DATE"));
        }
        if (tableDevis.contains("CONTRACT_DATE_DEBUT")) {
            this.map(tableDevis.getField("CONTRACT_DATE_DEBUT"), tableFactContrat.getField("START_DATE"));
        }
        if (tableDevis.contains("CONTRACT_INDICE_0")) {
            this.map(tableDevis.getField("CONTRACT_INDICE_0"), tableFactContrat.getField("INDICE_0"));
        }
        if (tableDevis.contains("CONTRACT_DATE_REX")) {
            this.map(tableDevis.getField("CONTRACT_DATE_REX"), tableFactContrat.getField("DATE_REX"));
        }
        if (tableDevis.contains("CONTRACT_DATE_THERMO") && tableFactContrat.contains("DATE_THERMO")) {
            this.map(tableDevis.getField("CONTRACT_DATE_THERMO"), tableFactContrat.getField("DATE_THERMO"));
        }
        if (tableDevis.contains("CONTRACT_DATE_FOURNITURE")) {
            this.map(tableDevis.getField("CONTRACT_DATE_FOURNITURE"), tableFactContrat.getField("DATE_FOURNITURE"));
        }
        if (tableDevis.contains("CONTRACT_TACITE")) {
            this.map(tableDevis.getField("CONTRACT_TACITE"), tableFactContrat.getField("AUTO_RENEW"));
        }
        if (tableDevis.contains("CONTRACT_TYPE")) {
            this.map(tableDevis.getField("CONTRACT_TYPE"), tableFactContrat.getField("TYPE"));
        }
    }

    protected void merge(SQLRowAccessor srcRow, SQLRowValues rowVals) {
        super.merge(srcRow, rowVals);
        SQLTable tableElementSource = this.getSource().getTable("DEVIS_ELEMENT");
        SQLTable tableElementDestination = this.getSource().getTable("CONTRACT_ELEMENT");
        List myListItem = srcRow.asRow().getReferentRows(tableElementSource);
        this.transfertReference(srcRow, rowVals, tableElementDestination, "ID_CONTRACT", "REFERENCE", "OBJET");
        if (myListItem.size() != 0) {
            SQLRowAccessor nonEmptyForeignModele;
            if (srcRow.getTable().contains("ID_MODELE_COURRIER_CLIENT") && (nonEmptyForeignModele = srcRow.getNonEmptyForeign("ID_MODELE_COURRIER_CLIENT")) != null) {
                rowVals.put("TYPE", (Object)nonEmptyForeignModele.getString("NOM"));
            }
            SQLInjector injector = SQLInjector.getInjector((SQLTable)tableElementSource, (SQLTable)tableElementDestination);
            for (SQLRowAccessor rowElt : myListItem) {
                SQLRowValues createRowValuesFrom = injector.createRowValuesFrom(rowElt.asRow());
                createRowValuesFrom.put("ID_CONTRACT", (Object)rowVals);
            }
        }
    }
}

