/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.contract.injector;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.UndefinedRowValuesCache;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.i18n.Grammar;
import org.openconcerto.utils.i18n.VariantKey;

public class ContratFactureClientSQLInjector
extends SQLInjector {
    DateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");

    public ContratFactureClientSQLInjector(DBRoot root) {
        super(root, "CONTRACT", "SAISIE_VENTE_FACTURE", false);
        SQLTable tableContrat = this.getSource();
        SQLTable tableFacture = this.getDestination();
        this.createDefaultMap();
        this.map(tableContrat.getField("ID_CLIENT"), tableFacture.getField("ID_CLIENT"));
        this.map(tableContrat.getField("ID_COMMERCIAL"), tableFacture.getField("ID_COMMERCIAL"));
        if (tableContrat.contains("ID_TAXE_PORT")) {
            this.map(tableContrat.getField("ID_TAXE_PORT"), tableFacture.getField("ID_TAXE_PORT"));
        } else {
            this.mapDefaultValues(tableFacture.getField("ID_TAXE_PORT"), TaxeCache.getCache().getFirstTaxe().getID());
        }
    }

    protected void merge(SQLRowAccessor srcRow, SQLRowValues rowVals) {
        super.merge(srcRow, rowVals);
        SQLTable tableElementSource = this.getSource().getTable("CONTRACT_ELEMENT");
        SQLTable tableElementDestination = this.getSource().getTable("SAISIE_VENTE_FACTURE_ELEMENT");
        List myListItem = srcRow.asRow().getReferentRows(tableElementSource);
        this.transfertNumberReference(srcRow, rowVals, tableElementDestination, "ID_SAISIE_VENTE_FACTURE");
        this.transfertReference(srcRow, rowVals, tableElementDestination, "ID_SAISIE_VENTE_FACTURE", "REFERENCE", "NOM");
        if (myListItem.size() != 0) {
            BigDecimal indice0Contrat = srcRow.getBigDecimal("INDICE_0");
            SQLInjector injector = SQLInjector.getInjector((SQLTable)tableElementSource, (SQLTable)tableElementDestination);
            for (SQLRowAccessor rowElt : myListItem) {
                SQLRow asRow = rowElt.asRow();
                if (asRow.getInt("NIVEAU") <= 0) continue;
                SQLRowValues createRowValuesFrom = injector.createRowValuesFrom(asRow);
                Long indice0 = (Long)createRowValuesFrom.getObjectAs("INDICE_0", Long.class);
                if (indice0 == null && indice0Contrat != null) {
                    createRowValuesFrom.put("INDICE_0", (Object)indice0Contrat.movePointRight(2).setScale(2, RoundingMode.HALF_UP).longValue());
                }
                createRowValuesFrom.put("PV_U_DEVISE", createRowValuesFrom.getObject("PV_HT"));
                createRowValuesFrom.put("PRIX_METRIQUE_VT_1", createRowValuesFrom.getObject("PV_HT"));
                createRowValuesFrom.put("PRIX_METRIQUE_HA_1", createRowValuesFrom.getObject("PA_HT"));
                if (createRowValuesFrom.getTable().getFieldsName().contains("POURCENT_ACOMPTE") && createRowValuesFrom.getObject("POURCENT_ACOMPTE") == null) {
                    createRowValuesFrom.put("POURCENT_ACOMPTE", (Object)new BigDecimal(100.0));
                }
                createRowValuesFrom.put("ID_SAISIE_VENTE_FACTURE", (Object)rowVals);
            }
        }
    }

    protected void transfertNumberReference(SQLRowAccessor srcRow, SQLRowValues rowVals, SQLTable tableElementDestination, String refField) {
        SQLPreferences prefs = SQLPreferences.getMemCached((DBRoot)srcRow.getTable().getDBRoot());
        if (!prefs.getBoolean("TransfertNoRef", false)) {
            if (prefs.getBoolean("TransfertRef", true)) {
                String label = rowVals.getString("REFERENCE");
                if (label != null && label.trim().length() > 0) {
                    String value = String.valueOf(label) + ", " + srcRow.getString("NUMBER");
                    rowVals.put("NOM", (Object)value);
                } else {
                    rowVals.put("NOM", (Object)srcRow.getString("NUMBER"));
                }
            }
            if (prefs.getBoolean("TransfertMultiRef", false)) {
                SQLRowValues rowValsHeader = new SQLRowValues(UndefinedRowValuesCache.getInstance().getDefaultRowValues(tableElementDestination));
                rowValsHeader.put("ID_STYLE", 3);
                SQLElement element = Configuration.getInstance().getDirectory().getElement(this.getSource());
                if (element == null) {
                    element = Configuration.getInstance().getDirectory().getElement(this.getSource().getName());
                }
                String elementName = StringUtils.firstUp((String)element.getName().getVariant((VariantKey)Grammar.SINGULAR));
                rowValsHeader.put("NOM", (Object)(String.valueOf(elementName) + "\n N\u00b0 " + srcRow.getString("NUMERO") + " du " + this.dateFormat.format(srcRow.getDate("DATE").getTime())));
                rowValsHeader.put(refField, (Object)rowVals);
                if (rowValsHeader.getTable().getName().equalsIgnoreCase("SAISIE_VENTE_FACTURE_ELEMENT")) {
                    SQLRowValues rowValsHeaderRef = new SQLRowValues(UndefinedRowValuesCache.getInstance().getDefaultRowValues(tableElementDestination));
                    rowValsHeaderRef.put("ID_STYLE", 3);
                    if (srcRow.getTable().getName().equalsIgnoreCase("DEVIS")) {
                        rowValsHeaderRef.put("NOM", (Object)srcRow.getString("OBJET"));
                    } else {
                        rowValsHeaderRef.put("NOM", (Object)srcRow.getString("REFERENCE"));
                    }
                    rowValsHeaderRef.put(refField, (Object)rowVals);
                }
            }
        }
    }
}

