/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.contract.injector;

import java.math.BigDecimal;
import java.util.List;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;

public class ContratDevisClientSQLInjector
extends SQLInjector {
    public ContratDevisClientSQLInjector(DBRoot root) {
        super(root, "CONTRACT", "DEVIS", false);
        SQLTable tableContrat = this.getSource();
        SQLTable tableFacture = this.getDestination();
        this.map(tableContrat.getField("ID_CLIENT"), tableFacture.getField("ID_CLIENT"));
        this.map(tableContrat.getField("ID_CONTACT"), tableFacture.getField("ID_CONTACT"));
        this.map(tableContrat.getField("ID_COMMERCIAL"), tableFacture.getField("ID_COMMERCIAL"));
        if (tableContrat.contains("ID_TAXE_PORT")) {
            this.map(tableContrat.getField("ID_TAXE_PORT"), tableFacture.getField("ID_TAXE_PORT"));
        } else {
            this.mapDefaultValues(tableFacture.getField("ID_TAXE_PORT"), TaxeCache.getCache().getFirstTaxe().getID());
        }
        if (tableFacture.contains("CONTRACT_TACITE")) {
            this.map(tableContrat.getField("AUTO_RENEW"), tableFacture.getField("CONTRACT_TACITE"));
        }
        if (tableFacture.contains("CONTRACT_TYPE")) {
            this.map(tableContrat.getField("TYPE"), tableFacture.getField("CONTRACT_TYPE"));
        }
    }

    protected void merge(SQLRowAccessor srcRow, SQLRowValues rowVals) {
        super.merge(srcRow, rowVals);
        SQLTable tableElementSource = this.getSource().getTable("CONTRACT_ELEMENT");
        SQLTable tableElementDestination = this.getSource().getTable("DEVIS_ELEMENT");
        List myListItem = srcRow.asRow().getReferentRows(tableElementSource);
        this.transfertReference(srcRow, rowVals, tableElementDestination, "ID_DEVIS", "REFERENCE", "OBJET");
        if (myListItem.size() != 0) {
            SQLInjector injector = SQLInjector.getInjector((SQLTable)tableElementSource, (SQLTable)tableElementDestination);
            for (SQLRowAccessor rowElt : myListItem) {
                SQLRowValues createRowValuesFrom = injector.createRowValuesFrom(rowElt.asRow());
                createRowValuesFrom.put("PV_U_DEVISE", createRowValuesFrom.getObject("PV_HT"));
                createRowValuesFrom.put("PRIX_METRIQUE_VT_1", createRowValuesFrom.getObject("PV_HT"));
                createRowValuesFrom.put("PRIX_METRIQUE_HA_1", createRowValuesFrom.getObject("PA_HT"));
                if (createRowValuesFrom.getTable().getFieldsName().contains("POURCENT_ACOMPTE") && createRowValuesFrom.getObject("POURCENT_ACOMPTE") == null) {
                    createRowValuesFrom.put("POURCENT_ACOMPTE", (Object)new BigDecimal(100.0));
                }
                createRowValuesFrom.put("ID_DEVIS", (Object)rowVals);
            }
        }
    }
}

