/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.contract;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.util.Date;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import org.openconcerto.ui.TimestampEditorPanel;

public class TimestampCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    protected static final String EDIT = "edit";
    protected static final DateFormat DATE_FMT = DateFormat.getDateInstance(2);
    protected static final DateFormat DATETIME_FMT = DateFormat.getDateTimeInstance(2, 3);
    private final TimestampEditorPanel panel;
    private final JButton button = new JButton();
    private final DateFormat dateFmt;
    private JDialog jDialog;
    private Date currentTime;

    public TimestampCellEditor(boolean hourVisible) {
        this.button.setActionCommand(EDIT);
        this.button.addActionListener(this);
        this.button.setBorderPainted(false);
        this.dateFmt = hourVisible ? DATETIME_FMT : DATE_FMT;
        this.panel = new TimestampEditorPanel(false, (ActionListener)this);
        this.panel.setHourVisible(hourVisible);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (EDIT.equals(e.getActionCommand())) {
            this.panel.setTime(this.currentTime);
            this.jDialog = new JDialog(SwingUtilities.getWindowAncestor((Component)e.getSource()), Dialog.ModalityType.DOCUMENT_MODAL);
            this.jDialog.add((Component)this.panel);
            this.jDialog.pack();
            this.jDialog.setLocationRelativeTo((Component)e.getSource());
            this.jDialog.setVisible(true);
            this.fireEditingStopped();
        } else {
            this.currentTime = this.panel.getDate();
            this.jDialog.dispose();
        }
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        if (e instanceof MouseEvent) {
            return ((MouseEvent)e).getClickCount() >= 2;
        }
        return true;
    }

    @Override
    public Date getCellEditorValue() {
        return this.currentTime;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.currentTime = (Date)value;
        this.button.setText(this.dateFmt.format(this.currentTime));
        return this.button;
    }
}

