/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.contract;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.IListTotalPanel;
import org.openconcerto.erp.core.customerrelationship.mail.EmailCreator;
import org.openconcerto.erp.core.customerrelationship.mail.EmailTemplate;
import org.openconcerto.erp.core.customerrelationship.mail.ValueListener;
import org.openconcerto.erp.core.edm.Attachment;
import org.openconcerto.erp.core.edm.AttachmentUtils;
import org.openconcerto.erp.core.sales.quote.report.DevisXmlSheet;
import org.openconcerto.erp.modules.AbstractModule;
import org.openconcerto.erp.modules.AlterTableRestricted;
import org.openconcerto.erp.modules.DBContext;
import org.openconcerto.erp.modules.MenuContext;
import org.openconcerto.erp.modules.ModuleFactory;
import org.openconcerto.erp.modules.ModuleVersion;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.modules.contract.ContractBillingPanel;
import org.openconcerto.modules.contract.ContractBillingPeriodSQLElement;
import org.openconcerto.modules.contract.ContractElementSQLElement;
import org.openconcerto.modules.contract.ContractSQLElement;
import org.openconcerto.modules.contract.ContratDEvisClientSheet;
import org.openconcerto.modules.contract.injector.ContratDevisClientSQLInjector;
import org.openconcerto.modules.contract.injector.ContratDevisEltSQLInjector;
import org.openconcerto.modules.contract.injector.ContratFactureClientSQLInjector;
import org.openconcerto.modules.contract.injector.ContratFactureEltSQLInjector;
import org.openconcerto.modules.contract.injector.DevisContratClientSQLInjector;
import org.openconcerto.modules.contract.injector.DevisEltContratEltSQLInjector;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.utils.AlterTable;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanelListener;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.IListPanel;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.action.SQLRowValuesAction;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.EmailComposer;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.ITransformer;

public final class Module
extends AbstractModule {
    public Module(ModuleFactory f) throws IOException {
        super(f);
    }

    protected void install(DBContext ctxt) throws SQLException, IOException {
        SQLCreateTable createTable;
        ModuleVersion installedVersion;
        super.install(ctxt);
        ModuleVersion moduleVersion = installedVersion = ctxt.getLastInstalledVersion() == null ? ModuleVersion.MIN : ctxt.getLastInstalledVersion();
        if (installedVersion.compareTo(ModuleVersion.MIN) <= 0) {
            createTable = ContractSQLElement.getCreateTable(ctxt);
            SQLCreateTable createTable2 = ContractBillingPeriodSQLElement.getCreateTable(ctxt, createTable);
            ctxt.executeSQL();
        }
        if (!ctxt.getRoot().contains("CONTRACT_ELEMENT")) {
            createTable = ContractElementSQLElement.getCreateTable(ctxt);
            ctxt.executeSQL();
            AlterTableRestricted alterTable = ctxt.getAlterTable("DEVIS");
            alterTable.addForeignColumn("ID_CONTRACT", ctxt.getRoot().getTable("CONTRACT"));
            alterTable.addForeignColumn("ID_MODELE_COURRIER_CLIENT", ctxt.getRoot().getTable("MODELE_COURRIER_CLIENT"));
            alterTable.addColumn("CONTRACT_DATE_DEBUT", "date");
            alterTable.addColumn("CONTRACT_DATE_FIN", "date");
            alterTable.addDecimalColumn("CONTRACT_INDICE_0", 8, 2, BigDecimal.ZERO, false);
            ctxt.executeSQL();
        }
    }

    protected void setupElements(SQLElementDirectory dir) {
        super.setupElements(dir);
        ContractSQLElement elemContrat = new ContractSQLElement(this);
        dir.addSQLElement((SQLElement)elemContrat);
        dir.addSQLElement((SQLElement)new ContractBillingPeriodSQLElement(this));
        dir.addSQLElement((SQLElement)new ContractElementSQLElement(this));
        ComptaPropsConfiguration.getInstanceCompta().getFieldMapper().addMapperStreamFromClass(Module.class);
        DBRoot dbRoot = dir.getElement("SAISIE_VENTE_FACTURE").getTable().getDBRoot();
        new ContratFactureEltSQLInjector(dbRoot);
        new ContratFactureClientSQLInjector(dbRoot);
        new ContratDevisEltSQLInjector(dbRoot);
        new ContratDevisClientSQLInjector(dbRoot);
        new DevisEltContratEltSQLInjector(dbRoot);
        new DevisContratClientSQLInjector(dbRoot);
        SQLRowValuesAction.PredicateRowAction trDevisContrat = new SQLRowValuesAction.PredicateRowAction(false, "tr.devis.contract.action", e -> {
            final SQLRowValues devisRowValues = e.getSelectedRow().asRowValues(Boolean.valueOf(false));
            EditFrame editFrame = new EditFrame((SQLElement)elemContrat);
            SQLComponent sqlComponent = editFrame.getSQLComponent();
            final SQLRowValues rowVals = new SQLRowValues(devisRowValues.getTable());
            for (SQLField rk : rowVals.getTable().getDBSystemRoot().getGraph().getReferentKeys(rowVals.getTable())) {
                Set referentRows = devisRowValues.getReferentRows(rk);
                if (referentRows.size() <= 1) continue;
                Iterator iter = new ArrayList(referentRows).iterator();
                iter.next();
                while (iter.hasNext()) {
                    SQLRowValues ref = (SQLRowValues)iter.next();
                    ref.remove(rk.getName());
                }
            }
            for (SQLRowValues r : rowVals.getGraph().getItems()) {
                HashSet fields = new HashSet(r.getTable().getFieldsName());
                fields.removeAll(r.getFields());
                r.putNulls(fields, false);
            }
            SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create((SQLRowValues)rowVals);
            fetcher.setSelTransf((ITransformer)new ITransformer<SQLSelect, SQLSelect>(){

                public SQLSelect transformChecked(SQLSelect input) {
                    input.setWhere(new Where((FieldRef)rowVals.getTable().getKey(), "=", devisRowValues.getID()));
                    return input;
                }
            });
            List referentRows = e.getSelectedRow().asRow().getReferentRows(devisRowValues.getTable().getTable("DEVIS_ELEMENT").getField("ID_DEVIS"));
            int option = 0;
            for (SQLRow sqlRow : referentRows) {
                if (sqlRow.getInt("NIVEAU") != -1) continue;
                ++option;
            }
            if (option > 0) {
                JOptionPane.showConfirmDialog(null, "Attention le contrat contient des options, pensez \u00e0 v\u00e9rifier si le client les a valid\u00e9s.");
            }
            List result = fetcher.fetch();
            SQLInjector injector = SQLInjector.getInjector((SQLTable)devisRowValues.getTable(), (SQLTable)elemContrat.getTable());
            SQLRowValues rValues = injector.createRowValuesFrom(result);
            sqlComponent.select((SQLRowAccessor)rValues);
            FrameUtil.show((Window)editFrame);
            editFrame.addEditPanelListener(new EditPanelListener(){

                public void modified() {
                }

                public void inserted(int id) {
                    try {
                        devisRowValues.createEmptyUpdateRow().put("ID_ETAT_DEVIS", 4).put("ID_CONTRACT", id).update();
                    }
                    catch (SQLException e) {
                        ExceptionHandler.handle((String)"Erreur lors du rattachement du devis au contrat", (Throwable)e);
                    }
                }

                public void deleted() {
                }

                public void cancelled() {
                }
            });
        });
        trDevisContrat.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        SQLElement elementDEvis = dir.getElement("DEVIS");
        elementDEvis.getRowValuesActions().add(trDevisContrat);
        SQLRowValuesAction.PredicateRowAction actionContrat = new SQLRowValuesAction.PredicateRowAction(false, a -> {
            SQLRowAccessor selectedRowAccessor = a.getSelectedRow();
            ContratDEvisClientSheet sheet = new ContratDEvisClientSheet(selectedRowAccessor.fetchNewRow());
            String printer = PrinterNXProps.getInstance().getStringProperty("DevisPrinter");
            sheet.generate(false, true, printer, true);
        });
        actionContrat.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        actionContrat.setName("G\u00e9n\u00e9rer le contrat");
        elementDEvis.getRowValuesActions().add(actionContrat);
        elementDEvis.putAdditionalField("ID_MODELE_COURRIER_CLIENT");
        if (elementDEvis.getTable().contains("CONTRACT_DATE_DEBUT")) {
            elementDEvis.putAdditionalField("CONTRACT_DATE_DEBUT");
            elementDEvis.putAdditionalField("CONTRACT_INDICE_0");
            elementDEvis.putAdditionalField("CONTRACT_DATE_FIN");
        }
        SQLRowValuesAction.PredicateRowAction actionSendContrat = new SQLRowValuesAction.PredicateRowAction(false, a -> {
            final SQLRowAccessor selectedRowAccessor = a.getSelectedRow();
            EmailTemplate.askTemplate((Component)((Component)a.getSource()), (DBRoot)a.getSelectedRow().getTable().getDBRoot(), (String)a.getSelectedRow().getTable().getName(), (ValueListener)new ValueListener(){

                public void valueSelected(Object value) {
                    final EmailTemplate template = (EmailTemplate)value;
                    Thread t = new Thread(){

                        @Override
                        public void run() {
                            ContratDEvisClientSheet sheetContract;
                            ListMap mailFilesMap = new ListMap();
                            SQLRow fetchNewRow = selectedRowAccessor.fetchNewRow();
                            if (!fetchNewRow.isForeignEmpty("ID_MODELE_COURRIER_CLIENT")) {
                                sheetContract = new ContratDEvisClientSheet(fetchNewRow);
                                String printer = PrinterNXProps.getInstance().getStringProperty("DevisPrinter");
                                sheetContract.generate(false, false, printer, false);
                                sheetContract.exportToPdf(true);
                            } else {
                                sheetContract = null;
                            }
                            final DevisXmlSheet sheetDevis = new DevisXmlSheet(fetchNewRow);
                            String mail = "";
                            SQLRow row = sheetDevis.getSQLRow();
                            Set setContact = null;
                            SQLTable tableContact = Configuration.getInstance().getRoot().findTable("CONTACT");
                            setContact = row.getTable().getForeignKeys(tableContact);
                            Set setClient = null;
                            SQLTable tableClient = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getTable("CLIENT");
                            setClient = row.getTable().getForeignKeys(tableClient);
                            for (SQLField field : setContact) {
                                if (mail != null && mail.trim().length() != 0) continue;
                                mail = row.getForeignRow(field.getName()).getString("EMAIL");
                            }
                            String nomClient = "";
                            if (setClient != null && (mail == null || mail.trim().length() == 0)) {
                                for (SQLField field : setClient) {
                                    SQLRow rowCli = row.getForeignRow(field.getName());
                                    if (mail == null || mail.trim().length() == 0) {
                                        mail = rowCli.getString("MAIL");
                                    }
                                    nomClient = rowCli.getString("NOM");
                                }
                            }
                            if (mail.trim().length() == 0) {
                                mail = nomClient;
                            }
                            try {
                                mailFilesMap.add((Object)mail, (Object)Tuple2.create((Object)row, (Object)sheetDevis.getOrCreatePDFDocumentFile(true).getAbsoluteFile()));
                            }
                            catch (Exception e) {
                                ExceptionHandler.handle((String)"Impossible de charger le document PDF", (Throwable)e);
                            }
                            for (final String mailDest : mailFilesMap.keySet()) {
                                final List tuples = (List)mailFilesMap.get((Object)mailDest);
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            String subject = sheetDevis.getReference();
                                            if (template != null) {
                                                subject = String.valueOf(template.getTitle()) + " " + sheetDevis.getReference().trim();
                                            }
                                            subject = subject.trim();
                                            StringJoiner joiner = new StringJoiner(", ");
                                            ArrayList<File> files = new ArrayList<File>();
                                            for (Tuple2 f : tuples) {
                                                joiner.add(((File)f.get1()).getName());
                                                files.add((File)f.get1());
                                            }
                                            if (subject.isEmpty()) {
                                                subject = joiner.toString();
                                            }
                                            String message = "";
                                            if (template != null) {
                                                message = template.getText().contains("{message}") ? template.getText().replace("{message}", message) : String.valueOf(message) + template.getText();
                                            }
                                            if (template != null) {
                                                ArrayList<SQLRow> rows = new ArrayList<SQLRow>();
                                                for (Tuple2 f : tuples) {
                                                    rows.add((SQLRow)f.get0());
                                                }
                                                EmailCreator creator = new EmailCreator(template, rows, joiner.toString());
                                                subject = creator.getObject();
                                                message = creator.getValue();
                                                Set attachments = template.getAttachments();
                                                AttachmentUtils utils = new AttachmentUtils();
                                                for (Attachment a : attachments) {
                                                    File file = utils.getFile(a);
                                                    File createTempFile = new File(file.getParent(), a.getFileName());
                                                    createTempFile.delete();
                                                    file.renameTo(createTempFile);
                                                    files.add(createTempFile);
                                                }
                                            }
                                            if (sheetContract != null) {
                                                files.add(sheetContract.getPDFDocumentFile());
                                            }
                                            EmailComposer.getInstance().compose(mailDest, subject, message, files.toArray(new File[files.size()]));
                                        }
                                        catch (Exception e) {
                                            ExceptionHandler.handle((String)"Impossible d'envoyer le courriel!", (Throwable)e);
                                        }
                                    }
                                });
                            }
                        }
                    };
                    t.start();
                }
            });
        });
        actionSendContrat.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        actionSendContrat.setName("Envoyer le contrat et le devis");
        elementDEvis.getRowValuesActions().add(actionSendContrat);
    }

    protected void setupMenu(final MenuContext ctxt) {
        ctxt.addMenuItem((Action)new AbstractAction("G\u00e9rer les contrats"){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFrame f = new JFrame("Liste des contrats");
                SQLElement elementContract = ctxt.getElement("CONTRACT");
                ListeAddPanel panel = new ListeAddPanel(elementContract);
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                c.gridwidth = 0;
                c.anchor = 13;
                c.weightx = 0.0;
                c.gridy = 4;
                JPanel bottomPanel = new JPanel();
                bottomPanel.setLayout(new GridBagLayout());
                bottomPanel.setOpaque(false);
                DefaultGridBagConstraints c2 = new DefaultGridBagConstraints();
                c2.fill = 0;
                c2.weightx = 1.0;
                ArrayList<Tuple2> fields = new ArrayList<Tuple2>(2);
                fields.add(Tuple2.create((Object)panel.getListe().getSource().getColumn(elementContract.getTable().getField("TOTAL_AMOUNT")), (Object)IListTotalPanel.Type.SOMME));
                IListTotalPanel totalPanelSel = new IListTotalPanel(panel.getListe(), fields, null, null, "S\u00e9lection", true);
                ++c2.gridx;
                c2.weightx = 0.0;
                c2.anchor = 13;
                bottomPanel.add((Component)totalPanelSel, c2);
                IListTotalPanel totalPanel = new IListTotalPanel(panel.getListe(), fields, null, "Total");
                ++c2.gridx;
                c2.weightx = 0.0;
                c2.anchor = 13;
                bottomPanel.add((Component)totalPanel, c2);
                panel.add((Component)bottomPanel, (Object)c);
                IListFrame frame = new IListFrame((IListPanel)panel);
                FrameUtil.showPacked((Frame)frame);
            }
        }, "menu.list");
        ctxt.addMenuItem((Action)new AbstractAction("Suivi des contrats actifs"){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFrame f = new JFrame("Suivi des contrats");
                ComptaPropsConfiguration conf = ComptaPropsConfiguration.getInstanceCompta();
                ContractBillingPanel p = new ContractBillingPanel(conf);
                f.setContentPane(p);
                f.pack();
                f.setMinimumSize(new Dimension(f.getWidth(), f.getHeight()));
                f.setSize(new Dimension(f.getWidth() + 50, f.getHeight()));
                f.setLocationRelativeTo(null);
                f.setVisible(true);
                p.scheduleReload();
            }
        }, "menu.list");
    }

    protected void start() {
        AlterTable alterTable;
        DBRoot rootSociete = ComptaPropsConfiguration.getInstanceCompta().getRootSociete();
        SQLTable tableContrat = rootSociete.getTable("CONTRACT");
        if (!rootSociete.getTable("DEVIS").contains("ID_CONTRACT")) {
            alterTable = new AlterTable(rootSociete.getTable("DEVIS"));
            alterTable.addForeignColumn("ID_CONTRACT", rootSociete.getTable("CONTRACT"));
            rootSociete.getDBSystemRoot().getDataSource().execute(alterTable.asString());
            try {
                rootSociete.getSchema().updateVersion();
                rootSociete.refetchTable("DEVIS");
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (!tableContrat.contains("INDICE_0")) {
            alterTable = new AlterTable(tableContrat);
            alterTable.addDecimalColumn("INDICE_0", 8, 2, null, true);
            try {
                rootSociete.getDBSystemRoot().getDataSource().execute(alterTable.asString());
                rootSociete.getSchema().updateVersion();
                rootSociete.refetchTable(tableContrat.getName());
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (!tableContrat.contains("ID_CONTACT")) {
            alterTable = new AlterTable(tableContrat);
            alterTable.addForeignColumn("ID_CONTACT", rootSociete.getTable("CONTACT"));
            try {
                rootSociete.getDBSystemRoot().getDataSource().execute(alterTable.asString());
                rootSociete.getSchema().updateVersion();
                rootSociete.refetchTable(tableContrat.getName());
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    protected void stop() {
    }
}

