/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.contract;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.erp.generationDoc.AbstractJOOReportsSheet;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.StringUtils;

public class ContratSheet
extends AbstractJOOReportsSheet {
    private SQLRow rowContrat;
    public static final String TEMPLATE_ID = "Contrat";
    public static final String TEMPLATE_PROPERTY_NAME = "LocationCourrier";

    public ContratSheet(SQLRow row) {
        this.rowContrat = row;
        Date d = (Date)this.rowContrat.getObject("START_DATE");
        String year = this.yearFormat.format(d);
        String modele = "Contrat.odt";
        this.init(year, modele, "CourrierPrinter");
    }

    public String getDefaultTemplateID() {
        return TEMPLATE_ID;
    }

    public String getDefaultLocationProperty() {
        return TEMPLATE_PROPERTY_NAME;
    }

    protected Map<String, Object> createMap() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("Num\u00e9ro", this.rowContrat.getString("NUMBER"));
        m.put("Reference", this.rowContrat.getString("REFERENCE"));
        m.put("MontantHT", this.rowContrat.getString("TOTAL_AMOUNT"));
        m.put("IndiceSyntec0", this.rowContrat.getString("INDICE_0"));
        Calendar dateDeb = this.rowContrat.getDate("START_DATE");
        if (dateDeb != null) {
            m.put("DateDebut", this.dateFormat.format(dateDeb.getTime()));
        } else {
            m.put("DateDebut", "");
        }
        Calendar dateFin = this.rowContrat.getDate("ACTUAL_END_DATE");
        if (dateFin != null) {
            m.put("DateFin", this.dateFormat.format(dateFin.getTime()));
        } else {
            m.put("DateFin", "");
        }
        SQLRowAccessor rowContactCom = this.rowContrat.getNonEmptyForeign("ID_CONTACT");
        SQLRow rowClient = this.rowContrat.getForeign("ID_CLIENT");
        if (rowContactCom != null) {
            SQLRowAccessor rowTitre = rowContactCom.getNonEmptyForeign("ID_TITRE_PERSONNEL");
            String correspondant = rowTitre.getString("NOM");
            String contact = rowTitre.getString("NOM");
            contact = String.valueOf(contact) + " " + rowContactCom.getString("PRENOM");
            contact = String.valueOf(contact) + " " + rowContactCom.getString("NOM");
            m.put("Correspondant", correspondant);
            m.put("Contact", contact);
            m.put("contactNom", rowContactCom.getString("NOM"));
            m.put("contactPrenom", rowContactCom.getString("PRENOM"));
            m.put("contactTelephone", rowContactCom.getString("TEL_DIRECT"));
            m.put("contactMail", rowContactCom.getString("EMAIL"));
            m.put("contactFonction", rowContactCom.getString("FONCTION"));
            if (rowTitre != null) {
                m.put("contactTitre", rowTitre.getString("NOM"));
                m.put("contactTitreCode", rowTitre.getString("CODE"));
            }
        } else {
            m.put("contactNom", rowClient.getString("RESPONSABLE"));
            m.put("contactMail", rowClient.getString("MAIL"));
            m.put("contactTelephone", rowClient.getString("TEL"));
        }
        m.put("clientFormejuridique", rowClient.getString("FORME_JURIDIQUE"));
        String siret = rowClient.getString("SIRET");
        m.put("clientSiret", siret);
        m.put("clientSiren", StringUtils.limitLength((String)siret.replaceAll(" ", ""), (int)9));
        if (rowClient.getTable().contains("RCS")) {
            m.put("clientRcs", rowClient.getString("RCS"));
        }
        if (rowClient.getTable().contains("APE")) {
            m.put("clientApe", rowClient.getString("APE"));
        }
        if (rowClient.getTable().contains("CAPITAL")) {
            m.put("clientCapital", rowClient.getString("CAPITAL"));
        }
        m.put("clientResponsable", rowClient.getString("RESPONSABLE"));
        m.put("clientNom", rowClient.getString("NOM"));
        m.put("clientMail", rowClient.getString("MAIL"));
        m.put("clientTelephone", rowClient.getString("TEL"));
        SQLRow rowAdresseClient = rowClient.getForeignRow("ID_ADRESSE");
        m.put("clientDestinataire", rowAdresseClient.getString("DEST"));
        m.put("clientAdresse", rowAdresseClient.getString("RUE"));
        m.put("clientCodePostal", rowAdresseClient.getString("CODE_POSTAL"));
        String villeCli = rowAdresseClient.getString("VILLE");
        Object cedexCli = rowAdresseClient.getObject("CEDEX");
        boolean hasCedexCli = rowAdresseClient.getBoolean("HAS_CEDEX");
        if (hasCedexCli) {
            villeCli = String.valueOf(villeCli) + " CEDEX";
            if (cedexCli != null && cedexCli.toString().trim().length() > 0) {
                villeCli = String.valueOf(villeCli) + " " + cedexCli.toString().trim();
            }
        }
        m.put("clientVille", villeCli);
        if (this.rowContrat.contains("CLEARING_AOE")) {
            if (this.rowContrat.getObject("CLEARING_AOE") != null) {
                int aoe = this.rowContrat.getInt("CLEARING_AOE");
                m.put("clearingAOE", aoe);
            }
            if (this.rowContrat.getObject("REM_EFFACEMENT") != null) {
                int rem = this.rowContrat.getInt("REM_EFFACEMENT");
                m.put("remEffacementPourcent", rem);
            }
        }
        List referentRows = this.rowContrat.getReferentRows(this.rowContrat.getTable().getTable("CONTRACT_ELEMENT").getField("ID_CONTRACT"));
        BigDecimal totalOptionHT = BigDecimal.ZERO;
        BigDecimal totalOptionTTC = BigDecimal.ZERO;
        System.err.println("parse items");
        int idOption = 1;
        for (SQLRow sqlRow : referentRows) {
            if (sqlRow.getInt("NIVEAU") != -1) continue;
            m.put("D\u00e9signationOption" + idOption, sqlRow.getString("NOM"));
            m.put("MontantHTOption" + idOption, sqlRow.getString("T_PV_HT"));
            m.put("MontantTTCOption" + idOption, sqlRow.getString("T_PV_TTC"));
            totalOptionHT = sqlRow.getBigDecimal("T_PV_HT");
            totalOptionTTC = sqlRow.getBigDecimal("T_PV_TTC");
            ++idOption;
        }
        System.err.println(CollectionUtils.join(m.keySet(), (String)"\n"));
        return m;
    }

    protected String getName() {
        return "Contrat_" + this.rowContrat.getID();
    }
}

