/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.contract;

import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.erp.generationDoc.AbstractJOOReportsSheet;
import org.openconcerto.erp.generationDoc.DocumentLocalStorageManager;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.StringUtils;

public class ContratDEvisClientSheet
extends AbstractJOOReportsSheet {
    private SQLRow rowDevis;
    public static final String TEMPLATE_ID = "ContratDevis";
    public static final String TEMPLATE_PROPERTY_NAME = "LocationDevis";

    public ContratDEvisClientSheet(SQLRow row) {
        SQLRowAccessor foreignModele;
        this.rowDevis = row;
        Date d = (Date)this.rowDevis.getObject("DATE");
        String year = this.yearFormat.format(d);
        String modele = "Contrat.odt";
        if (this.rowDevis.getObject("ID_MODELE_COURRIER_CLIENT") != null && (foreignModele = this.rowDevis.getNonEmptyForeign("ID_MODELE_COURRIER_CLIENT")) != null && foreignModele.getString("TEMPLATE_NAME").trim().length() > 0) {
            modele = foreignModele.getString("TEMPLATE_NAME");
        }
        this.init(year, modele, "DevisPrinter");
    }

    public File getDocumentFile() {
        File outputDir = DocumentLocalStorageManager.getInstance().getDocumentOutputDirectory("Devis");
        return new File(outputDir, String.valueOf(this.getFileName()) + ".odt");
    }

    public String getDefaultTemplateID() {
        return TEMPLATE_ID;
    }

    public String getDefaultLocationProperty() {
        return TEMPLATE_PROPERTY_NAME;
    }

    protected Map<String, Object> createMap() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("Num\u00e9ro", this.rowDevis.getString("NUMERO"));
        m.put("Date", this.dateFormat.format(this.rowDevis.getDate("DATE").getTime()));
        if (this.rowDevis.getObject("DATE_VALIDITE") != null) {
            m.put("DateValidite", this.dateFormat.format(this.rowDevis.getDate("DATE_VALIDITE").getTime()));
        } else {
            m.put("DateValidite", "");
        }
        m.put("TotalHT", GestionDevise.currencyToString((long)this.rowDevis.getLong("T_HT")));
        m.put("TotalTVA", GestionDevise.currencyToString((long)this.rowDevis.getLong("T_TVA")));
        m.put("TotalTTC", GestionDevise.currencyToString((long)this.rowDevis.getLong("T_TTC")));
        SQLRowAccessor rowContactCom = this.rowDevis.getNonEmptyForeign("ID_CONTACT");
        SQLRow rowClient = this.rowDevis.getForeign("ID_CLIENT");
        if (rowContactCom != null) {
            SQLRowAccessor rowTitre = rowContactCom.getNonEmptyForeign("ID_TITRE_PERSONNEL");
            String correspondant = rowTitre.getString("NOM");
            String contact = rowTitre.getString("NOM");
            contact = String.valueOf(contact) + " " + rowContactCom.getString("PRENOM");
            contact = String.valueOf(contact) + " " + rowContactCom.getString("NOM");
            m.put("Correspondant", correspondant);
            m.put("Contact", contact);
            m.put("contactNom", rowContactCom.getString("NOM"));
            m.put("contactPrenom", rowContactCom.getString("PRENOM"));
            m.put("contactTelephone", rowContactCom.getString("TEL_DIRECT"));
            m.put("contactMail", rowContactCom.getString("EMAIL"));
            m.put("contactFonction", rowContactCom.getString("FONCTION"));
            if (rowTitre != null) {
                m.put("contactTitre", rowTitre.getString("NOM"));
                m.put("contactTitreCode", rowTitre.getString("CODE"));
            }
        } else {
            m.put("contactNom", rowClient.getString("RESPONSABLE"));
            m.put("contactMail", rowClient.getString("MAIL"));
            m.put("contactTelephone", rowClient.getString("TEL"));
        }
        m.put("clientFormejuridique", rowClient.getString("FORME_JURIDIQUE"));
        String siret = rowClient.getString("SIRET");
        m.put("clientSiret", siret);
        m.put("clientSiren", StringUtils.limitLength((String)siret.replaceAll(" ", ""), (int)9));
        if (rowClient.getTable().contains("RCS")) {
            m.put("clientRcs", rowClient.getString("RCS"));
        }
        if (rowClient.getTable().contains("APE")) {
            m.put("clientApe", rowClient.getString("APE"));
        }
        if (rowClient.getTable().contains("CAPITAL")) {
            m.put("clientCapital", rowClient.getString("CAPITAL"));
        }
        m.put("clientResponsable", rowClient.getString("RESPONSABLE"));
        m.put("clientNom", rowClient.getString("NOM"));
        m.put("clientMail", rowClient.getString("MAIL"));
        m.put("clientTelephone", rowClient.getString("TEL"));
        SQLRow rowAdresseClient = rowClient.getForeignRow("ID_ADRESSE");
        m.put("clientDestinataire", rowAdresseClient.getString("DEST"));
        m.put("clientAdresse", rowAdresseClient.getString("RUE"));
        m.put("clientCodePostal", rowAdresseClient.getString("CODE_POSTAL"));
        String villeCli = rowAdresseClient.getString("VILLE");
        Object cedexCli = rowAdresseClient.getObject("CEDEX");
        boolean hasCedexCli = rowAdresseClient.getBoolean("HAS_CEDEX");
        if (hasCedexCli) {
            villeCli = String.valueOf(villeCli) + " CEDEX";
            if (cedexCli != null && cedexCli.toString().trim().length() > 0) {
                villeCli = String.valueOf(villeCli) + " " + cedexCli.toString().trim();
            }
        }
        m.put("clientVille", villeCli);
        int idAdresse = this.rowDevis.getInt("ID_ADRESSE");
        if (idAdresse > 1) {
            rowAdresseClient = this.rowDevis.getForeignRow("ID_ADRESSE");
            m.put("clientFormejuridique", rowClient.getString("FORME_JURIDIQUE"));
            m.put("clientDestinataire", rowAdresseClient.getString("DEST"));
            m.put("clientAdresse", rowAdresseClient.getString("RUE"));
            m.put("clientCodePostal", rowAdresseClient.getString("CODE_POSTAL"));
            villeCli = rowAdresseClient.getString("VILLE");
            cedexCli = rowAdresseClient.getObject("CEDEX");
            hasCedexCli = rowAdresseClient.getBoolean("HAS_CEDEX");
            if (hasCedexCli) {
                villeCli = String.valueOf(villeCli) + " CEDEX";
                if (cedexCli != null && cedexCli.toString().trim().length() > 0) {
                    villeCli = String.valueOf(villeCli) + " " + cedexCli.toString().trim();
                }
            }
            m.put("clientVille", villeCli);
        }
        List referentRows = this.rowDevis.getReferentRows(this.rowDevis.getTable().getTable("DEVIS_ELEMENT").getField("ID_DEVIS"));
        BigDecimal totalOptionHT = BigDecimal.ZERO;
        BigDecimal totalOptionTTC = BigDecimal.ZERO;
        System.err.println("parse items");
        int idOption = 1;
        for (SQLRow sqlRow : referentRows) {
            if (sqlRow.getInt("NIVEAU") != -1) continue;
            m.put("D\u00e9signationOption" + idOption, sqlRow.getString("NOM"));
            m.put("Qt\u00e9Option" + idOption, sqlRow.getInt("QTE"));
            m.put("MontantHTOption" + idOption, GestionDevise.currencyToString((BigDecimal)sqlRow.getBigDecimal("T_PV_HT")));
            m.put("MontantTTCOption" + idOption, GestionDevise.currencyToString((BigDecimal)sqlRow.getBigDecimal("T_PV_TTC")));
            totalOptionHT = sqlRow.getBigDecimal("T_PV_HT");
            totalOptionTTC = sqlRow.getBigDecimal("T_PV_TTC");
            ++idOption;
        }
        System.err.println("end parse items");
        BigDecimal totalOptionTVA = totalOptionTTC.subtract(totalOptionHT);
        if (this.rowDevis.getTable().contains("DELAI_REALISATION")) {
            m.put("D\u00e9laiR\u00e9alisation", this.rowDevis.getString("DELAI_REALISATION"));
            m.put("ConditionFacturation", this.rowDevis.getString("CONDITIONS_FACTURATION"));
        }
        if (this.rowDevis.getTable().contains("CONTRACT_DATE_DEBUT")) {
            m.put("IndiceSyntec0", this.rowDevis.getString("CONTRACT_INDICE_0"));
            if (this.rowDevis.getObject("CONTRACT_DATE_DEBUT") != null) {
                m.put("DateDebut", this.dateFormat.format(this.rowDevis.getDate("CONTRACT_DATE_DEBUT").getTime()));
            } else {
                m.put("DateDebut", "");
            }
            if (this.rowDevis.getObject("CONTRACT_DATE_FIN") != null) {
                m.put("DateFin", this.dateFormat.format(this.rowDevis.getDate("CONTRACT_DATE_FIN").getTime()));
            } else {
                m.put("DateFin", "");
            }
        }
        ArrayList listKey = new ArrayList(m.keySet());
        Collections.sort(listKey);
        System.err.println(CollectionUtils.join(listKey, (String)"\n"));
        return m;
    }

    protected String getName() {
        return "ContratDevis_" + this.rowDevis.getString("NUMERO");
    }
}

