/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.contract;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.openconcerto.erp.core.common.ui.PanelFrame;
import org.openconcerto.erp.core.customerrelationship.customer.element.ComptaContactSQLElement;
import org.openconcerto.erp.core.customerrelationship.customer.element.CustomerSQLElement;
import org.openconcerto.erp.core.edm.AttachmentPanel;
import org.openconcerto.erp.core.finance.payment.element.SEPAMandateSQLElement;
import org.openconcerto.erp.core.finance.payment.element.TypeReglementSQLElement;
import org.openconcerto.erp.core.finance.tax.element.TaxeSQLElement;
import org.openconcerto.erp.core.humanresources.employe.element.CommercialSQLElement;
import org.openconcerto.erp.core.sales.invoice.element.SaisieVenteFactureSQLElement;
import org.openconcerto.erp.generationDoc.element.ModeleSQLElement;
import org.openconcerto.erp.modules.AbstractModule;
import org.openconcerto.erp.modules.DBContext;
import org.openconcerto.erp.modules.ModuleElement;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.modules.contract.ContractBillingPeriodSQLElement;
import org.openconcerto.modules.contract.ContractGroup;
import org.openconcerto.modules.contract.ContractSQLComponent;
import org.openconcerto.modules.contract.ContratSheet;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementLink;
import org.openconcerto.sql.element.SQLElementLinksSetup;
import org.openconcerto.sql.model.AliasedTable;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.Order;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLInsert;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.TableRef;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.request.RowItemDesc;
import org.openconcerto.sql.request.SQLFieldTranslator;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.sql.utils.SQLCreateTableBase;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.IListPanel;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.BaseSQLTableModelColumn;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.list.SQLTableModelColumnPath;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.ui.JDate;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.TimeUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.i18n.Grammar_fr;
import org.openconcerto.utils.i18n.Phrase;
import org.openconcerto.utils.i18n.VariantKey;

public final class ContractSQLElement
extends ModuleElement {
    public static final String TABLE_NAME = "CONTRACT";
    public static final String FIELD_START = "START_DATE";
    public static final String FIELD_END = "ACTUAL_END_DATE";
    public static final String FIELD_PAYMENT_START = "PAYMENT_START";
    public static final String FIELD_NAME_OF_COMMERCIAL = "ID_COMMERCIAL";
    public static final String FIELD_AMOUNT = "TOTAL_AMOUNT";
    public static final String FIELD_ID_TAXE = "ID_TAXE";
    public static final String FIELD_DESCRIPTION = "DESCRIPTION";
    public static final String FIELD_REFERENCE = "REFERENCE";
    public static final String FIELD_COMMENTS = "COMMENTS";
    public static final String FIELD_MONTHS_TO_BILL = "MONTHS_TO_BILL";
    public static final String FIELD_ID_CLIENT = "ID_CLIENT";
    public static final String FIELD_ID_CONTACT = "ID_CONTACT";
    public static final String FIELD_STOPPED = "STOPPED";
    public static final String FIELD_INDICE_0 = "INDICE_0";
    public static final String FIELD_NEXT_CONTRACT = "ID_NEXT_CONTRACT";
    private static final NumberFormat NUMBER_FMT = new DecimalFormat("###00000");
    private static final DateTimeFormatter DATE_FMT = DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG);
    private static final int AUTORENEW_MONTHS = 6;

    protected static SQLCreateTable getCreateTable(DBContext ctxt) {
        SQLCreateTable res = ctxt.getCreateTable(TABLE_NAME);
        res.addForeignColumn(FIELD_ID_CLIENT, ((CustomerSQLElement)ctxt.getElementDirectory().getElement(CustomerSQLElement.class)).getTable());
        res.addForeignColumn(FIELD_ID_CONTACT, ((ComptaContactSQLElement.ContactSQLElement)ctxt.getElementDirectory().getElement(ComptaContactSQLElement.ContactSQLElement.class)).getTable());
        res.addVarCharColumn("NUMBER", 64);
        res.addVarCharColumn("TYPE", 64);
        res.addVarCharColumn(FIELD_REFERENCE, 250);
        res.addVarCharColumn("STATUS", 64);
        res.addVarCharColumn(FIELD_DESCRIPTION, 2048);
        res.addVarCharColumn(FIELD_COMMENTS, 2048);
        res.addColumn(FIELD_START, "date", null, false);
        res.addColumn(FIELD_END, "date", null, true);
        res.addForeignColumn(FIELD_NAME_OF_COMMERCIAL, ((CommercialSQLElement)ctxt.getElementDirectory().getElement(CommercialSQLElement.class)).getTable());
        res.addIntegerColumn(FIELD_MONTHS_TO_BILL, 1);
        res.addDecimalColumn(FIELD_AMOUNT, 16, 6, BigDecimal.ZERO, false);
        res.addDecimalColumn(FIELD_INDICE_0, 8, 2, BigDecimal.ZERO, false);
        res.addBooleanColumn("AUTO_RENEW", Boolean.FALSE, false);
        res.addBooleanColumn(FIELD_STOPPED, Boolean.FALSE, false);
        res.addColumn(FIELD_PAYMENT_START, "date", null, false);
        res.addForeignColumn("ID_TYPE_REGLEMENT", ((TypeReglementSQLElement)ctxt.getElementDirectory().getElement(TypeReglementSQLElement.class)).getTable());
        res.addForeignColumn("ID_MODELE", ((ModeleSQLElement)ctxt.getElementDirectory().getElement(ModeleSQLElement.class)).getTable());
        res.addForeignColumn(FIELD_ID_TAXE, ((TaxeSQLElement)ctxt.getElementDirectory().getElement(TaxeSQLElement.class)).getTable());
        res.addForeignColumn(null, ((SEPAMandateSQLElement)ctxt.getElementDirectory().getElement(SEPAMandateSQLElement.class)).getTable());
        res.addIntegerColumn("ATTACHMENTS", 0);
        res.addForeignColumn(FIELD_NEXT_CONTRACT, (SQLCreateTableBase)res);
        return res;
    }

    protected static UpdateBuilder fillNextField(SQLTable subscriptionT) {
        SQLSelect sel = new SQLSelect();
        String idToUpd = "idToUpd";
        String renewedID = "renewedID";
        sel.addSelect((FieldRef)subscriptionT.getKey(), null, "idToUpd");
        AliasedTable renewedT = new AliasedTable(subscriptionT, "renewed");
        Where sameClient = new Where((FieldRef)subscriptionT.getField(FIELD_ID_CLIENT), "=", renewedT.getField(FIELD_ID_CLIENT));
        Where following = Where.createRaw((String)(String.valueOf(subscriptionT.getField(FIELD_END).getFieldRef()) + " + interval '1 day' = " + renewedT.getField(FIELD_START).getFieldRef()), (FieldRef[])new FieldRef[0]);
        sel.addJoin("INNER", (TableRef)renewedT, sameClient.and(following));
        sel.addSelect(renewedT.getKey(), null, "renewedID");
        sel.setWhere(Where.isNull((FieldRef)subscriptionT.getField(FIELD_NEXT_CONTRACT)));
        UpdateBuilder update = new UpdateBuilder(subscriptionT);
        update.addVirtualJoin("(" + sel.asString() + ")", "map", "idToUpd");
        update.setFromVirtualJoinField(FIELD_NEXT_CONTRACT, "map", "renewedID");
        return update;
    }

    ContractSQLElement(AbstractModule module) {
        super(module, TABLE_NAME);
        this.setDefaultGroup(new ContractGroup(this.getTable()));
        RowAction.PredicateRowAction actionAttachment = new RowAction.PredicateRowAction((Action)new AbstractAction("Fichiers li\u00e9s"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRowAccessor row = IListe.get((EventObject)e).getSelectedRowAccessor();
                Collection referentRows = row.getReferentRows(row.getTable().getTable("DEVIS").getField("ID_CONTRACT"));
                AttachmentPanel panel = new AttachmentPanel(row, referentRows);
                PanelFrame frame = new PanelFrame((JPanel)panel, "Liste des fichiers li\u00e9s");
                FrameUtil.show((Window)frame);
            }
        }, true);
        actionAttachment.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(actionAttachment);
        String actionLabel = "G\u00e9n\u00e9rer les factures";
        RowAction.PredicateRowAction createInvoices = new RowAction.PredicateRowAction((Action)new AbstractAction("G\u00e9n\u00e9rer les factures\u2026", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContractSQLElement.this.generateInvoices("G\u00e9n\u00e9rer les factures", e);
            }
        }, true, false);
        createInvoices.setPredicate(IListeAction.IListeEvent.getNonEmptySelectionPredicate());
        this.getRowActions().add(createInvoices);
        String actionPerio = "G\u00e9n\u00e9rer les p\u00e9riodes";
        RowAction.PredicateRowAction createPreio = new RowAction.PredicateRowAction((Action)new AbstractAction("G\u00e9n\u00e9rer les p\u00e9riodes\u2026", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContractSQLElement.this.generatePerio("G\u00e9n\u00e9rer les p\u00e9riodes", e);
            }
        }, true, false);
        createPreio.setPredicate(IListeAction.IListeEvent.getNonEmptySelectionPredicate());
        this.getRowActions().add(createPreio);
        RowAction actionShowDoc = new RowAction(new AbstractAction("Voir le document"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContratSheet s = new ContratSheet(IListe.get((EventObject)e).getSelectedRow().asRow().fetchNew(false));
                s.showDocument();
            }
        }, false){

            public boolean enabledFor(List<SQLRowValues> selection) {
                return selection.size() == 1;
            }
        };
        this.getRowActions().add(actionShowDoc);
        RowAction actionGen = new RowAction(new AbstractAction("G\u00e9n\u00e9rer le document"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContratSheet s = new ContratSheet(IListe.get((EventObject)e).getSelectedRow().asRow().fetchNew(false));
                String printer = PrinterNXProps.getInstance().getStringProperty("CourrierPrinter");
                s.generate(false, true, printer, true);
            }
        }, false){

            public boolean enabledFor(List<SQLRowValues> selection) {
                return selection.size() == 1;
            }
        };
        this.getRowActions().add(actionGen);
    }

    protected String getNextNumber() {
        SQLSelect selMax = new SQLSelect();
        SQLField numF = this.getTable().getField("NUMBER");
        String cast = this.getTable().getDBSystemRoot().getSyntax().cast(numF.getFieldRef(), Integer.class);
        selMax.addRawSelect("max(" + cast + ")", null);
        selMax.setWhere(new Where((FieldRef)numF, this.getTable().getDBSystemRoot().getSyntax().getRegexpOp(), (Object)"[0-9]+"));
        Number maxNumber = (Number)this.getTable().getDBSystemRoot().getDataSource().executeScalar(selMax.asString());
        int newNumber = maxNumber == null ? 1 : maxNumber.intValue() + 1;
        return NUMBER_FMT.format(newNumber);
    }

    protected final void generateInvoices(String actionLabel, ActionEvent evt) {
        final IListe srcComp = IListe.get((EventObject)evt);
        final JFrame f = new JFrame("Cr\u00e9ation de factures");
        Calendar cal = Calendar.getInstance();
        cal.add(3, 3);
        final JDate jdate = new JDate(false);
        jdate.setDate(cal.getTime());
        final JCheckBox checkVisu = new JCheckBox();
        final JButton genBtn = new JButton(new AbstractAction(actionLabel){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(jdate.getDateInMillis()), ZoneId.systemDefault());
                final ProgressMonitor progressMonitor = new ProgressMonitor((Component)srcComp, "G\u00e9n\u00e9ration des factures jusqu'au " + DATE_FMT.format(dateTime), "", 0, 100);
                progressMonitor.setMillisToPopup(500);
                progressMonitor.setProgress(0);
                final ContractBillingPeriodSQLElement paymentSQLElem = (ContractBillingPeriodSQLElement)ContractSQLElement.this.getDirectory().getElement(ContractBillingPeriodSQLElement.class);
                SQLPreferences prefs = SQLPreferences.getMemCached((DBRoot)paymentSQLElem.getTable().getDBRoot());
                boolean revPrix = prefs.getBoolean("GestionRevisionPrix", false);
                String showInputDialog = null;
                if (revPrix) {
                    showInputDialog = JOptionPane.showInputDialog(f, "Indice de r\u00e9vision actuel", null, 3);
                }
                final BigDecimal indiceN = showInputDialog == null || showInputDialog.trim().length() == 0 ? null : new BigDecimal(showInputDialog);
                final List selectedRows = srcComp.getSelectedRows();
                final SwingWorker<List<SQLRowValues>, Void> worker = new SwingWorker<List<SQLRowValues>, Void>(){

                    @Override
                    protected List<SQLRowValues> doInBackground() throws Exception {
                        ArrayList<SQLRow> rContracts = new ArrayList<SQLRow>();
                        for (SQLRowValues rv : selectedRows) {
                            rContracts.add(rv.asRow().fetchNew(false));
                        }
                        ContractSQLElement.this.createBillingPeriodElement(rContracts);
                        return paymentSQLElem.generateInvoices(new Where((FieldRef)paymentSQLElem.getTable().getField("DATE"), "<=", (Object)jdate.getDate()), new ContractBillingPeriodSQLElement.ProgressListener(){

                            @Override
                            public void progressChanged(String note, int current) {
                                this.setProgress(current);
                            }
                        }, indiceN, checkVisu.isSelected());
                    }

                    @Override
                    protected void done() {
                        try {
                            List rows = (List)this.get();
                            Phrase invoiceName = paymentSQLElem.getForeignElement("ID_SAISIE_VENTE_FACTURE").getName();
                            String end = rows.isEmpty() ? " n'a \u00e9t\u00e9 g\u00e9n\u00e9r\u00e9e." : (rows.size() == 1 ? " a \u00e9t\u00e9 g\u00e9n\u00e9r\u00e9e." : " ont \u00e9t\u00e9 g\u00e9n\u00e9r\u00e9es.");
                            JOptionPane.showMessageDialog((Component)srcComp, String.valueOf(invoiceName.getNumeralVariant(rows.size(), (VariantKey)Grammar_fr.INDEFINITE_NUMERAL)) + end);
                            SaisieVenteFactureSQLElement elementFact = (SaisieVenteFactureSQLElement)ContractSQLElement.this.getDirectory().getElement(SaisieVenteFactureSQLElement.class);
                            ListeAddPanel panelList = new ListeAddPanel((SQLElement)elementFact, new IListe((SQLTableModelSource)elementFact.createTableSource(Where.inValues((FieldRef)elementFact.getTable().getKey(), (Collection)SQLRow.getIDs((Collection)rows)))));
                            IListFrame frame = new IListFrame((IListPanel)panelList);
                            FrameUtil.showPacked((Frame)frame);
                        }
                        catch (CancellationException exn) {
                            JOptionPane.showMessageDialog((Component)srcComp, "La g\u00e9n\u00e9ration a \u00e9t\u00e9 annul\u00e9e.");
                        }
                        catch (Exception exn) {
                            ExceptionHandler.handle((Component)srcComp, (String)"Impossible de g\u00e9n\u00e9rer", (Throwable)exn);
                        }
                    }
                };
                worker.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("progress".equals(evt.getPropertyName())) {
                            progressMonitor.setProgress(((Number)evt.getNewValue()).intValue());
                            if (progressMonitor.isCanceled()) {
                                worker.cancel(true);
                            }
                        }
                    }
                });
                f.dispose();
                worker.execute();
            }
        });
        jdate.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                genBtn.setEnabled(evt.getNewValue() != null);
            }
        });
        genBtn.setEnabled(jdate.getValue() != null);
        FormLayouter layouter = new FormLayouter(f.getContentPane(), 1, 1);
        layouter.add("Inclure les r\u00e8glements jusqu'au", (Component)jdate);
        layouter.add("Visualiser les factures", (Component)checkVisu);
        layouter.add(genBtn);
        f.pack();
        f.setLocationRelativeTo((Component)srcComp);
        f.setVisible(true);
    }

    protected final void generatePerio(String actionLabel, ActionEvent evt) {
        final IListe srcComp = IListe.get((EventObject)evt);
        final JFrame f = new JFrame("Cr\u00e9ation de p\u00e9riodes");
        Calendar cal = Calendar.getInstance();
        cal.add(3, 3);
        final JDate jdate = new JDate(false);
        jdate.setDate(cal.getTime());
        final JButton genBtn = new JButton(new AbstractAction(actionLabel){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(jdate.getDateInMillis()), ZoneId.systemDefault());
                final ProgressMonitor progressMonitor = new ProgressMonitor((Component)srcComp, "G\u00e9n\u00e9ration des p\u00e9riodes jusqu'au " + DATE_FMT.format(dateTime), "", 0, 100);
                progressMonitor.setMillisToPopup(500);
                progressMonitor.setProgress(0);
                final List selectedRows = srcComp.getSelectedRows();
                final ContractBillingPeriodSQLElement paymentSQLElem = (ContractBillingPeriodSQLElement)ContractSQLElement.this.getDirectory().getElement(ContractBillingPeriodSQLElement.class);
                final SwingWorker<Object, Void> worker = new SwingWorker<Object, Void>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        ArrayList<SQLRow> rContracts = new ArrayList<SQLRow>();
                        for (SQLRowValues rv : selectedRows) {
                            rContracts.add(rv.asRow().fetchNew(false));
                        }
                        ContractSQLElement.this.createBillingPeriodElement(rContracts);
                        return null;
                    }

                    @Override
                    protected void done() {
                        try {
                            this.get();
                            String invoiceName = paymentSQLElem.getPluralName();
                            JOptionPane.showMessageDialog((Component)srcComp, "Les " + invoiceName + " ont \u00e9t\u00e9 cr\u00e9\u00e9.");
                        }
                        catch (CancellationException exn) {
                            JOptionPane.showMessageDialog((Component)srcComp, "La g\u00e9n\u00e9ration a \u00e9t\u00e9 annul\u00e9e.");
                        }
                        catch (Exception exn) {
                            ExceptionHandler.handle((Component)srcComp, (String)"Impossible de g\u00e9n\u00e9rer", (Throwable)exn);
                        }
                    }
                };
                worker.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("progress".equals(evt.getPropertyName())) {
                            progressMonitor.setProgress(((Number)evt.getNewValue()).intValue());
                            if (progressMonitor.isCanceled()) {
                                worker.cancel(true);
                            }
                        }
                    }
                });
                f.dispose();
                worker.execute();
            }
        });
        jdate.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                genBtn.setEnabled(evt.getNewValue() != null);
            }
        });
        genBtn.setEnabled(jdate.getValue() != null);
        FormLayouter layouter = new FormLayouter(f.getContentPane(), 1, 1);
        layouter.add("Inclure les r\u00e8glements jusqu'au", (Component)jdate);
        layouter.add(genBtn);
        f.pack();
        f.setLocationRelativeTo((Component)srcComp);
        f.setVisible(true);
    }

    protected final Where getAutoRenewWhere() {
        return new Where((FieldRef)this.getTable().getField("AUTO_RENEW"), "=", (Object)Boolean.TRUE).and(Where.createRaw((String)(String.valueOf(this.getSQLEnd()) + " between (CURRENT_DATE - interval '" + 6 + " months') and CURRENT_DATE"), (FieldRef[])new FieldRef[0]));
    }

    protected final boolean isAutoRenewNow(SQLRowAccessor v, Calendar cal) {
        if (!v.getBoolean("AUTO_RENEW").booleanValue()) {
            return false;
        }
        this.setEnd(cal, v);
        Date end = cal.getTime();
        Date now = new Date();
        cal.setTime(now);
        TimeUtils.clearTime((Calendar)cal);
        cal.add(2, -6);
        Date lowerBound = cal.getTime();
        return end.compareTo(lowerBound) >= 0 && end.compareTo(now) <= 0;
    }

    protected final SQLSelect setRenewSelect(SQLSelect sel, Where w) {
        sel.andWhere(Where.isNull((FieldRef)this.getTable().getField(FIELD_NEXT_CONTRACT)));
        sel.andWhere(w);
        sel.addFieldOrder((FieldRef)this.getTable().getField(FIELD_START), Order.asc());
        return sel;
    }

    protected final List<SQLRow> renew(final Where w, final Set<SQLRow> expected) throws SQLException {
        return (List)SQLUtils.executeAtomic((SQLDataSource)this.getTable().getDBSystemRoot().getDataSource(), (ConnectionHandlerNoSetup)new ConnectionHandlerNoSetup<List<SQLRow>, SQLException>(){

            public List<SQLRow> handle(SQLDataSource ds) throws SQLException {
                SQLRowValues toFetch = new SQLRowValues(ContractSQLElement.this.getTable()).setAllToNull();
                SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create((SQLRowValues)toFetch, (boolean)false);
                fetcher.setSelTransf(sel -> {
                    ContractSQLElement.this.setRenewSelect((SQLSelect)sel, w);
                    sel.setLockStrength(SQLSelect.LockStrength.UPDATE);
                    sel.addLockedTable(sel.getAlias(ContractSQLElement.this.getTable()).getAlias());
                    return sel;
                });
                List rows = fetcher.fetch();
                if (rows.isEmpty()) {
                    return Collections.emptyList();
                }
                if (expected != null && !SQLRowAccessor.getIDs((Collection)expected).containsAll(SQLRowAccessor.getIDs((Collection)rows))) {
                    return null;
                }
                ArrayList<SQLRow> res = new ArrayList<SQLRow>();
                ContractBillingPeriodSQLElement paymentElem = (ContractBillingPeriodSQLElement)ContractSQLElement.this.getDirectory().getElement(ContractBillingPeriodSQLElement.class);
                Calendar cal = Calendar.getInstance();
                for (SQLRowValues toRenew : rows) {
                    if (!$assertionsDisabled && !toRenew.isForeignEmpty(ContractSQLElement.FIELD_NEXT_CONTRACT)) {
                        throw new AssertionError();
                    }
                    SQLRowValues copy = ContractSQLElement.this.createCopy((SQLRowAccessor)toRenew, null);
                    toRenew.createEmptyUpdateRow().put(ContractSQLElement.FIELD_NEXT_CONTRACT, (Object)copy);
                    copy.put("NUMBER", (Object)ContractSQLElement.this.getNextNumber());
                    ContractSQLElement.this.setEnd(cal, (SQLRowAccessor)toRenew);
                    cal.add(6, 1);
                    Date startDate = cal.getTime();
                    copy.put(ContractSQLElement.FIELD_START, (Object)startDate);
                    copy.put(ContractSQLElement.FIELD_PAYMENT_START, (Object)startDate);
                    copy.put(ContractSQLElement.FIELD_END, null);
                    BigDecimal totalAmount = (BigDecimal)copy.getContainedObject(ContractSQLElement.FIELD_AMOUNT);
                    int months = copy.getInt(ContractSQLElement.FIELD_MONTHS_TO_BILL);
                    Object reglRecurr = copy.getContainedObject("ID_TYPE_REGLEMENT");
                    for (SQLRowValues payment : paymentElem.generate(totalAmount, startDate, true, months, true, reglRecurr)) {
                        payment.put("ID_CONTRACT", (Object)copy);
                    }
                    res.add(copy.commit());
                }
                return res;
            }
        });
    }

    protected void setupLinks(SQLElementLinksSetup links) {
        super.setupLinks(links);
        links.get(FIELD_ID_CLIENT).setType(SQLElementLink.LinkType.PARENT, SQLElement.ReferenceAction.CASCADE);
        links.get(FIELD_NEXT_CONTRACT).setType(SQLElementLink.LinkType.ASSOCIATION, SQLElement.ReferenceAction.SET_EMPTY);
    }

    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NUMBER");
        l.add(FIELD_ID_CLIENT);
        l.add(FIELD_NAME_OF_COMMERCIAL);
        l.add("TYPE");
        l.add("STATUS");
        l.add(FIELD_DESCRIPTION);
        l.add(FIELD_AMOUNT);
        l.add(FIELD_MONTHS_TO_BILL);
        l.add("AUTO_RENEW");
        l.add(FIELD_STOPPED);
        l.add(FIELD_START);
        if (this.getTable().contains("DATE_REX")) {
            l.add("DATE_REX");
        }
        if (this.getTable().contains("DATE_FOURNITURE")) {
            l.add("DATE_FOURNITURE");
        }
        if (this.getTable().contains("DATE_THERMO")) {
            l.add("DATE_THERMO");
        }
        return l;
    }

    protected void _initListRequest(ListSQLRequest req) {
        super._initListRequest(req);
        req.addToGraphToFetch((Path)new Path(this.getTable()).addReferentField(FIELD_NEXT_CONTRACT), (Collection)this.getTable().getPKsNames());
    }

    protected void _initTableSource(SQLTableModelSource res) {
        super._initTableSource(res);
        SQLFieldTranslator translator = this.getDirectory().getTranslator();
        FieldPath codeClientPath = new FieldPath((Path)new Path(this.getTable()).addForeignField(FIELD_ID_CLIENT), "CODE");
        if (res.getColumn(codeClientPath) == null) {
            res.getColumns().add(0, new SQLTableModelColumnPath(codeClientPath));
        }
        BaseSQLTableModelColumn endDateCol = new BaseSQLTableModelColumn(translator.getDescFor(this.getTable(), "END_DATE").getTitleLabel(), EndDate.class){
            private final Calendar cal;
            {
                this.cal = Calendar.getInstance();
            }

            public Set<FieldPath> getPaths() {
                return FieldPath.create((Path)new Path(ContractSQLElement.this.getTable()), Arrays.asList(ContractSQLElement.FIELD_END, ContractSQLElement.FIELD_START, ContractSQLElement.FIELD_MONTHS_TO_BILL));
            }

            protected EndDate show_(SQLRowAccessor r) {
                boolean actual = ContractSQLElement.this.setEnd(this.cal, r);
                return new EndDate(actual, this.cal.getTime());
            }

            protected TableCellRenderer createDefaultRenderer() {
                return new DefaultTableCellRenderer(){
                    private final DateFormat df = DateFormat.getDateInstance(2);
                    private Font actualDateFont;
                    private Font computedDateFont;

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        Font f;
                        EndDate t = (EndDate)value;
                        Component res = super.getTableCellRendererComponent(table, t == null ? null : this.df.format((Date)t.get1()), isSelected, hasFocus, row, column);
                        if (t == null || !t.isDateComputed()) {
                            if (this.actualDateFont == null) {
                                this.actualDateFont = res.getFont().deriveFont(0);
                            }
                            f = this.actualDateFont;
                        } else {
                            if (this.computedDateFont == null) {
                                this.computedDateFont = res.getFont().deriveFont(2);
                            }
                            f = this.computedDateFont;
                        }
                        res.setFont(f);
                        return res;
                    }
                };
            }
        };
        res.getColumns().add(endDateCol);
        res.getColumns().add(new BaseSQLTableModelColumn(translator.getDescFor(this.getTable(), "TO_RENEW_NOW").getTitleLabel(), Boolean.class){
            private final Calendar cal;
            {
                this.cal = Calendar.getInstance();
            }

            public Set<FieldPath> getPaths() {
                Path p = new Path(ContractSQLElement.this.getTable());
                Path pBillingItem = (Path)new Path(ContractSQLElement.this.getTable()).add(ContractSQLElement.this.getTable().getTable("CONTRACT_BILLING_PERIOD").getField("ID_CONTRACT"));
                Set create = FieldPath.create((Path)p, Arrays.asList(ContractSQLElement.FIELD_STOPPED, ContractSQLElement.FIELD_NEXT_CONTRACT, ContractSQLElement.FIELD_END, ContractSQLElement.FIELD_START, ContractSQLElement.FIELD_MONTHS_TO_BILL));
                Set create2 = FieldPath.create((Path)pBillingItem, Arrays.asList("ID_CONTRACT", "DATE", "DURATION_IN_MONTHS"));
                create.addAll(create2);
                return create;
            }

            protected Boolean show_(SQLRowAccessor r) {
                if (r.getBoolean(ContractSQLElement.FIELD_STOPPED).booleanValue()) {
                    return false;
                }
                Collection referentRows = r.getReferentRows(r.getTable().getTable("CONTRACT_BILLING_PERIOD"));
                Calendar dateEndBillingPeriod = null;
                for (SQLRowAccessor sqlRowAccessor : referentRows) {
                    Calendar dateCurrent = sqlRowAccessor.getDate("DATE");
                    int monthCurrent = sqlRowAccessor.getInt("DURATION_IN_MONTHS");
                    dateCurrent.add(2, monthCurrent);
                    if (dateEndBillingPeriod == null) {
                        dateEndBillingPeriod = dateCurrent;
                        continue;
                    }
                    if (!dateCurrent.after(dateEndBillingPeriod)) continue;
                    dateEndBillingPeriod = dateCurrent;
                }
                boolean renew = false;
                if (dateEndBillingPeriod != null && dateEndBillingPeriod.after(this.cal)) {
                    renew = true;
                }
                if (!renew && r.isForeignEmpty(ContractSQLElement.FIELD_NEXT_CONTRACT)) {
                    return true;
                }
                return false;
            }
        });
        FieldPath nextSubscriptionPath = new FieldPath((Path)new Path(this.getTable()).addForeignField(FIELD_NEXT_CONTRACT), "NUMBER");
        RowItemDesc nextNumber = translator.getDescFor(this.getTable(), "NEXT_NUMBER");
        res.getColumns().add(new SQLTableModelColumnPath(nextSubscriptionPath, nextNumber.getTitleLabel(), this.getDirectory()));
    }

    protected final Calendar computeEnd(Calendar cal, SQLRowAccessor r) {
        cal.setTime((Date)r.getObjectAs(FIELD_START, Date.class));
        cal.add(2, r.getInt(FIELD_MONTHS_TO_BILL));
        cal.add(6, -1);
        return cal;
    }

    protected final boolean setEnd(Calendar cal, SQLRowAccessor r) {
        boolean actual;
        Date origEnd = (Date)r.getContainedObject(FIELD_END);
        boolean bl = actual = origEnd != null;
        if (actual) {
            cal.setTime(origEnd);
        } else {
            this.computeEnd(cal, r);
        }
        return actual;
    }

    protected String computeSQLEnd() {
        return String.valueOf(SQLBase.quoteIdentifier((String)FIELD_START)) + " + (" + SQLBase.quoteIdentifier((String)FIELD_MONTHS_TO_BILL) + " * interval '1 month') - interval '1 day' ";
    }

    protected String getSQLEnd() {
        return "COALESCE(" + SQLBase.quoteIdentifier((String)FIELD_END) + ", " + this.computeSQLEnd() + ")";
    }

    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(FIELD_ID_CLIENT);
        l.add("NUMBER");
        return l;
    }

    public Set<String> getReadOnlyFields() {
        HashSet<String> s = new HashSet<String>();
        s.add(FIELD_NEXT_CONTRACT);
        s.add(FIELD_AMOUNT);
        return s;
    }

    protected SQLComponent createComponent() {
        return new ContractSQLComponent((SQLElement)this);
    }

    public void createBillingPeriodElement(List<SQLRow> rContracts) throws SQLException {
        if (rContracts.isEmpty()) {
            return;
        }
        ArrayList<SQLInsert> inserts = new ArrayList<SQLInsert>();
        HashSet<SQLTable> tables = new HashSet<SQLTable>();
        SQLTable tableBillingPeriod = rContracts.get(0).getTable().getTable("CONTRACT_BILLING_PERIOD");
        tables.add(tableBillingPeriod);
        for (SQLRow rContrat : rContracts) {
            BigDecimal amount;
            SQLInsert insert;
            BigDecimal totalAmount = rContrat.getBigDecimal(FIELD_AMOUNT);
            if (totalAmount == null || rContrat.getBoolean(FIELD_STOPPED).booleanValue()) continue;
            List exitingPeriod = rContrat.getReferentRows(tables);
            if (!exitingPeriod.isEmpty()) {
                boolean facture;
                System.err.println("ContractElement.createBillingPeriodElement() des p\u00e9riodes exitent d\u00e9j\u00e0");
                SQLRow lastPeriod = null;
                for (SQLRow p : exitingPeriod) {
                    if (lastPeriod == null) {
                        lastPeriod = p;
                        continue;
                    }
                    if (p.getDate("DATE").compareTo(lastPeriod.getDate("DATE")) <= 0) continue;
                    lastPeriod = p;
                }
                Calendar cal = lastPeriod.getDate("DATE");
                int duration = lastPeriod.getInt("DURATION_IN_MONTHS");
                cal.add(2, duration);
                cal.add(5, -1);
                cal.set(5, cal.getActualMaximum(5));
                Date end = cal.getTime();
                Calendar d = Calendar.getInstance();
                Boolean taciteReconduction = rContrat.getBoolean("AUTO_RENEW");
                boolean bl = facture = lastPeriod.getObject("ID_SAISIE_VENTE_FACTURE") != null && !lastPeriod.isForeignEmpty("ID_SAISIE_VENTE_FACTURE");
                if (facture || end.compareTo(d.getTime()) >= 0 || !taciteReconduction.booleanValue() && (taciteReconduction.booleanValue() || rContrat.getDate(FIELD_END) != null && rContrat.getDate(FIELD_END).compareTo(d) <= 0)) continue;
                insert = new SQLInsert();
                insert.add(tableBillingPeriod.getField("DURATION_IN_MONTHS"), (Object)duration);
                insert.add(tableBillingPeriod.getField("INVOICED_OUTSIDE"), (Object)Boolean.FALSE);
                insert.add(tableBillingPeriod.getField("ID_TYPE_REGLEMENT"), (Object)rContrat.getInt("ID_TYPE_REGLEMENT"));
                insert.add(tableBillingPeriod.getField(FIELD_ID_TAXE), (Object)rContrat.getInt(FIELD_ID_TAXE));
                amount = rContrat.getBigDecimal(FIELD_AMOUNT);
                insert.add(tableBillingPeriod.getField("AMOUNT"), (Object)amount);
                cal.add(5, 1);
                insert.add(tableBillingPeriod.getField("DATE"), (Object)cal.getTime());
                insert.add(tableBillingPeriod.getField("ID_CONTRACT"), (Object)rContrat.getID());
                inserts.add(insert);
                continue;
            }
            Calendar start = rContrat.getDate(FIELD_START);
            Calendar end = rContrat.getDate(FIELD_END);
            if (end == null) {
                end = Calendar.getInstance();
                end.setTime(start.getTime());
                end.add(2, rContrat.getInt(FIELD_MONTHS_TO_BILL));
            }
            end.add(5, 1);
            int totalMonhts = 12 * (end.get(1) - start.get(1)) + end.get(2) - start.get(2);
            int montToBill = rContrat.getInt(FIELD_MONTHS_TO_BILL);
            if (montToBill < 1) {
                return;
            }
            Calendar c = Calendar.getInstance();
            c.clear();
            c.set(1, start.get(1));
            c.set(2, start.get(2));
            int nb = totalMonhts / montToBill;
            int i = 0;
            while (i < nb) {
                insert = new SQLInsert();
                insert.add(tableBillingPeriod.getField("DURATION_IN_MONTHS"), (Object)montToBill);
                insert.add(tableBillingPeriod.getField("INVOICED_OUTSIDE"), (Object)Boolean.FALSE);
                insert.add(tableBillingPeriod.getField("ID_TYPE_REGLEMENT"), (Object)rContrat.getInt("ID_TYPE_REGLEMENT"));
                insert.add(tableBillingPeriod.getField(FIELD_ID_TAXE), (Object)rContrat.getInt(FIELD_ID_TAXE));
                amount = rContrat.getBigDecimal(FIELD_AMOUNT);
                insert.add(tableBillingPeriod.getField("AMOUNT"), (Object)amount);
                int day = rContrat.getDate(FIELD_PAYMENT_START).get(5);
                if (day > 28) {
                    day = 28;
                }
                c.set(5, day);
                insert.add(tableBillingPeriod.getField("DATE"), (Object)c.getTime());
                insert.add(tableBillingPeriod.getField("ID_CONTRACT"), (Object)rContrat.getID());
                inserts.add(insert);
                c.add(2, montToBill);
                ++i;
            }
        }
        if (!inserts.isEmpty()) {
            SQLInsert.executeMultiple((DBSystemRoot)tableBillingPeriod.getDBSystemRoot(), inserts);
        }
    }

    private static final class EndDate
    extends Tuple2<Boolean, Date>
    implements Comparable<EndDate> {
        protected EndDate(boolean actualDate, Date b) {
            super((Object)actualDate, (Object)b);
        }

        protected final boolean isDateComputed() {
            return (Boolean)this.get0() == false;
        }

        @Override
        public int compareTo(EndDate o) {
            return ((Date)this.get1()).compareTo((Date)o.get1());
        }

        public boolean equals(Object obj) {
            if (obj instanceof EndDate) {
                return ((Date)this.get1()).equals(((EndDate)obj).get1());
            }
            return false;
        }

        public int hashCode() {
            return ((Date)this.get1()).hashCode();
        }
    }
}

