/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.contract;

import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.core.common.element.StyleSQLElement;
import org.openconcerto.modules.contract.ContractItemTable;
import org.openconcerto.modules.contract.ContractSQLElement;
import org.openconcerto.sql.element.GroupSQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.sql.sqlobject.SQLTextCombo;
import org.openconcerto.sql.sqlobject.itemview.VWRowItemView;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.ui.component.InteractionMode;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.cc.ITransformer;

final class ContractSQLComponent
extends GroupSQLComponent {
    private ContractItemTable tableElements;

    protected ContractSQLComponent(SQLElement element) {
        super(element);
        this.startTabGroupAfter("contract.comments");
    }

    protected Set<String> createRequiredNames() {
        return CollectionUtils.createSet((Object[])new String[]{"ID_CLIENT", "AMOUNT", "PAYMENT_START", "START_DATE", "MONTHS_TO_BILL", "ID_TYPE_REGLEMENT", "ID_COMMERCIAL"});
    }

    protected void initDone() {
        super.initDone();
        this.updateEditable();
        final SQLRequestComboBox editorCustomer = (SQLRequestComboBox)this.getEditor("contract.customer");
        final SQLRequestComboBox editorContact = (SQLRequestComboBox)this.getEditor("contract.contact");
        editorCustomer.addModelListener("wantedID", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                int wantedID = editorCustomer.getWantedID();
                if (wantedID != -1 && wantedID >= 0) {
                    editorContact.getRequest().setWhere(new Where((FieldRef)ContractSQLComponent.this.getTable().getForeignTable("ID_CONTACT").getField("ID_CLIENT"), "=", wantedID));
                } else {
                    editorContact.getRequest().setWhere(Where.FALSE);
                }
            }
        });
        if (this.getTable().contains("DATE_THERMO")) {
            final SQLTextCombo editorType = (SQLTextCombo)this.getEditor("contract.type");
            final JCheckBox editorCheckTacite = (JCheckBox)this.getEditor("contract.period.autorenew");
            editorCheckTacite.setEnabled(!editorType.getTextComp().getText().isEmpty());
            editorType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    editorCheckTacite.setEnabled(!editorType.getTextComp().getText().isEmpty());
                }
            });
        }
    }

    protected void interactionModeChanged(InteractionMode mode) {
        super.interactionModeChanged(mode);
        this.updateEditable();
    }

    protected void updateEditable() {
    }

    protected final VWRowItemView<String> getNumberRIV() {
        return (VWRowItemView)this.getView("NUMBER");
    }

    public void select(SQLRowAccessor r, Set<String> views) {
        super.select(r, views);
        if (r != null) {
            this.tableElements.getRowValuesTable().insertFrom("ID_CONTRACT", r.asRowValues());
        }
    }

    public int insert(SQLRow order) {
        this.setNumber();
        int id = super.insert(order);
        this.tableElements.updateField("ID_CONTRACT", id);
        try {
            ((ContractSQLElement)this.getElement()).createBillingPeriodElement(Arrays.asList(this.getTable().getRow(id)));
        }
        catch (SQLException e) {
            ExceptionHandler.handle((String)"Erreur lors de a cr\u00e9ation des p\u00e9riodes de facturation", (Throwable)e);
        }
        return id;
    }

    public void update() {
        super.update();
        this.tableElements.updateField("ID_CONTRACT", this.getSelectedID());
    }

    protected void setNumber() {
        this.getNumberRIV().getWrapper().setValue((Object)((ContractSQLElement)this.getElement()).getNextNumber());
    }

    protected JComponent createLabel(String id) {
        int i = 1;
        while (i <= 4) {
            if (id.equals("contract.web." + i + ".button")) {
                return new JLabel("" + i);
            }
            ++i;
        }
        return super.createLabel(id);
    }

    public JComponent createEditor(String id) {
        int i = 1;
        while (i <= 4) {
            if (id.equals("contract.web." + i + ".button")) {
                final int index = i;
                return new JButton(new AbstractAction("Acc\u00e9der au site"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String url = ((SQLTextCombo)ContractSQLComponent.this.getView("SITE_FOURNISSEUR_URL_" + index).getComp()).getValue();
                        try {
                            Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                            String login = ((JTextField)ContractSQLComponent.this.getView("SITE_FOURNISSEUR_LOGIN_" + index).getComp()).getText();
                            String password = ((JTextField)ContractSQLComponent.this.getView("SITE_FOURNISSEUR_PASSWORD_" + index).getComp()).getText();
                            StringSelection sel = new StringSelection(String.valueOf(login) + " " + password);
                            systemClipboard.setContents(sel, sel);
                            Desktop.getDesktop().browse(new URI(url));
                        }
                        catch (IOException | URISyntaxException e1) {
                            ExceptionHandler.handle(null, (String)"L'URL n'est pas correcte", (Throwable)e1);
                        }
                    }
                });
            }
            if (id.equals("contract.web." + i + ".supplier")) {
                return new SQLTextCombo();
            }
            ++i;
        }
        if (id.contains("contract.number")) {
            JTextField c = new JTextField(20){

                @Override
                public boolean isEnabled() {
                    return false;
                }

                @Override
                public boolean isEditable() {
                    return false;
                }
            };
            return c;
        }
        if (id.equals("contract.items")) {
            this.tableElements = new ContractItemTable();
            SQLRowValues defaultRowValues = this.tableElements.getRowValuesTable().getRowValuesTableModel().getDefaultRowValues();
            defaultRowValues.put("PV_HT", (Object)BigDecimal.ZERO);
            defaultRowValues.put("PA_HT", (Object)BigDecimal.ZERO);
            defaultRowValues.put("T_PV_HT", (Object)BigDecimal.ZERO);
            defaultRowValues.put("T_PA_HT", (Object)BigDecimal.ZERO);
            defaultRowValues.put("PRIX_METRIQUE_VT_1", (Object)BigDecimal.ZERO);
            defaultRowValues.put("PRIX_METRIQUE_HA_1", (Object)BigDecimal.ZERO);
            defaultRowValues.put("QTE", 1);
            defaultRowValues.put("QTE_UNITAIRE", (Object)BigDecimal.ONE);
            defaultRowValues.put("ID_UNITE_VENTE", 2);
            defaultRowValues.put("ID_MODE_VENTE_ARTICLE", 5);
            defaultRowValues.put("ID_ARTICLE", (Object)this.getTable().getTable("ARTICLE").getUndefinedIDNumber());
            defaultRowValues.put("ID_STYLE", ((StyleSQLElement)this.getDirectory().getElement(StyleSQLElement.class)).getAllStyleByName().get("Normal"));
            return this.tableElements;
        }
        if (id.equals("contract.comments")) {
            ITextArea iTextArea = new ITextArea(5, 40);
            iTextArea.setMinimumSize(new Dimension(80, 100));
            return iTextArea;
        }
        if (id.equals("contract.reference") || id.equals("contract.type") || id.equals("contract.status")) {
            SQLTextCombo sqlTextCombo = new SQLTextCombo();
            return sqlTextCombo;
        }
        if (id.equals("contract.template.invoice")) {
            ElementComboBox box = new ElementComboBox();
            final SQLElement foreignElementModele = this.getElement().getForeignElement("ID_MODELE");
            ComboSQLRequest comboRequest = foreignElementModele.getComboRequest(true);
            comboRequest.setSelectTransf((ITransformer)new ITransformer<SQLSelect, SQLSelect>(){

                public SQLSelect transformChecked(SQLSelect input) {
                    SQLTable table = foreignElementModele.getForeignElement("ID_TYPE_MODELE").getTable();
                    Where w = new Where(input.getAlias(table.getField("TABLE")), "=", (Object)"SAISIE_VENTE_FACTURE");
                    input.setWhere(w);
                    return input;
                }
            });
            box.init(foreignElementModele, comboRequest);
            return box;
        }
        if (id.equals("contract.billing.amount")) {
            final ContractItemTable items = (ContractItemTable)((Object)this.getEditor("contract.items"));
            final JTextField totalHT = new JTextField(20);
            items.getModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    BigDecimal total = BigDecimal.ZERO;
                    int i = 0;
                    while (i < items.getModel().getRowCount()) {
                        BigDecimal t;
                        SQLRowValues rowValuesAt = items.getModel().getRowValuesAt(i);
                        if (rowValuesAt.getInt("NIVEAU") == 1 && (t = rowValuesAt.getBigDecimal("T_PV_HT")) != null) {
                            total = total.add(t);
                        }
                        ++i;
                    }
                    totalHT.setText(total.toString());
                }
            });
            return totalHT;
        }
        return super.createEditor(id);
    }

    protected SQLRowValues createDefaults() {
        SQLRowValues res = new SQLRowValues(this.getTable());
        res.put("ID_TYPE_REGLEMENT", 10);
        Calendar c = Calendar.getInstance();
        res.put("START_DATE", (Object)c.getTime());
        res.put("PAYMENT_START", (Object)c.getTime());
        res.put("MONTHS_TO_BILL", 12);
        res.put("STATUS", (Object)"\u00e0 facturer");
        return res;
    }
}

