/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.contract;

import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.ui.group.Group;
import org.openconcerto.ui.group.Item;
import org.openconcerto.ui.group.LayoutHints;

public class ContractGroup
extends Group {
    public ContractGroup(SQLTable table) {
        super("contract");
        this.addItem("contract.customer");
        this.addItem("contract.salesman");
        this.addItem("contract.contact");
        this.addItem("contract.reference", LayoutHints.DEFAULT_LARGE_FIELD_HINTS);
        this.addItem("contract.type", LayoutHints.DEFAULT_LARGE_FIELD_HINTS);
        this.addItem("contract.status", LayoutHints.DEFAULT_LARGE_FIELD_HINTS);
        this.addItem("contract.number");
        Group gPeriod = new Group("contract.period", LayoutHints.DEFAULT_GROUP_HINTS);
        gPeriod.addItem("contract.period.start");
        gPeriod.addItem("contract.period.end");
        gPeriod.addItem("contract.period.start.payment");
        gPeriod.addItem("contract.period.autorenew");
        gPeriod.addItem("contract.indice0");
        if (table.contains("DATE_REX")) {
            gPeriod.addItem("contract.period.rex");
        }
        if (table.contains("DATE_FOURNITURE")) {
            gPeriod.addItem("contract.period.supplying");
        }
        if (table.contains("DATE_THERMO")) {
            gPeriod.addItem("contract.period.thermo");
        }
        if (table.contains("ID_MODELE")) {
            gPeriod.addItem("contract.template.invoice");
        }
        if (table.contains("DATE_THERMO")) {
            gPeriod.addItem("contract.period.thermo");
        }
        if (table.contains("CLEARING_AOE")) {
            gPeriod.addItem("contract.clearingaoe");
        }
        if (table.contains("REM_EFFACEMENT")) {
            gPeriod.addItem("contract.rem.percent");
        }
        this.add((Item)gPeriod);
        this.addItem("contract.comments", new LayoutHints(true, false, true, true, true, true, true));
        Group gBilling = new Group("contract.billing.tab");
        gBilling.addItem("contract.billing.amount");
        gBilling.addItem("contract.billing.months");
        gBilling.addItem("contract.billing.payment");
        gBilling.addItem("contract.items", LayoutHints.DEFAULT_LIST_HINTS);
        gBilling.addItem("contract.stopped");
        this.add((Item)gBilling);
        Group gDesc = new Group("contract.description.tab");
        gDesc.addItem("contract.description", new LayoutHints(true, true, true, true, true, true, true));
        this.add((Item)gDesc);
        if (table.contains("SITE_FOURNISSEUR_URL_1")) {
            Group gTabURL = new Group("contract.supplier.url.tab");
            int i = 1;
            while (i <= 4) {
                if (table.contains("SITE_FOURNISSEUR_URL_" + i)) {
                    Group gSupplier = new Group("contract.web." + i, LayoutHints.DEFAULT_SEPARATED_GROUP_HINTS);
                    gSupplier.addItem("contract.web." + i + ".supplier");
                    gSupplier.addItem("contract.web." + i + ".button");
                    gSupplier.addItem("contract.web." + i + ".login");
                    gSupplier.addItem("contract.web." + i + ".password");
                    gTabURL.add((Item)gSupplier);
                }
                ++i;
            }
            this.add((Item)gTabURL);
        }
    }
}

