/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.contract;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openconcerto.erp.core.common.element.StyleSQLElement;
import org.openconcerto.erp.core.common.ui.DeviseCellEditor;
import org.openconcerto.erp.core.common.ui.DeviseNiceTableCellRenderer;
import org.openconcerto.erp.core.common.ui.Remise;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.modules.contract.ContractElementSQLElement;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.view.list.AutoCompletionManager;
import org.openconcerto.sql.view.list.CellDynamicModifier;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableControlPanel;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.RowValuesTableRenderer;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.sql.view.list.ValidStateChecker;
import org.openconcerto.ui.table.XTableColumnModel;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.cc.ITransformer;

public class ContractElementsTable
extends JPanel {
    private RowValuesTable table;
    final RowValuesTableControlPanel comp;

    public ContractElementsTable(SQLElementDirectory dir) {
        SQLElement elt = dir.getElement(ContractElementSQLElement.class);
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        Vector<SQLTableElement> list = new Vector<SQLTableElement>();
        SQLTable tableContractElement = elt.getTable();
        SQLTableElement tableElementTps = new SQLTableElement(tableContractElement.getField("ID_STYLE"));
        list.add(tableElementTps);
        if (tableContractElement.contains("ID_AFFAIRE")) {
            SQLTableElement tableElementAffaire = new SQLTableElement(tableContractElement.getField("ID_AFFAIRE"));
            list.add(tableElementAffaire);
        }
        if (tableContractElement.contains("ID_COMPTE_PCE")) {
            SQLTableElement tableElementCompte = new SQLTableElement(tableContractElement.getField("ID_COMPTE_PCE"));
            list.add(tableElementCompte);
        }
        SQLTableElement tableElementArticle = new SQLTableElement(tableContractElement.getField("ID_ARTICLE"));
        list.add(tableElementArticle);
        SQLTableElement tableElementCode = new SQLTableElement(tableContractElement.getField("CODE"));
        list.add(tableElementCode);
        SQLTableElement tableElementNom = new SQLTableElement(tableContractElement.getField("NOM"));
        list.add(tableElementNom);
        SQLTableElement tableElementDesc = new SQLTableElement(tableContractElement.getField("DESCRIPTIF"));
        list.add(tableElementDesc);
        SQLTableElement tableElementPA = new SQLTableElement(tableContractElement.getField("PA_HT"));
        list.add(tableElementPA);
        SQLTableElement tableElementPV = new SQLTableElement(tableContractElement.getField("PV_HT"));
        list.add(tableElementPV);
        SQLTableElement tableElementQteU = new SQLTableElement(tableContractElement.getField("QTE_UNITAIRE"));
        list.add(tableElementQteU);
        SQLTableElement tableElementUV = new SQLTableElement(tableContractElement.getField("ID_UNITE_VENTE"));
        list.add(tableElementUV);
        if (tableContractElement.contains("INDICE_0")) {
            SQLTableElement tableElementIndice0 = new SQLTableElement(tableContractElement.getField("INDICE_0"), Long.class, (TableCellEditor)new DeviseCellEditor());
            tableElementIndice0.setRenderer((TableCellRenderer)new DeviseNiceTableCellRenderer());
            list.add(tableElementIndice0);
        }
        SQLTableElement tableElementQte = new SQLTableElement(tableContractElement.getField("QTE"));
        list.add(tableElementQte);
        SQLTableElement tableElementTaxe = new SQLTableElement(tableContractElement.getField("ID_TAXE"));
        list.add(tableElementTaxe);
        SQLTableElement tableElementRemise = new SQLTableElement(tableContractElement.getField("POURCENT_REMISE"));
        list.add(tableElementRemise);
        final SQLTableElement tableElementTotalPA = new SQLTableElement(tableContractElement.getField("T_PA_HT"));
        tableElementTotalPA.setEditable(false);
        list.add(tableElementTotalPA);
        final SQLTableElement tableElementTotalPV = new SQLTableElement(tableContractElement.getField("T_PV_HT"));
        tableElementTotalPV.setEditable(false);
        list.add(tableElementTotalPV);
        SQLTableElement tableElementTotalTTC = new SQLTableElement(tableContractElement.getField("T_PV_TTC"));
        tableElementTotalTTC.setEditable(false);
        list.add(tableElementTotalTTC);
        SQLRowValues rowValsDefault = new SQLRowValues(tableContractElement);
        rowValsDefault.put("NOM", (Object)"");
        rowValsDefault.put("QTE", 1);
        rowValsDefault.put("QTE_UNITAIRE", (Object)BigDecimal.ONE);
        rowValsDefault.put("ID_UNITE_VENTE", 2);
        rowValsDefault.put("PA_HT", (Object)BigDecimal.ZERO);
        rowValsDefault.put("PV_HT", (Object)BigDecimal.ZERO);
        rowValsDefault.put("ID_ARTICLE", (Object)tableContractElement.getForeignTable("ID_ARTICLE").getUndefinedIDNumber());
        rowValsDefault.put("ID_TAXE", TaxeCache.getCache().getFirstTaxe().getID());
        rowValsDefault.put("ID_STYLE", ((StyleSQLElement)dir.getElement(StyleSQLElement.class)).getAllStyleByName().get("Normal"));
        RowValuesTableModel model = new RowValuesTableModel(elt, list, tableContractElement.getField("NOM"), false, rowValsDefault);
        this.table = new RowValuesTable(model, new File(Configuration.getInstance().getConfDir(), "Table" + File.separator + "Table_ContractElements.xml"));
        ToolTipManager.sharedInstance().unregisterComponent((JComponent)this.table);
        ToolTipManager.sharedInstance().unregisterComponent(this.table.getTableHeader());
        this.comp = new RowValuesTableControlPanel(this.table);
        this.add((Component)this.comp, c);
        ++c.gridy;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)new JScrollPane((Component)this.table), c);
        this.table.setDefaultRenderer(Long.class, (TableCellRenderer)new RowValuesTableRenderer());
        final SQLTable sqlTableArticle = dir.getElement("ARTICLE").getTable();
        ArrayList<String> completionField = new ArrayList<String>();
        completionField.add("ID_UNITE_VENTE");
        completionField.add("QTE_UNITAIRE");
        completionField.add("PA_HT");
        completionField.add("PV_HT");
        completionField.add("ID_TAXE");
        completionField.add("DESCRIPTIF");
        AutoCompletionManager codeCompletionManager = new AutoCompletionManager(tableElementCode, sqlTableArticle.getField("CODE"), this.table, this.table.getRowValuesTableModel());
        codeCompletionManager.fill("NOM", "NOM");
        codeCompletionManager.fill("ID", "ID_ARTICLE");
        for (String string : completionField) {
            codeCompletionManager.fill(string, string);
        }
        ITransformer<SQLSelect, SQLSelect> selTrans = new ITransformer<SQLSelect, SQLSelect>(){

            public SQLSelect transformChecked(SQLSelect input) {
                SQLTable tableStock = sqlTableArticle.getTable("STOCK");
                input.andWhere(new Where((FieldRef)tableStock.getKey(), "=", (FieldRef)sqlTableArticle.getField("ID_STOCK")));
                input.setExcludeUndefined(false, tableStock);
                Where w = new Where((FieldRef)sqlTableArticle.getField("OBSOLETE"), "=", (Object)Boolean.FALSE).or(new Where(input.getAlias(tableStock.getKey()), "!=", tableStock.getUndefinedID()).and(new Where(input.getAlias(tableStock.getField("QTE_REEL")), ">", 0)));
                if (input.getWhere() != null) {
                    input.setWhere(input.getWhere().and(w));
                } else {
                    input.setWhere(w);
                }
                input.asString();
                return input;
            }
        };
        codeCompletionManager.setSelectTransformer((ITransformer)selTrans);
        AutoCompletionManager m2 = new AutoCompletionManager(tableElementNom, sqlTableArticle.getField("NOM"), this.table, this.table.getRowValuesTableModel());
        m2.fill("CODE", "CODE");
        m2.fill("ID", "ID_ARTICLE");
        for (String string : completionField) {
            m2.fill(string, string);
        }
        m2.setSelectTransformer((ITransformer)selTrans);
        AutoCompletionManager m3 = new AutoCompletionManager(tableElementArticle, sqlTableArticle.getField("NOM"), this.table, this.table.getRowValuesTableModel(), 2, true, true, new ValidStateChecker());
        m3.fill("CODE", "CODE");
        m3.fill("NOM", "NOM");
        for (String string : completionField) {
            m3.fill(string, string);
        }
        m3.setSelectTransformer((ITransformer)selTrans);
        tableElementTotalPV.setEditable(false);
        tableElementTotalPA.setEditable(false);
        tableElementTotalTTC.setEditable(false);
        tableElementQte.addModificationListener(tableElementTotalPV);
        tableElementQte.addModificationListener(tableElementTotalPA);
        tableElementQteU.addModificationListener(tableElementTotalPV);
        tableElementQteU.addModificationListener(tableElementTotalPA);
        tableElementTaxe.addModificationListener(tableElementTotalPV);
        tableElementTaxe.addModificationListener(tableElementTotalPA);
        tableElementPV.addModificationListener(tableElementTotalPV);
        tableElementPA.addModificationListener(tableElementTotalPA);
        tableElementRemise.addModificationListener(tableElementTotalPV);
        tableElementRemise.addModificationListener(tableElementTotalPA);
        tableElementTotalPV.setModifier(new CellDynamicModifier(){

            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                BigDecimal lremise = BigDecimal.ZERO;
                int qte = row.getObject("QTE") == null ? 0 : Integer.parseInt(row.getObject("QTE").toString());
                BigDecimal b = row.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)row.getObject("QTE_UNITAIRE");
                BigDecimal f = (BigDecimal)row.getObject("PV_HT");
                BigDecimal r = b.multiply(f.multiply(BigDecimal.valueOf(qte), DecimalUtils.HIGH_PRECISION), DecimalUtils.HIGH_PRECISION);
                if (lremise.compareTo(BigDecimal.ZERO) > 0 && lremise.compareTo(BigDecimal.valueOf(100L)) < 100) {
                    r = r.multiply(BigDecimal.valueOf(100L).subtract(lremise), DecimalUtils.HIGH_PRECISION).movePointLeft(2);
                }
                BigDecimal acomptePercent = row.getBigDecimal("POURCENT_REMISE");
                Remise remise = new Remise(acomptePercent, null);
                r = remise.getResultFrom(r);
                return r.setScale((int)tableElementTotalPV.getField().getType().getDecimalDigits(), 4);
            }
        });
        tableElementTotalPA.setModifier(new CellDynamicModifier(){

            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                int qte = Integer.parseInt(row.getObject("QTE").toString());
                BigDecimal b = row.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)row.getObject("QTE_UNITAIRE");
                BigDecimal f = (BigDecimal)row.getObject("PA_HT");
                BigDecimal rHA = b.multiply(new BigDecimal(qte), DecimalUtils.HIGH_PRECISION).multiply(f, DecimalUtils.HIGH_PRECISION).setScale(6, 4);
                return rHA.setScale((int)tableElementTotalPA.getField().getType().getDecimalDigits(), 4);
            }

            public void setValueFrom(SQLRowValues row, Object value) {
                super.setValueFrom(row, value);
            }
        });
        tableElementTotalPV.addModificationListener(tableElementTotalTTC);
        tableElementTotalTTC.setModifier(new CellDynamicModifier(){

            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                BigDecimal b = row.getObject("T_PV_HT") == null ? BigDecimal.ZERO : row.getBigDecimal("T_PV_HT");
                Number tva = row.getForeignIDNumber("ID_TAXE");
                if (tva != null) {
                    Float tauxFromId = TaxeCache.getCache().getTauxFromId(tva.intValue());
                    if (tauxFromId != null) {
                        return b.multiply(new BigDecimal(tauxFromId.floatValue()).movePointLeft(2).add(BigDecimal.ONE));
                    }
                    return b;
                }
                return b;
            }
        });
    }

    private void setColumnVisible(int col, boolean visible) {
        if (col >= 0) {
            XTableColumnModel columnModel = this.table.getColumnModel();
            columnModel.setColumnVisible(columnModel.getColumnByModelIndex(col), visible);
        }
    }

    public void updateField(String field, int id) {
        this.table.updateField(field, id);
    }

    public void insertFrom(String field, SQLRowValues row) {
        this.table.insertFrom(field, row);
    }

    public void insertFrom(String field, int id) {
        this.table.insertFrom(field, id);
    }

    public RowValuesTableModel getModel() {
        return this.table.getRowValuesTableModel();
    }

    public void setEditable(boolean b) {
        this.comp.setEditable(b);
        this.table.setEditable(b);
    }
}

