/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.contract;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import org.openconcerto.erp.core.finance.tax.element.TaxeSQLElement;
import org.openconcerto.erp.modules.AbstractModule;
import org.openconcerto.erp.modules.DBContext;
import org.openconcerto.erp.modules.ModuleElement;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.utils.SQLCreateTable;

public class ContractElementSQLElement
extends ModuleElement {
    public static final String TABLE_NAME = "CONTRACT_ELEMENT";

    public ContractElementSQLElement(AbstractModule module) {
        super(module, TABLE_NAME);
    }

    protected String getParentFFName() {
        return "ID_CONTRACT";
    }

    public static SQLCreateTable getCreateTable(DBContext ctxt) {
        SQLCreateTable res = ctxt.getCreateTable(TABLE_NAME);
        res.addVarCharColumn("CODE", 45);
        res.addVarCharColumn("NOM", 2048);
        res.addVarCharColumn("CODE_DOUANIER", 256);
        res.addForeignColumn("ID_PAYS", ctxt.getRoot().getTable("PAYS"));
        res.addVarCharColumn("DESCRIPTIF", 2048);
        res.addIntegerColumn("QTE", 1);
        res.addIntegerColumn("NIVEAU", 1);
        res.addDecimalColumn("QTE_UNITAIRE", 16, 6, BigDecimal.ONE, false);
        res.addDecimalColumn("PRIX_METRIQUE_VT_1", 16, 6, BigDecimal.ZERO, false);
        res.addDecimalColumn("PV_HT", 16, 6, BigDecimal.ZERO, false);
        res.addDecimalColumn("PA_HT", 16, 6, BigDecimal.ZERO, false);
        res.addDecimalColumn("PRIX_METRIQUE_HA_1", 16, 6, BigDecimal.ZERO, false);
        res.addDecimalColumn("T_PA_HT", 16, 6, BigDecimal.ZERO, false);
        res.addDecimalColumn("T_PA_TTC", 16, 2, BigDecimal.ZERO, false);
        res.addDecimalColumn("T_PV_TTC", 16, 2, BigDecimal.ZERO, false);
        res.addDecimalColumn("T_PV_HT", 16, 6, BigDecimal.ZERO, false);
        res.addDecimalColumn("POURCENT_REMISE", 12, 8, BigDecimal.ZERO, false);
        res.addForeignColumn("ID_METRIQUE_1", ctxt.getRoot().getTable("METRIQUE"));
        res.addForeignColumn("ID_METRIQUE_2", ctxt.getRoot().getTable("METRIQUE"));
        res.addForeignColumn("ID_METRIQUE_3", ctxt.getRoot().getTable("METRIQUE"));
        res.addColumn("VALEUR_METRIQUE_1", "real DEFAULT 0");
        res.addColumn("VALEUR_METRIQUE_2", "real DEFAULT 0");
        res.addColumn("VALEUR_METRIQUE_3", "real DEFAULT 0");
        res.addColumn("POIDS", "real DEFAULT 0");
        res.addColumn("T_POIDS", "real DEFAULT 0");
        res.addDecimalColumn("T_ECO_CONTRIBUTION", 16, 2, BigDecimal.ZERO, false);
        res.addDecimalColumn("ECO_CONTRIBUTION", 16, 2, BigDecimal.ZERO, false);
        res.addDecimalColumn("T_POIDS_BRUT", 16, 8, BigDecimal.ZERO, false);
        res.addDecimalColumn("HAUTEUR", 16, 8, BigDecimal.ZERO, true);
        res.addDecimalColumn("LARGEUR", 16, 8, BigDecimal.ZERO, true);
        res.addDecimalColumn("LONGUEUR", 16, 8, BigDecimal.ZERO, true);
        res.addDecimalColumn("TARE", 16, 8, BigDecimal.ZERO, true);
        res.addDecimalColumn("POIDS_COLIS_NET", 16, 8, BigDecimal.ZERO, false);
        res.addDecimalColumn("T_POIDS_COLIS_NET", 16, 8, BigDecimal.ZERO, false);
        res.addIntegerColumn("NB_COLIS", 1);
        res.addForeignColumn("ID_ECO_CONTRIBUTION", ctxt.getRoot().findTable("ECO_CONTRIBUTION"));
        res.addDecimalColumn("PRIX_METRIQUE_HA_2", 16, 6, BigDecimal.ZERO, false);
        res.addDecimalColumn("PRIX_METRIQUE_HA_3", 16, 6, BigDecimal.ZERO, false);
        res.addDecimalColumn("PRIX_METRIQUE_VT_2", 16, 6, BigDecimal.ZERO, false);
        res.addDecimalColumn("PRIX_METRIQUE_VT_3", 16, 6, BigDecimal.ZERO, false);
        res.addDecimalColumn("PV_U_DEVISE", 16, 6, BigDecimal.ZERO, false);
        res.addDecimalColumn("PV_T_DEVISE", 16, 6, BigDecimal.ZERO, false);
        res.addBooleanColumn("SERVICE", Boolean.FALSE, false);
        res.addForeignColumn("UNITE_VENTE");
        res.addForeignColumn("ID_MODE_VENTE_ARTICLE", ctxt.getRoot().getTable("MODE_VENTE_ARTICLE"));
        res.addForeignColumn("ARTICLE");
        res.addForeignColumn("FAMILLE_ARTICLE");
        res.addForeignColumn("DEPOT_STOCK");
        res.addForeignColumn("STYLE");
        res.addForeignColumn("ID_DEVISE", ctxt.getRoot().findTable("DEVISE"));
        res.addForeignColumn("ID_TAXE", ((TaxeSQLElement)ctxt.getElementDirectory().getElement(TaxeSQLElement.class)).getTable());
        res.addForeignColumn("CONTRACT");
        return res;
    }

    protected List<String> getListFields() {
        return Collections.emptyList();
    }

    protected SQLComponent createComponent() {
        return null;
    }
}

