/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.contract;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.common.ui.AbstractVenteArticleItemTable;
import org.openconcerto.erp.core.common.ui.Remise;
import org.openconcerto.erp.core.common.ui.TotalCalculator;
import org.openconcerto.erp.core.finance.payment.element.SEPAMandateSQLElement;
import org.openconcerto.erp.core.finance.payment.element.TypeReglementSQLElement;
import org.openconcerto.erp.core.finance.tax.element.TaxeSQLElement;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.sales.invoice.element.SaisieVenteFactureSQLElement;
import org.openconcerto.erp.core.sales.invoice.report.VenteFactureXmlSheet;
import org.openconcerto.erp.core.sales.quote.element.DevisSQLElement;
import org.openconcerto.erp.generationDoc.SheetXml;
import org.openconcerto.erp.generationEcritures.GenerationMvtSaisieVenteFacture;
import org.openconcerto.erp.modules.AbstractModule;
import org.openconcerto.erp.modules.DBContext;
import org.openconcerto.erp.modules.ModuleElement;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementLink;
import org.openconcerto.sql.element.SQLElementLinksSetup;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBackgroundTableCache;
import org.openconcerto.sql.model.SQLBackgroundTableCacheItem;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesCluster;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.UndefinedRowValuesCache;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.sql.utils.SQLCreateTableBase;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.RTInterruptedException;
import org.openconcerto.utils.cc.ITransformer;

public final class ContractBillingPeriodSQLElement
extends ModuleElement {
    public static final String TABLE_NAME = "CONTRACT_BILLING_PERIOD";
    public static final String FIELD_INVOICED_OUTSIDE = "INVOICED_OUTSIDE";
    public static final String FIELD_ID_REGLEMENT = "ID_TYPE_REGLEMENT";
    public static final String FIELD_ID_TAXE = "ID_TAXE";
    public static final String FIELD_AMOUNT = "AMOUNT";
    public static final String FIELD_DURATION_IN_MONTHS = "DURATION_IN_MONTHS";
    public static final String FIELD_DATE = "DATE";
    public static final String FIELD_CONTRACT = "ID_CONTRACT";
    public static final String FIELD_INVOICE = "ID_SAISIE_VENTE_FACTURE";
    public static final String FIELD_INVOICE_2 = "ID_SAISIE_VENTE_FACTURE_COMPLEMENT";
    public static final String FIELD_QUOTE = "ID_DEVIS";
    private static final Comparator<SQLRowAccessor> DATE_COMPARATOR = new Comparator<SQLRowAccessor>(){

        @Override
        public int compare(SQLRowAccessor o1, SQLRowAccessor o2) {
            return ((java.util.Date)o1.getObjectAs(ContractBillingPeriodSQLElement.FIELD_DATE, java.util.Date.class)).compareTo((java.util.Date)o2.getObjectAs(ContractBillingPeriodSQLElement.FIELD_DATE, java.util.Date.class));
        }
    };

    protected static SQLCreateTable getCreateTable(DBContext ctxt, SQLCreateTable createSubscriptionTable) {
        SQLCreateTable res = ctxt.getCreateTable(TABLE_NAME);
        res.setCreateOrder(false);
        res.addForeignColumn(FIELD_CONTRACT, (SQLCreateTableBase)createSubscriptionTable);
        res.addColumn(FIELD_DATE, "date", null, false);
        res.addIntegerColumn(FIELD_DURATION_IN_MONTHS, 1);
        res.addDecimalColumn(FIELD_AMOUNT, 16, 6, BigDecimal.ZERO, false);
        res.addForeignColumn(FIELD_ID_TAXE, ((TaxeSQLElement)ctxt.getElementDirectory().getElement(TaxeSQLElement.class)).getTable());
        res.addForeignColumn(FIELD_ID_REGLEMENT, ((TypeReglementSQLElement)ctxt.getElementDirectory().getElement(TypeReglementSQLElement.class)).getTable());
        res.addForeignColumn(FIELD_INVOICE, ((SaisieVenteFactureSQLElement)ctxt.getElementDirectory().getElement(SaisieVenteFactureSQLElement.class)).getTable());
        res.addForeignColumn(FIELD_INVOICE_2, ((SaisieVenteFactureSQLElement)ctxt.getElementDirectory().getElement(SaisieVenteFactureSQLElement.class)).getTable());
        res.addForeignColumn(FIELD_QUOTE, ((DevisSQLElement)ctxt.getElementDirectory().getElement(DevisSQLElement.class)).getTable());
        res.addBooleanColumn(FIELD_INVOICED_OUTSIDE, Boolean.FALSE, false);
        return res;
    }

    ContractBillingPeriodSQLElement(AbstractModule module) {
        super(module, TABLE_NAME);
    }

    protected void setupLinks(SQLElementLinksSetup links) {
        super.setupLinks(links);
        links.get(FIELD_CONTRACT).setType(SQLElementLink.LinkType.PARENT, SQLElement.ReferenceAction.CASCADE);
        links.get(FIELD_INVOICE).setType(SQLElementLink.LinkType.ASSOCIATION, SQLElement.ReferenceAction.RESTRICT);
    }

    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(FIELD_DATE);
        l.add(FIELD_AMOUNT);
        l.add(FIELD_ID_REGLEMENT);
        return l;
    }

    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(FIELD_DATE);
        l.add(FIELD_AMOUNT);
        l.add(FIELD_ID_REGLEMENT);
        return l;
    }

    public static final boolean isInvoiced(SQLRowValues r) {
        return r.getObject(FIELD_INVOICE) != null && !r.isForeignEmpty(FIELD_INVOICE) || r.getBoolean(FIELD_INVOICED_OUTSIDE) != false;
    }

    public static final boolean isInvoiced2(SQLRowValues r) {
        return r.getObject(FIELD_INVOICE_2) != null && !r.isForeignEmpty(FIELD_INVOICE_2);
    }

    public static final boolean isQuoted(SQLRowValues r) {
        return r.getObject(FIELD_QUOTE) != null && !r.isForeignEmpty(FIELD_QUOTE);
    }

    public static final boolean isQuotedAccepted(SQLRowValues r) {
        if (!ContractBillingPeriodSQLElement.isQuoted(r)) {
            return false;
        }
        SQLRowAccessor rQuote = r.getForeign(FIELD_QUOTE);
        return rQuote.getForeignID("ID_ETAT_DEVIS") == 4;
    }

    public static boolean isPaid(SQLRowValues r) {
        if (!ContractBillingPeriodSQLElement.isInvoiced(r)) {
            return false;
        }
        SQLRowAccessor rInvoice = r.getForeign(FIELD_INVOICE);
        Collection referentRows = rInvoice.getReferentRows(rInvoice.getTable().getTable("ECHEANCE_CLIENT"));
        if (referentRows.isEmpty()) {
            return true;
        }
        for (SQLRowAccessor rEcheance : referentRows) {
            if (rEcheance.getBoolean("REGLE").booleanValue() || rEcheance.getBoolean("REG_COMPTA").booleanValue()) continue;
            return false;
        }
        return true;
    }

    protected SQLComponent createComponent() {
        return null;
    }

    public final List<SQLRowValues> generateInvoices(Where paymentWhere, ProgressListener listener, BigDecimal indiceN, boolean showDocument) throws SQLException, IOException {
        SQLTable table = this.getTable();
        SQLField idInvoice = table.getField(FIELD_INVOICE);
        SQLTable invoiceT = idInvoice.getForeignTable();
        Where notInvoicedW = new Where((FieldRef)idInvoice, "=", (Object)invoiceT.getUndefinedIDNumber()).and(new Where((FieldRef)table.getField(FIELD_INVOICED_OUTSIDE), "=", (Object)Boolean.FALSE));
        SQLSelect selIDs = new SQLSelect();
        selIDs.addSelect((FieldRef)table.getKey());
        selIDs.setWhere(notInvoicedW.and(paymentWhere));
        List billingPeriodIDs = table.getDBSystemRoot().getDataSource().executeCol(selIDs.asString());
        return this.generateInvoices(listener, selIDs.getWhere(), billingPeriodIDs, indiceN, showDocument);
    }

    private String fill(String string, Map<String, String> mapValues) {
        String result = string;
        for (String key : mapValues.keySet()) {
            String replacement = mapValues.get(key);
            if (replacement == null) {
                replacement = "";
            }
            result = result.replace("{" + key + "}", replacement);
        }
        return result;
    }

    public List<SQLRowValues> generateInvoices(final ProgressListener listener, final Where where, List<Number> billingPeriodIDs, final BigDecimal indiceN, boolean showDocument) throws SQLException, IOException {
        final SQLTable table = this.getTable();
        final SQLField contractF = table.getField(FIELD_CONTRACT);
        final SQLField paymentInvoiceF = table.getField(FIELD_INVOICE);
        final SQLTable invoiceT = paymentInvoiceF.getForeignTable();
        int billingPeriodCount = billingPeriodIDs.size();
        boolean firstSelectProgress = true;
        boolean generationProgress = true;
        final int progressMax = 1 + billingPeriodCount * 2 + 1;
        final AtomicInteger progress = new AtomicInteger(1);
        if (listener != null) {
            listener.progressChanged("queried invoice IDs", 100 * progress.get() / progressMax);
        }
        SQLRowValues billingPeriosValues = new SQLRowValues(table);
        billingPeriosValues.setAllToNull();
        SQLRowValues subscriptionVals = billingPeriosValues.putRowValues(contractF.getName()).setAllToNull();
        subscriptionVals.putRowValues("ID_CLIENT").putRowValues("ID_MODE_REGLEMENT").setAllToNull();
        String mandateFieldName = "ID_SEPA_MANDATE";
        subscriptionVals.putRowValues("ID_SEPA_MANDATE").setAllToNull();
        new SQLRowValues(table).put(contractF.getName(), (Object)subscriptionVals).putNulls(new String[]{FIELD_DATE});
        final SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create((SQLRowValues)billingPeriosValues);
        final Path mainPaymentToSiblings = (Path)((Path)new Path(table).add(contractF, Link.Direction.FOREIGN)).add(contractF, Link.Direction.REFERENT);
        fetcher.requirePath(mainPaymentToSiblings);
        fetcher.appendSelTransf((ITransformer)new ITransformer<SQLSelect, SQLSelect>(){

            public SQLSelect transformChecked(SQLSelect sel) {
                sel.setLockStrength(SQLSelect.LockStrength.UPDATE);
                for (SQLTable t : mainPaymentToSiblings.getTables()) {
                    sel.addLockedTable(sel.getAlias(t).getAlias());
                }
                return sel;
            }
        });
        ArrayList<SQLRowValues> newInvoices = new ArrayList<SQLRowValues>();
        HashMap<SQLRow, Future> sheetFutures = new HashMap<SQLRow, Future>();
        int groupSize = 5;
        RTInterruptedException interruptedExn = null;
        try {
            int i = 0;
            while (i < billingPeriodCount) {
                final List<Number> txIDs = billingPeriodIDs.subList(i, Math.min(i + 5, billingPeriodCount));
                List txInvoices = (List)SQLUtils.executeAtomic((SQLDataSource)table.getDBSystemRoot().getDataSource(), (ConnectionHandlerNoSetup)new ConnectionHandlerNoSetup<List<SQLRowValues>, SQLException>(){

                    public List<SQLRowValues> handle(SQLDataSource ds) throws SQLException {
                        ArrayList<SQLRowValues> res = new ArrayList<SQLRowValues>();
                        Where w = new Where((FieldRef)table.getKey(), (Collection)txIDs);
                        if (where != null) {
                            w = where.and(new Where((FieldRef)table.getKey(), (Collection)txIDs));
                        }
                        for (SQLRowValues billingPeriodToInvoice : fetcher.fetch(w)) {
                            SQLRowValues contract = (SQLRowValues)billingPeriodToInvoice.getForeign(contractF.getName());
                            LocalDate now = LocalDate.now();
                            Date invoiceDate = Date.valueOf(now);
                            Date paymentDate = (Date)billingPeriodToInvoice.getObjectAs(ContractBillingPeriodSQLElement.FIELD_DATE, Date.class);
                            long days = ChronoUnit.DAYS.between(now, paymentDate.toLocalDate());
                            if (days <= 0L) {
                                days = 30L;
                            }
                            SQLRowValues invoiceVals = SQLInjector.getInjector((SQLTable)billingPeriodToInvoice.getTable().getTable("CONTRACT"), (SQLTable)invoiceT).createRowValuesFrom(contract.getID());
                            invoiceVals.put(ContractBillingPeriodSQLElement.FIELD_DATE, (Object)invoiceDate);
                            String subscriptionNumber = contract.getString("NUMBER");
                            invoiceVals.put("NOM", (Object)contract.getString("REFERENCE"));
                            invoiceVals.put("NUMERO", (Object)NumerotationAutoSQLElement.getNextNumero(SaisieVenteFactureSQLElement.class, (java.util.Date)invoiceDate));
                            invoiceVals.put("ID_CLIENT", contract.getObject("ID_CLIENT"));
                            invoiceVals.put("INFOS", (Object)"");
                            SQLRowValues rowVals = invoiceVals.putRowValues("ID_MODE_REGLEMENT");
                            SQLRowAccessor foreignRegl = contract.getForeign("ID_CLIENT").getForeign("ID_MODE_REGLEMENT");
                            rowVals.put(ContractBillingPeriodSQLElement.FIELD_ID_REGLEMENT, billingPeriodToInvoice.getObject(ContractBillingPeriodSQLElement.FIELD_ID_REGLEMENT));
                            rowVals.put("DATE_FACTURE", foreignRegl.getObject("DATE_FACTURE"));
                            rowVals.put("COMPTANT", foreignRegl.getObject("COMPTANT"));
                            rowVals.put("FIN_MOIS", foreignRegl.getObject("FIN_MOIS"));
                            rowVals.put("LENJOUR", foreignRegl.getObject("LENJOUR"));
                            rowVals.put("AJOURS", foreignRegl.getObject("AJOURS"));
                            rowVals.put("ID_BANQUE", foreignRegl.getObject("ID_BANQUE"));
                            if (rowVals.getInt(ContractBillingPeriodSQLElement.FIELD_ID_REGLEMENT) == 10) {
                                SQLRowAccessor sepaMandate;
                                if (contract.isForeignEmpty("ID_SEPA_MANDATE")) {
                                    SEPAMandateSQLElement mandateElem = (SEPAMandateSQLElement)ContractBillingPeriodSQLElement.this.getDirectory().getElement(SEPAMandateSQLElement.class);
                                    String mandateID = mandateElem.generateMandateIdentification(subscriptionNumber, '0', true, true);
                                    SQLRowValues newVals = mandateElem.createRecurrent(contract.getForeignIDNumber("ID_CLIENT"), mandateID, (java.util.Date)contract.getObjectAs("START_DATE", java.util.Date.class));
                                    contract.createEmptyUpdateRow().put("ID_SEPA_MANDATE", (Object)newVals);
                                    sepaMandate = newVals.commit();
                                } else {
                                    sepaMandate = contract.getForeign("ID_SEPA_MANDATE");
                                }
                                rowVals.putForeignID("ID_SEPA_MANDATE", sepaMandate);
                            }
                            Set referentRowsFactItems = invoiceVals.getReferentRows(invoiceT.getTable("SAISIE_VENTE_FACTURE_ELEMENT").getField(ContractBillingPeriodSQLElement.FIELD_INVOICE));
                            BigDecimal indice0Contrat = contract.getBigDecimal("INDICE_0");
                            HashMap<String, String> mapValue = new HashMap<String, String>();
                            mapValue.put("ContratNumero", contract.getString("NUMERO"));
                            mapValue.put("ContratReference", contract.getString("REFERENCE"));
                            Calendar date = billingPeriodToInvoice.getDate(ContractBillingPeriodSQLElement.FIELD_DATE);
                            SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
                            int months = billingPeriodToInvoice.getInt(ContractBillingPeriodSQLElement.FIELD_DURATION_IN_MONTHS);
                            mapValue.put("ContratDebutPeriode", dateFormat.format(date.getTime()));
                            date.add(2, months - 1);
                            date.set(5, date.getActualMaximum(5));
                            mapValue.put("ContratFinPeriode", dateFormat.format(date.getTime()));
                            for (SQLRowValues item : referentRowsFactItems) {
                                item.put("NOM", (Object)ContractBillingPeriodSQLElement.this.fill(item.getString("NOM"), mapValue));
                            }
                            if (indiceN != null) {
                                for (SQLRowValues item : referentRowsFactItems) {
                                    Long indice0 = (Long)item.getObjectAs("INDICE_0", Long.class);
                                    if (indice0 == null && indice0Contrat != null) {
                                        item.put("INDICE_0", (Object)indice0Contrat.movePointRight(2).setScale(2, RoundingMode.HALF_UP).longValue());
                                    }
                                    item.put("INDICE_N", (Object)indiceN.movePointRight(2).setScale(2, RoundingMode.HALF_UP).longValue());
                                    BigDecimal calculMontantRevise = AbstractVenteArticleItemTable.calculMontantRevise((SQLRowValues)item, (boolean)false);
                                    item.put("PRIX_METRIQUE_VT_1", (Object)calculMontantRevise);
                                    item.put("PV_HT", (Object)calculMontantRevise);
                                    int qte = item.getObject("QTE") == null ? 0 : Integer.parseInt(item.getObject("QTE").toString());
                                    BigDecimal b = item.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)item.getObject("QTE_UNITAIRE");
                                    BigDecimal f = (BigDecimal)item.getObject("PV_HT");
                                    BigDecimal r = b.multiply(f.multiply(BigDecimal.valueOf(qte), DecimalUtils.HIGH_PRECISION), DecimalUtils.HIGH_PRECISION);
                                    if (item.getTable().getFieldsName().contains("MONTANT_REMISE")) {
                                        BigDecimal acomptePercent = item.getBigDecimal("POURCENT_REMISE");
                                        BigDecimal acompteMontant = item.getBigDecimal("MONTANT_REMISE");
                                        Remise remise = new Remise(acomptePercent, acompteMontant);
                                        r = remise.getResultFrom(r);
                                    }
                                    item.put("T_PV_HT", (Object)r);
                                    int idTaux = item.getForeignID(ContractBillingPeriodSQLElement.FIELD_ID_TAXE);
                                    Float resultTaux = TaxeCache.getCache().getTauxFromId(idTaux);
                                    float taux = resultTaux == null ? 0.0f : resultTaux.floatValue();
                                    BigDecimal resultTTC = r.multiply(BigDecimal.valueOf(taux).movePointLeft(2).add(BigDecimal.ONE), DecimalUtils.HIGH_PRECISION).setScale(2, 4);
                                    item.put("T_PV_TTC", (Object)resultTTC);
                                }
                            }
                            TotalCalculator calc = ContractBillingPeriodSQLElement.this.getTotalCalculator(referentRowsFactItems);
                            invoiceVals.put("T_HT", (Object)calc.getTotalHT().movePointRight(2).longValueExact());
                            invoiceVals.put("T_TVA", (Object)calc.getTotalTVA().movePointRight(2).longValueExact());
                            invoiceVals.put("T_TTC", (Object)calc.getTotalTTC().movePointRight(2).longValueExact());
                            invoiceVals.put("NET_A_PAYER", invoiceVals.getObject("T_TTC"));
                            invoiceVals.put("ID_COMMERCIAL", contract.getObject("ID_COMMERCIAL"));
                            invoiceVals.put("ID_TAXE_PORT", TaxeCache.getCache().getFirstTaxe().getID());
                            SQLRowValues rowValsElementLigne1 = new SQLRowValues(UndefinedRowValuesCache.getInstance().getDefaultRowValues(invoiceVals.getTable().getTable("SAISIE_VENTE_FACTURE_ELEMENT")));
                            rowValsElementLigne1.put(ContractBillingPeriodSQLElement.FIELD_ID_TAXE, billingPeriodToInvoice.getInt(ContractBillingPeriodSQLElement.FIELD_ID_TAXE));
                            rowValsElementLigne1.put("ID_STYLE", 2);
                            rowValsElementLigne1.put("CODE", (Object)"");
                            Calendar cal = date;
                            SimpleDateFormat sp = new SimpleDateFormat("MMMM yyyy");
                            String range = sp.format(cal.getTime());
                            int nbMonths = months;
                            if (nbMonths > 1) {
                                cal.add(2, nbMonths - 1);
                                range = String.valueOf(range) + " \u00e0 " + sp.format(cal.getTime());
                            }
                            rowValsElementLigne1.put("NOM", (Object)(String.valueOf(nbMonths) + " mois : " + range));
                            rowValsElementLigne1.put(ContractBillingPeriodSQLElement.FIELD_INVOICE, (Object)invoiceVals);
                            SQLRowValues newInvoice = invoiceVals.getGraph().store(SQLRowValuesCluster.StoreMode.COMMIT).getStoredValues(invoiceVals);
                            NumerotationAutoSQLElement.updateNextNumero(SaisieVenteFactureSQLElement.class, (java.util.Date)((java.util.Date)newInvoice.getObjectAs(ContractBillingPeriodSQLElement.FIELD_DATE, java.util.Date.class)), (String)newInvoice.getString("NUMERO"));
                            billingPeriodToInvoice.createEmptyUpdateRow().putForeignID(paymentInvoiceF.getName(), (SQLRowAccessor)newInvoice).update();
                            if (listener != null) {
                                listener.progressChanged("creating invoice", 100 * progress.incrementAndGet() / progressMax);
                            }
                            try {
                                new GenerationMvtSaisieVenteFacture(newInvoice.getID(), true).genereMouvement();
                            }
                            catch (Exception e) {
                                throw new SQLException("Couldn't generate mouvements for " + newInvoice, e);
                            }
                            if (listener != null) {
                                listener.progressChanged("creating mouvement", 100 * progress.incrementAndGet() / progressMax);
                            }
                            res.add(newInvoice);
                        }
                        return res;
                    }
                });
                for (SQLRowValues newInvoice : txInvoices) {
                    SQLRow r = newInvoice.asRow();
                    sheetFutures.put(r, new VenteFactureXmlSheet(r).createDocumentAsynchronous());
                }
                newInvoices.addAll(txInvoices);
                i += 5;
            }
        }
        catch (RTInterruptedException e) {
            interruptedExn = e;
        }
        try {
            if (listener != null) {
                listener.progressChanged("waiting for invoice generation", 99);
            }
            for (Map.Entry e : sheetFutures.entrySet()) {
                try {
                    SheetXml sheetXml = (SheetXml)((Future)e.getValue()).get();
                    if (!showDocument) continue;
                    sheetXml.showPrintAndExport(true, false, true);
                }
                catch (Exception exn) {
                    throw new IOException("Couldn't generate file for " + e.getKey(), exn);
                }
            }
        }
        catch (Exception e) {
            if (interruptedExn == null) {
                throw e;
            }
            interruptedExn.addSuppressed((Throwable)e);
            throw interruptedExn;
        }
        if (listener != null) {
            listener.progressChanged("done", 100);
        }
        return newInvoices;
    }

    protected List<SQLRowValues> generate(BigDecimal amountToCreate, java.util.Date startDate, boolean inclusive, int months, boolean hasNoInvoices, Object reglRecurr) {
        if (amountToCreate.signum() <= 0) {
            return Collections.emptyList();
        }
        int paymentToCreateCount = Math.max(months, 1);
        BigDecimal[] divideAndRemainder = amountToCreate.movePointRight(2).divideAndRemainder(BigDecimal.valueOf(paymentToCreateCount));
        BigDecimal regularAmount = divideAndRemainder[0].movePointLeft(2);
        BigDecimal lastAmount = regularAmount.add(divideAndRemainder[1].movePointLeft(2));
        assert (regularAmount.multiply(BigDecimal.valueOf(paymentToCreateCount - 1)).add(lastAmount).compareTo(amountToCreate) == 0);
        ArrayList<SQLRowValues> res = new ArrayList<SQLRowValues>(paymentToCreateCount);
        SQLRowValues newVals = new SQLRowValues(this.getTable());
        newVals.put(FIELD_INVOICED_OUTSIDE, (Object)Boolean.FALSE);
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        if (!inclusive) {
            cal.add(2, 1);
        }
        int i = 0;
        while (i < paymentToCreateCount) {
            newVals.put(FIELD_DATE, (Object)cal.getTime());
            newVals.put(FIELD_AMOUNT, (Object)(i < paymentToCreateCount - 1 ? regularAmount : lastAmount));
            newVals.put(FIELD_ID_REGLEMENT, reglRecurr);
            newVals.putEmptyLink(FIELD_INVOICE);
            res.add(newVals.deepCopy());
            cal.add(2, 1);
            ++i;
        }
        return res;
    }

    public TotalCalculator getTotalCalculator(Collection<SQLRowValues> rowValsItems) {
        TotalCalculator calc = new TotalCalculator("T_PA_HT", "T_PV_HT", null, null);
        String val = DefaultNXProps.getInstance().getStringProperty("ArticleService");
        Boolean bServiceActive = Boolean.valueOf(val);
        calc.setServiceActive(bServiceActive != null && bServiceActive != false);
        SQLBackgroundTableCacheItem cacheForTable = SQLBackgroundTableCache.getInstance().getCacheForTable(this.getTable().getTable("ARTICLE"));
        int i = 0;
        for (SQLRowValues r : rowValsItems) {
            int id = r.getForeignID("ID_ARTICLE");
            calc.addLine((SQLRowAccessor)r, (SQLRowAccessor)cacheForTable.getRowFromId(id), i++, false);
        }
        calc.checkResult();
        return calc;
    }

    public static interface ProgressListener {
        public void progressChanged(String var1, int var2);
    }
}

