/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.contract;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.ProgressMonitor;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.sales.invoice.element.EcheanceClientSQLElement;
import org.openconcerto.erp.core.sales.invoice.element.SaisieVenteFactureSQLElement;
import org.openconcerto.modules.contract.BillingPeriodGridListener;
import org.openconcerto.modules.contract.ContractBillingPeriodSQLElement;
import org.openconcerto.modules.contract.ContractSQLElement;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSelectJoin;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.TableRef;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.IListPanel;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.ui.grid.DecoratedGridPanel;
import org.openconcerto.ui.grid.GridItem;
import org.openconcerto.ui.grid.GridListener;
import org.openconcerto.ui.grid.YearsHeaderPanel;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.cc.ITransformer;

public class ContractBillingPanel
extends JPanel {
    ComptaPropsConfiguration conf;
    JComponent panel = new JPanel();
    JSpinner spin;
    final JCheckBox checkManualMode;
    public static final Color NOT_INVOICED_COLOR = new Color(200, 200, 200, 150);
    public static final Color NOT_INVOICED_BORDER_COLOR = new Color(120, 120, 120, 150);
    public static final Color QUOTED_ACCEPTED_COLOR = Color.decode("#f29338");
    public static final Color QUOTED_ACCEPTED_BORDER_COLOR = Color.decode("#ce6c0d");
    public static final Color INVOICED_COLOR = Color.decode("#2196f3");
    public static final Color INVOICED_BORDER_COLOR = Color.decode("#0069c0");
    public static final Color PAID_COLOR = new Color(50, 200, 160, 150);
    public static final Color PAID_BORDER_COLOR = new Color(25, 100, 80, 150);
    private JTextField textSearch = new JTextField(20);
    Timer timer;
    private JCheckBox checkActiveOnlyMode;

    public ContractBillingPanel(final ComptaPropsConfiguration conf) {
        this.conf = conf;
        JPanel toolbar = new JPanel();
        toolbar.setLayout(new FlowLayout(0));
        toolbar.add(new JLabel("Ann\u00e9e"));
        int year = Calendar.getInstance().get(1);
        this.spin = new JSpinner(new SpinnerNumberModel(year, year - 100, year + 100, 1));
        toolbar.add(this.spin);
        toolbar.add(new JLabel(" Recherche"));
        this.textSearch = new JTextField(20);
        toolbar.add(this.textSearch);
        this.textSearch.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (ContractBillingPanel.this.timer != null) {
                    ContractBillingPanel.this.timer.stop();
                }
                ContractBillingPanel.this.timer = new Timer(300, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        (this).ContractBillingPanel.this.timer.stop();
                        ContractBillingPanel.this.scheduleReload();
                    }
                });
                ContractBillingPanel.this.timer.start();
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 1;
        this.add((Component)toolbar, c);
        ++c.gridy;
        this.add((Component)new JSeparator(0), c);
        ++c.gridy;
        c.weighty = 1.0;
        this.panel.setMinimumSize(new Dimension(1124, 400));
        this.panel.setPreferredSize(new Dimension(1124, 400));
        this.add((Component)this.panel, c);
        JPanel bottomBar = new JPanel();
        bottomBar.setLayout(new FlowLayout(0));
        this.checkManualMode = new JCheckBox("Mode manuel");
        bottomBar.add(this.checkManualMode);
        this.checkActiveOnlyMode = new JCheckBox("Actif uniquement");
        this.checkActiveOnlyMode.setSelected(true);
        bottomBar.add(this.checkActiveOnlyMode);
        final JButton buttonPeriod = new JButton("G\u00e9n\u00e9rer toutes les p\u00e9riodes de facturation");
        buttonPeriod.addActionListener(new ActionListener(){
            private final DateTimeFormatter DATE_FMT = DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG);

            @Override
            public void actionPerformed(ActionEvent e) {
                final JFrame f = new JFrame("Cr\u00e9ation de p\u00e9riodes");
                Calendar cal = Calendar.getInstance();
                cal.add(3, 3);
                final JDate jdate = new JDate(false);
                jdate.setDate(cal.getTime());
                final JButton genBtn = new JButton(new AbstractAction("G\u00e9n\u00e9rer"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(jdate.getDateInMillis()), ZoneId.systemDefault());
                        final ProgressMonitor progressMonitor = new ProgressMonitor(buttonPeriod, "G\u00e9n\u00e9ration des p\u00e9riodes jusqu'au " + DATE_FMT.format(dateTime), "", 0, 100);
                        progressMonitor.setMillisToPopup(500);
                        progressMonitor.setProgress(0);
                        final ContractBillingPeriodSQLElement paymentSQLElem = (ContractBillingPeriodSQLElement)conf.getDirectory().getElement(ContractBillingPeriodSQLElement.class);
                        final SwingWorker<Object, Void> worker = new SwingWorker<Object, Void>(){

                            @Override
                            protected Object doInBackground() throws Exception {
                                ContractSQLElement element = (ContractSQLElement)conf.getDirectory().getElement(ContractSQLElement.class);
                                SQLTable table = element.getTable();
                                SQLSelect sel = new SQLSelect();
                                sel.addSelectStar((TableRef)table);
                                sel.setWhere(new Where((FieldRef)table.getField("STOPPED"), "=", (Object)false));
                                List execute = SQLRowListRSH.execute((SQLSelect)sel);
                                element.createBillingPeriodElement(execute);
                                return null;
                            }

                            @Override
                            protected void done() {
                                try {
                                    this.get();
                                    String invoiceName = paymentSQLElem.getPluralName();
                                    ContractBillingPanel.this.scheduleReload();
                                    JOptionPane.showMessageDialog(buttonPeriod, "Les " + invoiceName + " ont \u00e9t\u00e9 cr\u00e9\u00e9.");
                                }
                                catch (CancellationException exn) {
                                    JOptionPane.showMessageDialog(buttonPeriod, "La g\u00e9n\u00e9ration a \u00e9t\u00e9 annul\u00e9e.");
                                }
                                catch (Exception exn) {
                                    ExceptionHandler.handle((Component)buttonPeriod, (String)"Impossible de g\u00e9n\u00e9rer", (Throwable)exn);
                                }
                            }
                        };
                        worker.addPropertyChangeListener(new PropertyChangeListener(){

                            @Override
                            public void propertyChange(PropertyChangeEvent evt) {
                                if ("progress".equals(evt.getPropertyName())) {
                                    progressMonitor.setProgress(((Number)evt.getNewValue()).intValue());
                                    if (progressMonitor.isCanceled()) {
                                        worker.cancel(true);
                                    }
                                }
                            }
                        });
                        f.dispose();
                        worker.execute();
                    }
                });
                jdate.addValueListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        genBtn.setEnabled(evt.getNewValue() != null);
                    }
                });
                genBtn.setEnabled(jdate.getValue() != null);
                FormLayouter layouter = new FormLayouter(f.getContentPane(), 1, 1);
                layouter.add("Inclure les r\u00e8glements jusqu'au", (Component)jdate);
                layouter.add(genBtn);
                f.pack();
                f.setLocationRelativeTo(null);
                f.setVisible(true);
            }
        });
        bottomBar.add(buttonPeriod);
        JButton buttonFacture = new JButton("G\u00e9n\u00e9rer les factures");
        buttonFacture.addActionListener(new ActionListener(){
            private final DateTimeFormatter DATE_FMT = DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG);

            @Override
            public void actionPerformed(ActionEvent e) {
                final JFrame f = new JFrame("Cr\u00e9ation de factures");
                Calendar cal = Calendar.getInstance();
                cal.add(3, 3);
                final JDate jdate = new JDate(false);
                jdate.setDate(cal.getTime());
                final JCheckBox checkVisu = new JCheckBox();
                final JButton genBtn = new JButton(new AbstractAction("G\u00e9n\u00e9rer"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        final ContractBillingPeriodSQLElement paymentSQLElem = (ContractBillingPeriodSQLElement)conf.getDirectory().getElement(ContractBillingPeriodSQLElement.class);
                        SQLPreferences prefs = SQLPreferences.getMemCached((DBRoot)paymentSQLElem.getTable().getDBRoot());
                        boolean revPrix = prefs.getBoolean("GestionRevisionPrix", false);
                        String showInputDialog = null;
                        if (revPrix) {
                            showInputDialog = JOptionPane.showInputDialog(buttonPeriod, "Indice de r\u00e9vision actuel", null, 3);
                        }
                        final BigDecimal indiceN = showInputDialog == null || showInputDialog.trim().length() == 0 ? null : new BigDecimal(showInputDialog);
                        LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(jdate.getDateInMillis()), ZoneId.systemDefault());
                        final ProgressMonitor progressMonitor = new ProgressMonitor(buttonPeriod, "G\u00e9n\u00e9ration des factures jusqu'au " + DATE_FMT.format(dateTime), "", 0, 100);
                        progressMonitor.setMillisToPopup(500);
                        progressMonitor.setProgress(0);
                        final SwingWorker<List<SQLRowValues>, Void> worker = new SwingWorker<List<SQLRowValues>, Void>(){

                            @Override
                            protected List<SQLRowValues> doInBackground() throws Exception {
                                ContractSQLElement element = (ContractSQLElement)conf.getDirectory().getElement(ContractSQLElement.class);
                                SQLTable table = element.getTable();
                                SQLSelect sel = new SQLSelect();
                                sel.addSelectStar((TableRef)table);
                                sel.setWhere(new Where((FieldRef)table.getField("STOPPED"), "=", (Object)false));
                                List execute = SQLRowListRSH.execute((SQLSelect)sel);
                                element.createBillingPeriodElement(execute);
                                List<SQLRowValues> generateInvoices = paymentSQLElem.generateInvoices(new Where((FieldRef)paymentSQLElem.getTable().getField("DATE"), "<=", (Object)jdate.getDate()), new ContractBillingPeriodSQLElement.ProgressListener(){

                                    @Override
                                    public void progressChanged(String note, int current) {
                                        this.setProgress(current);
                                    }
                                }, indiceN, checkVisu.isSelected());
                                return generateInvoices;
                            }

                            @Override
                            protected void done() {
                                try {
                                    List list = (List)this.get();
                                    String invoiceName = paymentSQLElem.getPluralName();
                                    ContractBillingPanel.this.scheduleReload();
                                    JOptionPane.showMessageDialog(buttonPeriod, "Les " + invoiceName + " ont \u00e9t\u00e9 cr\u00e9\u00e9.");
                                    SaisieVenteFactureSQLElement elementFact = (SaisieVenteFactureSQLElement)conf.getDirectory().getElement(SaisieVenteFactureSQLElement.class);
                                    ListeAddPanel panelList = new ListeAddPanel((SQLElement)elementFact, new IListe((SQLTableModelSource)elementFact.createTableSource(Where.inValues((FieldRef)elementFact.getTable().getKey(), (Collection)SQLRow.getIDs((Collection)list)))));
                                    IListFrame frame = new IListFrame((IListPanel)panelList);
                                    FrameUtil.showPacked((Frame)frame);
                                }
                                catch (CancellationException exn) {
                                    JOptionPane.showMessageDialog(buttonPeriod, "La g\u00e9n\u00e9ration a \u00e9t\u00e9 annul\u00e9e.");
                                }
                                catch (Exception exn) {
                                    ExceptionHandler.handle((Component)buttonPeriod, (String)"Impossible de g\u00e9n\u00e9rer", (Throwable)exn);
                                }
                            }
                        };
                        worker.addPropertyChangeListener(new PropertyChangeListener(){

                            @Override
                            public void propertyChange(PropertyChangeEvent evt) {
                                if ("progress".equals(evt.getPropertyName())) {
                                    progressMonitor.setProgress(((Number)evt.getNewValue()).intValue());
                                    if (progressMonitor.isCanceled()) {
                                        worker.cancel(true);
                                    }
                                }
                            }
                        });
                        f.dispose();
                        worker.execute();
                    }
                });
                jdate.addValueListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        genBtn.setEnabled(evt.getNewValue() != null);
                    }
                });
                genBtn.setEnabled(jdate.getValue() != null);
                FormLayouter layouter = new FormLayouter(f.getContentPane(), 1, 1);
                layouter.add("Inclure les r\u00e8glements jusqu'au", (Component)jdate);
                layouter.add("Visualiser les factures", (Component)checkVisu);
                layouter.add(genBtn);
                f.pack();
                f.setLocationRelativeTo(null);
                f.setVisible(true);
            }
        });
        bottomBar.add(buttonFacture);
        c.weighty = 0.0;
        ++c.gridy;
        this.add((Component)new JSeparator(0), c);
        ++c.gridy;
        this.add((Component)bottomBar, c);
        this.spin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ContractBillingPanel.this.scheduleReload();
            }
        });
        this.checkManualMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ContractBillingPanel.this.panel instanceof DecoratedGridPanel) {
                    ((DecoratedGridPanel)ContractBillingPanel.this.panel).setEnableEditMode(ContractBillingPanel.this.checkManualMode.isSelected());
                }
            }
        });
        this.checkActiveOnlyMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContractBillingPanel.this.scheduleReload();
            }
        });
    }

    public void scheduleReload() {
        final boolean isModeManuel = this.checkManualMode.isSelected();
        final boolean showOnlyActive = this.checkActiveOnlyMode.isSelected();
        final int currentYear = ((Number)this.spin.getValue()).intValue();
        int yearCount = 5;
        SwingWorker<List<SQLRowValues>, List<SQLRowValues>> worker = new SwingWorker<List<SQLRowValues>, List<SQLRowValues>>(){

            @Override
            protected List<SQLRowValues> doInBackground() throws Exception {
                final SQLTable tablePeriodElement = ContractBillingPanel.this.conf.getDirectory().getElement("CONTRACT_BILLING_PERIOD").getTable();
                SQLTable tableEcheance = ((EcheanceClientSQLElement)ContractBillingPanel.this.conf.getDirectory().getElement(EcheanceClientSQLElement.class)).getTable();
                SQLRowValues rBilling = new SQLRowValues(tablePeriodElement);
                rBilling.putNulls((Collection)rBilling.getTable().getFieldsName());
                final SQLRowValues rContract = rBilling.putRowValues("ID_CONTRACT");
                rContract.putNulls((Collection)rContract.getTable().getFieldsName());
                SQLRowValues rClient = rContract.putRowValues("ID_CLIENT");
                rClient.putNulls((Collection)rClient.getTable().getFieldsName());
                SQLRowValues rFacture = rBilling.putRowValues("ID_SAISIE_VENTE_FACTURE");
                rFacture.putNulls((Collection)rFacture.getTable().getFieldsName());
                SQLRowValues rEchance = new SQLRowValues(tableEcheance);
                rEchance.putNulls(new String[]{"REGLE", "REG_COMPTA"});
                rEchance.put("ID_SAISIE_VENTE_FACTURE", (Object)rFacture);
                SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create((SQLRowValues)rContract);
                final Calendar from = Calendar.getInstance();
                from.set(1, currentYear - 2);
                from.set(6, 1);
                from.set(11, 0);
                from.set(12, 0);
                from.set(13, 0);
                from.set(14, 0);
                final Calendar to = (Calendar)from.clone();
                to.add(1, 7);
                fetcher.setSelTransf((ITransformer)new ITransformer<SQLSelect, SQLSelect>(){

                    public SQLSelect transformChecked(SQLSelect input) {
                        SQLSelectJoin joinFromField = input.getJoinFromField(tablePeriodElement.getField("ID_CONTRACT"));
                        Where w = new Where(joinFromField.getJoinedTable().getField("DATE"), ">=", (Object)from);
                        w = w.and(new Where(joinFromField.getJoinedTable().getField("DATE"), "<=", (Object)to));
                        joinFromField.setWhere(w);
                        if (showOnlyActive) {
                            Where wActive = new Where((FieldRef)rContract.getTable().getField("STOPPED"), "=", (Object)false);
                            input.setWhere(wActive);
                        }
                        return input;
                    }
                });
                List rows = fetcher.fetch();
                Collections.sort(rows, new Comparator<SQLRowValues>(){

                    @Override
                    public int compare(SQLRowValues o1, SQLRowValues o2) {
                        SQLRowAccessor c1 = o1.getForeign("ID_CLIENT");
                        SQLRowAccessor c2 = o1.getForeign("ID_CLIENT");
                        if (c1 == null && c2 == null) {
                            return 0;
                        }
                        if (c1 == null) {
                            return -1;
                        }
                        if (c2 == null) {
                            return 1;
                        }
                        return c1.getString("NOM").compareToIgnoreCase(c2.getString("NOM"));
                    }
                });
                return rows;
            }

            @Override
            protected void done() {
                try {
                    List allRowsContract = (List)this.get();
                    Collections.sort(allRowsContract, new Comparator<SQLRowValues>(){

                        @Override
                        public int compare(SQLRowValues o1, SQLRowValues o2) {
                            String client1 = o1.getForeign("ID_CLIENT").getString("NOM");
                            String client2 = o2.getForeign("ID_CLIENT").getString("NOM");
                            return client1.compareToIgnoreCase(client2);
                        }
                    });
                    ArrayList<SQLRowValues> visibleRowsContract = new ArrayList<SQLRowValues>();
                    YearsHeaderPanel b = new YearsHeaderPanel(currentYear, 5);
                    ArrayList<JPanel> panels = new ArrayList<JPanel>();
                    DecimalFormat format = new DecimalFormat("#0.##");
                    SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy");
                    for (SQLRowValues rContract : allRowsContract) {
                        String numero = rContract.getString("NUMBER");
                        String type = rContract.getString("TYPE");
                        String ref = rContract.getString("REFERENCE");
                        String client = rContract.getForeign("ID_CLIENT").getString("NOM");
                        BigDecimal amount = rContract.getBigDecimal("TOTAL_AMOUNT");
                        String m = format.format(amount);
                        int n = rContract.getInt("MONTHS_TO_BILL");
                        String text2 = String.valueOf(m) + "\u20ac HT tous les mois";
                        if (n > 1) {
                            text2 = String.valueOf(m) + "\u20ac HT tous les " + n + " mois";
                        }
                        String start = formatDate.format(rContract.getDate("START_DATE").getTime());
                        String stop = "";
                        if (rContract.getObject("ACTUAL_END_DATE") != null) {
                            stop = formatDate.format(rContract.getDate("ACTUAL_END_DATE").getTime());
                        }
                        JPanel p = new JPanel();
                        p.setBackground(Color.WHITE);
                        p.setOpaque(true);
                        p.setLayout(new GridLayout(3, 1));
                        JPanel pName = new JPanel();
                        pName.setOpaque(false);
                        pName.setLayout(new GridBagLayout());
                        GridBagConstraints cc = new GridBagConstraints();
                        cc.weightx = 1.0;
                        cc.fill = 1;
                        cc.gridx = 0;
                        cc.gridy = 0;
                        JLabelBold comp = new JLabelBold(" " + client + "   ");
                        comp.setBackground(Color.WHITE);
                        pName.add((Component)comp, cc);
                        if (!type.isEmpty()) {
                            JLabel typeLabel = new JLabel(" " + type + " ");
                            typeLabel.setOpaque(true);
                            if (!rContract.getBoolean("STOPPED").booleanValue()) {
                                typeLabel.setBackground(INVOICED_COLOR);
                            } else {
                                typeLabel.setBackground(Color.DARK_GRAY);
                            }
                            typeLabel.setForeground(Color.WHITE);
                            ++cc.gridx;
                            cc.weightx = 0.0;
                            pName.add((Component)typeLabel, cc);
                        }
                        p.add(pName);
                        p.add(new JLabel(" " + numero + " : " + text2));
                        String text = " Du " + start + " au " + stop;
                        if (stop.isEmpty()) {
                            text = " A partir du " + start;
                        }
                        JPanel pPeriod = new JPanel();
                        pPeriod.setOpaque(false);
                        pPeriod.setLayout(new GridBagLayout());
                        GridBagConstraints ccPeriod = new GridBagConstraints();
                        ccPeriod.weightx = 1.0;
                        ccPeriod.fill = 1;
                        ccPeriod.gridx = 0;
                        ccPeriod.gridy = 0;
                        JLabel labelPeriod = new JLabel(String.valueOf(text) + "   ");
                        labelPeriod.setBackground(Color.WHITE);
                        pPeriod.add((Component)labelPeriod, ccPeriod);
                        if (!ref.isEmpty()) {
                            JLabel typeLabel = new JLabel(" " + ref + " ");
                            typeLabel.setOpaque(true);
                            ++ccPeriod.gridx;
                            ccPeriod.weightx = 0.0;
                            pPeriod.add((Component)typeLabel, ccPeriod);
                        }
                        p.add(pPeriod);
                        String search = ContractBillingPanel.this.textSearch.getText().trim();
                        if (search.isEmpty()) {
                            panels.add(p);
                            visibleRowsContract.add(rContract);
                            continue;
                        }
                        String all = String.valueOf(client) + " " + type + " " + numero + " " + text2 + " " + start + " " + stop;
                        if (!(all = all.toLowerCase()).contains(search.toLowerCase())) continue;
                        panels.add(p);
                        visibleRowsContract.add(rContract);
                    }
                    if (panels.isEmpty()) {
                        JLabel label = new JLabel("Aucun contrat trouv\u00e9 sur cette p\u00e9riode", 0);
                        label.setOpaque(true);
                        label.setBackground(Color.WHITE);
                        ContractBillingPanel.this.setGridPanel(label);
                    } else {
                        DecoratedGridPanel contentPane = new DecoratedGridPanel((JComponent)b, 60, 50, panels);
                        int y = 0;
                        for (SQLRowValues rContract : visibleRowsContract) {
                            Calendar d1 = rContract.getDate("START_DATE");
                            Calendar d2 = rContract.getDate("PAYMENT_START");
                            long noOfDaysBetween = ChronoUnit.DAYS.between(d1.toInstant(), d2.toInstant());
                            for (SQLRowValues rBiling : rContract.getReferentRows()) {
                                Calendar r = rBiling.getDate("DATE");
                                int year = r.get(1);
                                int m = r.get(2);
                                int nbMonths = rBiling.getInt("DURATION_IN_MONTHS");
                                int x = (year - currentYear) * 12 + m;
                                int w = nbMonths;
                                GridItem gridItem = new GridItem(x, y, w, 1);
                                float markerLocation = 0.001f + (float)noOfDaysBetween / (28.0f * (float)nbMonths);
                                gridItem.setMarkerLocation(markerLocation);
                                gridItem.setCookie((Object)rBiling.asRow());
                                if (ContractBillingPeriodSQLElement.isInvoiced(rBiling)) {
                                    if (ContractBillingPeriodSQLElement.isPaid(rBiling)) {
                                        gridItem.setColor(PAID_COLOR);
                                        gridItem.setBorderColor(PAID_BORDER_COLOR);
                                    } else {
                                        gridItem.setColor(INVOICED_COLOR);
                                        gridItem.setBorderColor(INVOICED_BORDER_COLOR);
                                    }
                                } else if (ContractBillingPeriodSQLElement.isQuotedAccepted(rBiling) || rBiling.getForeign("ID_CONTRACT").getBoolean("AUTO_RENEW").booleanValue()) {
                                    gridItem.setColor(QUOTED_ACCEPTED_COLOR);
                                    gridItem.setBorderColor(QUOTED_ACCEPTED_BORDER_COLOR);
                                } else {
                                    gridItem.setColor(NOT_INVOICED_COLOR);
                                    gridItem.setBorderColor(NOT_INVOICED_BORDER_COLOR);
                                }
                                contentPane.add(gridItem);
                            }
                            ++y;
                        }
                        contentPane.setEnableEditMode(isModeManuel);
                        ContractBillingPanel.this.setGridPanel((JComponent)contentPane);
                        contentPane.setGridListener((GridListener)new BillingPeriodGridListener(ContractBillingPanel.this.conf.getDirectory(), ContractBillingPanel.this, currentYear, visibleRowsContract));
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    ExceptionHandler.handle((String)"Erreur lors de la cr\u00e9ation de la p\u00e9riode", (Throwable)e);
                }
            }
        };
        worker.execute();
    }

    protected void setGridPanel(JComponent contentPane) {
        this.invalidate();
        GridBagConstraints c = ((GridBagLayout)this.getLayout()).getConstraints(this.panel);
        int yScroll = 0;
        if (this.panel instanceof DecoratedGridPanel) {
            yScroll = ((DecoratedGridPanel)this.panel).getYScrollLocation();
        }
        this.remove(this.panel);
        this.panel = contentPane;
        if (this.panel instanceof DecoratedGridPanel) {
            final int y = yScroll;
            ((DecoratedGridPanel)this.panel).setYScrollLocation(y);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((DecoratedGridPanel)ContractBillingPanel.this.panel).setYScrollLocation(y);
                }
            });
        }
        this.add((Component)contentPane, c);
        this.revalidate();
        this.repaint();
    }
}

