/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.contract;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import org.openconcerto.erp.core.common.component.TransfertBaseSQLComponent;
import org.openconcerto.erp.core.sales.invoice.element.SaisieVenteFactureSQLElement;
import org.openconcerto.erp.core.sales.invoice.report.VenteFactureXmlSheet;
import org.openconcerto.erp.core.sales.quote.element.DevisSQLElement;
import org.openconcerto.modules.contract.ContractBillingPanel;
import org.openconcerto.modules.contract.ContractBillingPeriodSQLElement;
import org.openconcerto.modules.contract.ContractSQLElement;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.EditPanelListener;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.IListPanel;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.ui.grid.GridItem;
import org.openconcerto.ui.grid.GridListener;
import org.openconcerto.ui.grid.GridPanel;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.i18n.Grammar_fr;
import org.openconcerto.utils.i18n.Phrase;
import org.openconcerto.utils.i18n.VariantKey;

public class BillingPeriodGridListener
implements GridListener {
    private List<SQLRowValues> rowsContract;
    private int baseYear;
    private SQLElementDirectory directory;
    private final ContractBillingPanel panel;

    public BillingPeriodGridListener(SQLElementDirectory directory, ContractBillingPanel panel, int baseYear, List<SQLRowValues> rowsContract) {
        this.directory = directory;
        this.baseYear = baseYear;
        this.rowsContract = rowsContract;
        this.panel = panel;
    }

    public List<SQLRowValues> getRowsContract() {
        return this.rowsContract;
    }

    public void triggerPopup(final GridPanel grid, int x, int y) {
        SQLRow r;
        boolean quoted;
        JMenuItem menuItemShowInvoice;
        JMenuItem menuItem;
        final List selectedItems = grid.getSelectedItems();
        if (selectedItems.isEmpty()) {
            return;
        }
        JPopupMenu popup = new JPopupMenu();
        boolean oneIsNotInvoiced = false;
        for (GridItem item : selectedItems) {
            SQLRow rowBilling = (SQLRow)item.getCookie();
            if (ContractBillingPeriodSQLElement.isInvoiced(rowBilling.asRowValues())) continue;
            oneIsNotInvoiced = true;
        }
        if (oneIsNotInvoiced) {
            JMenuItem menuItem2 = new JMenuItem("Facturer en automatique");
            menuItem2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    final ContractBillingPeriodSQLElement paymentSQLElem = (ContractBillingPeriodSQLElement)BillingPeriodGridListener.this.getDirectory().getElement(ContractBillingPeriodSQLElement.class);
                    SQLPreferences prefs = SQLPreferences.getMemCached((DBRoot)paymentSQLElem.getTable().getDBRoot());
                    boolean revPrix = prefs.getBoolean("GestionRevisionPrix", false);
                    String showInputDialog = null;
                    if (revPrix) {
                        showInputDialog = JOptionPane.showInputDialog((Component)grid, "Indice de r\u00e9vision actuel", null, 3);
                    }
                    final BigDecimal indiceN = showInputDialog == null || showInputDialog.trim().length() == 0 ? null : new BigDecimal(showInputDialog);
                    final ProgressMonitor progressMonitor = new ProgressMonitor((Component)grid, "G\u00e9n\u00e9ration de facture", "", 0, 100);
                    progressMonitor.setMillisToPopup(500);
                    progressMonitor.setProgress(0);
                    final SwingWorker<List<SQLRowValues>, Void> worker = new SwingWorker<List<SQLRowValues>, Void>(){

                        @Override
                        protected List<SQLRowValues> doInBackground() throws Exception {
                            ArrayList<Number> ids = new ArrayList<Number>();
                            for (GridItem item : selectedItems) {
                                SQLRow row = (SQLRow)item.getCookie();
                                System.err.println("BillingPeriodGridListener.triggerPopup(...)" + row);
                                if (ContractBillingPeriodSQLElement.isInvoiced(row.asRowValues())) continue;
                                ids.add(row.getIDNumber());
                            }
                            if (ids.isEmpty()) {
                                return new ArrayList<SQLRowValues>();
                            }
                            return paymentSQLElem.generateInvoices(new ContractBillingPeriodSQLElement.ProgressListener(){

                                @Override
                                public void progressChanged(String note, int current) {
                                    this.setProgress(current);
                                }
                            }, null, ids, indiceN, false);
                        }

                        @Override
                        protected void done() {
                            try {
                                List rows = (List)this.get();
                                Phrase invoiceName = paymentSQLElem.getForeignElement("ID_SAISIE_VENTE_FACTURE").getName();
                                String end = rows.isEmpty() ? " n'a \u00e9t\u00e9 g\u00e9n\u00e9r\u00e9e." : (rows.size() == 1 ? " a \u00e9t\u00e9 g\u00e9n\u00e9r\u00e9e." : " ont \u00e9t\u00e9 g\u00e9n\u00e9r\u00e9es.");
                                if (!rows.isEmpty()) {
                                    BillingPeriodGridListener.this.panel.scheduleReload();
                                }
                                JOptionPane.showMessageDialog((Component)grid, String.valueOf(invoiceName.getNumeralVariant(rows.size(), (VariantKey)Grammar_fr.INDEFINITE_NUMERAL)) + end);
                            }
                            catch (CancellationException exn) {
                                JOptionPane.showMessageDialog((Component)grid, "La g\u00e9n\u00e9ration a \u00e9t\u00e9 annul\u00e9e.");
                            }
                            catch (Exception exn) {
                                ExceptionHandler.handle((Component)grid, (String)"Impossible de g\u00e9n\u00e9rer", (Throwable)exn);
                            }
                        }
                    };
                    worker.addPropertyChangeListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            if ("progress".equals(evt.getPropertyName())) {
                                progressMonitor.setProgress(((Number)evt.getNewValue()).intValue());
                                if (progressMonitor.isCanceled()) {
                                    worker.cancel(true);
                                }
                            }
                        }
                    });
                    worker.execute();
                }
            });
            popup.add(menuItem2);
        }
        boolean invoiced = ContractBillingPeriodSQLElement.isInvoiced(((SQLRow)((GridItem)selectedItems.get(0)).getCookie()).asRowValues());
        if (selectedItems.size() == 1 && !invoiced) {
            menuItem = new JMenuItem("Cr\u00e9er un devis");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SQLRow sqlRowBillPeriod = (SQLRow)((GridItem)selectedItems.get(0)).getCookie();
                    final SQLRowValues contractRowValues = sqlRowBillPeriod.getForeign("ID_CONTRACT").asRowValues();
                    SQLElement elt = Configuration.getInstance().getDirectory().getElement("DEVIS");
                    EditFrame editFrame = new EditFrame(elt);
                    SQLComponent sqlComponent = editFrame.getSQLComponent();
                    final SQLRowValues rowVals = new SQLRowValues(contractRowValues.getTable());
                    for (SQLField rk : rowVals.getTable().getDBSystemRoot().getGraph().getReferentKeys(rowVals.getTable())) {
                        Set referentRows = contractRowValues.getReferentRows(rk);
                        if (referentRows.size() <= 1) continue;
                        Iterator iter = new ArrayList(referentRows).iterator();
                        iter.next();
                        while (iter.hasNext()) {
                            SQLRowValues ref = (SQLRowValues)iter.next();
                            ref.remove(rk.getName());
                        }
                    }
                    for (SQLRowValues r : rowVals.getGraph().getItems()) {
                        HashSet fields = new HashSet(r.getTable().getFieldsName());
                        fields.removeAll(r.getFields());
                        r.putNulls(fields, false);
                    }
                    SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create((SQLRowValues)rowVals);
                    fetcher.setSelTransf((ITransformer)new ITransformer<SQLSelect, SQLSelect>(){

                        public SQLSelect transformChecked(SQLSelect input) {
                            input.setWhere(new Where((FieldRef)rowVals.getTable().getKey(), "=", contractRowValues.getID()));
                            return input;
                        }
                    });
                    List result = fetcher.fetch();
                    SQLInjector injector = SQLInjector.getInjector((SQLTable)contractRowValues.getTable(), (SQLTable)elt.getTable());
                    SQLRowValues rValues = injector.createRowValuesFrom(result);
                    sqlComponent.select((SQLRowAccessor)rValues);
                    FrameUtil.show((Window)editFrame);
                    editFrame.addEditPanelListener(new EditPanelListener(){

                        public void modified() {
                        }

                        public void inserted(int id) {
                            try {
                                contractRowValues.createEmptyUpdateRow().put("ID_DEVIS", id).update();
                            }
                            catch (SQLException e) {
                                ExceptionHandler.handle((String)"Erreur lors du rattachement du devis \u00e0 la p\u00e9riode de contrat", (Throwable)e);
                            }
                        }

                        public void deleted() {
                        }

                        public void cancelled() {
                        }
                    });
                }
            });
            popup.add(menuItem);
        }
        if (selectedItems.size() == 1 && !invoiced) {
            menuItem = new JMenuItem("Cr\u00e9er la facture");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    final SQLRowValues billPeriodRowValues = ((SQLRow)((GridItem)selectedItems.get(0)).getCookie()).asRowValues();
                    EditFrame openTransfertFrame = TransfertBaseSQLComponent.openTransfertFrame(Arrays.asList(billPeriodRowValues.getForeign("ID_CONTRACT").asRowValues()), (String)"SAISIE_VENTE_FACTURE");
                    openTransfertFrame.addEditPanelListener(new EditPanelListener(){

                        public void modified() {
                        }

                        public void inserted(int id) {
                            try {
                                billPeriodRowValues.createEmptyUpdateRow().put("ID_SAISIE_VENTE_FACTURE", id).update();
                            }
                            catch (SQLException e) {
                                ExceptionHandler.handle((String)"Erreur lors du rattachement de la facture \u00e0 la p\u00e9riode de contrat", (Throwable)e);
                            }
                            BillingPeriodGridListener.this.panel.scheduleReload();
                        }

                        public void deleted() {
                        }

                        public void cancelled() {
                        }
                    });
                }
            });
            popup.add(menuItem);
        }
        if (selectedItems.size() == 1 && invoiced) {
            JMenuItem menuItemShowInvoice2 = new JMenuItem("Afficher la facture");
            menuItemShowInvoice2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SQLRow rowBilling = (SQLRow)((GridItem)selectedItems.get(0)).getCookie();
                    SQLRow rInvoice = rowBilling.getForeignRow("ID_SAISIE_VENTE_FACTURE");
                    try {
                        SQLElement element = BillingPeriodGridListener.this.directory.getElement(rInvoice.getTable());
                        VenteFactureXmlSheet sheet = new VenteFactureXmlSheet(rInvoice);
                        sheet.showPrintAndExportAsynchronous(true, false, false, element, rInvoice);
                    }
                    catch (Exception e1) {
                        ExceptionHandler.handle((String)"Impossible d'afficher la facture", (Throwable)e1);
                    }
                }
            });
            popup.add(menuItemShowInvoice2);
        }
        if (selectedItems.size() == 1) {
            JMenuItem menuItemShowContract = new JMenuItem("Ouvrir le contrat");
            menuItemShowContract.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SQLRow rowBilling = (SQLRow)((GridItem)selectedItems.get(0)).getCookie();
                    SQLRow foreign = rowBilling.getForeign("ID_CONTRACT");
                    EditFrame frame = new EditFrame(BillingPeriodGridListener.this.getDirectory().getElement(ContractSQLElement.class), EditPanel.EditMode.MODIFICATION);
                    frame.selectionId(foreign.getID());
                    FrameUtil.showPacked((Frame)frame);
                }
            });
            popup.add(menuItemShowContract);
            menuItemShowInvoice = new JMenuItem("Ouvrir la liste des factures li\u00e9s au contrat");
            menuItemShowInvoice.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SQLRow rowBilling = (SQLRow)((GridItem)selectedItems.get(0)).getCookie();
                    SQLRow foreign = rowBilling.getForeign("ID_CONTRACT");
                    List referentRows = foreign.asRow().getReferentRows(rowBilling.getTable().getField("ID_CONTRACT"));
                    SaisieVenteFactureSQLElement factureSQLElem = (SaisieVenteFactureSQLElement)BillingPeriodGridListener.this.getDirectory().getElement(SaisieVenteFactureSQLElement.class);
                    ArrayList<Integer> ids = new ArrayList<Integer>();
                    for (SQLRow fact : referentRows) {
                        if (fact.getObject("ID_SAISIE_VENTE_FACTURE") != null && !fact.isForeignEmpty("ID_SAISIE_VENTE_FACTURE")) {
                            ids.add(fact.getForeignID("ID_SAISIE_VENTE_FACTURE"));
                        }
                        if (fact.getObject("ID_SAISIE_VENTE_FACTURE_COMPLEMENT") == null || fact.isForeignEmpty("ID_SAISIE_VENTE_FACTURE_COMPLEMENT")) continue;
                        ids.add(fact.getForeignID("ID_SAISIE_VENTE_FACTURE_COMPLEMENT"));
                    }
                    ListeAddPanel panelList = new ListeAddPanel((SQLElement)factureSQLElem, new IListe((SQLTableModelSource)factureSQLElem.createTableSource(Where.inValues((FieldRef)factureSQLElem.getTable().getKey(), ids))));
                    IListFrame listFrame = new IListFrame((IListPanel)panelList);
                    FrameUtil.show((Window)listFrame);
                }
            });
            popup.add(menuItemShowInvoice);
        }
        if (selectedItems.size() == 1 && invoiced) {
            JMenuItem unlinkInvoice = new JMenuItem("D\u00e9saffecter la facture");
            unlinkInvoice.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    final SQLRow rowBilling = (SQLRow)((GridItem)selectedItems.get(0)).getCookie();
                    SwingWorker<String, String> w = new SwingWorker<String, String>(){

                        @Override
                        protected String doInBackground() throws Exception {
                            SQLRowValues rowValues = rowBilling.asRowValues();
                            rowValues.put("ID_SAISIE_VENTE_FACTURE", null);
                            rowValues.commit();
                            return null;
                        }

                        @Override
                        protected void done() {
                            try {
                                this.get();
                            }
                            catch (Exception e) {
                                ExceptionHandler.handle((String)"impossible de d\u00e9saffecter la facture", (Throwable)e);
                            }
                            BillingPeriodGridListener.this.panel.scheduleReload();
                        }
                    };
                    w.execute();
                }
            });
            popup.add(unlinkInvoice);
            JMenuItem createNewPeriod = new JMenuItem("Reconduire la p\u00e9riode");
            createNewPeriod.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    final SQLRow rowBilling = (SQLRow)((GridItem)selectedItems.get(0)).getCookie();
                    SwingWorker<String, String> w = new SwingWorker<String, String>(){

                        @Override
                        protected String doInBackground() throws Exception {
                            SQLRowValues rowValsNewPeriod = new SQLRowValues(rowBilling.getTable());
                            rowValsNewPeriod.put("ID_CONTRACT", rowBilling.getForeignID("ID_CONTRACT"));
                            Calendar d = rowBilling.getDate("DATE");
                            int months = rowBilling.getInt("DURATION_IN_MONTHS");
                            d.add(2, months);
                            rowValsNewPeriod.put("DATE", (Object)d.getTime());
                            rowValsNewPeriod.put("DURATION_IN_MONTHS", months);
                            rowValsNewPeriod.put("ID_TAXE", rowBilling.getForeignID("ID_TAXE"));
                            rowValsNewPeriod.put("ID_TYPE_REGLEMENT", rowBilling.getForeignID("ID_TYPE_REGLEMENT"));
                            rowValsNewPeriod.commit();
                            return null;
                        }

                        @Override
                        protected void done() {
                            try {
                                this.get();
                            }
                            catch (Exception e) {
                                ExceptionHandler.handle((String)"impossible de cr\u00e9er la nouvelle p\u00e9riode", (Throwable)e);
                            }
                            BillingPeriodGridListener.this.panel.scheduleReload();
                        }
                    };
                    w.execute();
                }
            });
            popup.add(createNewPeriod);
        }
        if (selectedItems.size() == 1 && !invoiced) {
            JMenuItem menuItemChangeInvoice = new JMenuItem("Affecter \u00e0 une facture existante");
            menuItemChangeInvoice.addActionListener(this.createActionListenerLinkInvoice(selectedItems, "ID_SAISIE_VENTE_FACTURE"));
            popup.add(menuItemChangeInvoice);
        }
        boolean invoiced2 = ContractBillingPeriodSQLElement.isInvoiced2(((SQLRow)((GridItem)selectedItems.get(0)).getCookie()).asRowValues());
        if (selectedItems.size() == 1) {
            if (invoiced2) {
                menuItemShowInvoice = new JMenuItem("Afficher la facture compl\u00e9mentaire");
                menuItemShowInvoice.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SQLRow rowBilling = (SQLRow)((GridItem)selectedItems.get(0)).getCookie();
                        SQLRow rInvoice = rowBilling.getForeignRow("ID_SAISIE_VENTE_FACTURE_COMPLEMENT");
                        try {
                            SQLElement element = BillingPeriodGridListener.this.directory.getElement(rInvoice.getTable());
                            VenteFactureXmlSheet sheet = new VenteFactureXmlSheet(rInvoice);
                            sheet.showPrintAndExportAsynchronous(true, false, false, element, rInvoice);
                        }
                        catch (Exception e1) {
                            ExceptionHandler.handle((String)"Impossible d'afficher la facture", (Throwable)e1);
                        }
                    }
                });
                popup.add(menuItemShowInvoice);
                JMenuItem unlinkInvoice = new JMenuItem("D\u00e9saffecter la facture compl\u00e9mentaire");
                unlinkInvoice.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        final SQLRow rowBilling = (SQLRow)((GridItem)selectedItems.get(0)).getCookie();
                        SwingWorker<String, String> w = new SwingWorker<String, String>(){

                            @Override
                            protected String doInBackground() throws Exception {
                                SQLRowValues rowValues = rowBilling.asRowValues();
                                rowValues.put("ID_SAISIE_VENTE_FACTURE_COMPLEMENT", null);
                                rowValues.commit();
                                return null;
                            }

                            @Override
                            protected void done() {
                                try {
                                    this.get();
                                }
                                catch (Exception e) {
                                    ExceptionHandler.handle((String)"impossible de d\u00e9saffecter la facture", (Throwable)e);
                                }
                                BillingPeriodGridListener.this.panel.scheduleReload();
                            }
                        };
                        w.execute();
                    }
                });
                popup.add(unlinkInvoice);
            } else {
                JMenuItem menuItemChangeInvoice = new JMenuItem("Affecter une facture compl\u00e9mentaire");
                menuItemChangeInvoice.addActionListener(this.createActionListenerLinkInvoice(selectedItems, "ID_SAISIE_VENTE_FACTURE_COMPLEMENT"));
                popup.add(menuItemChangeInvoice);
            }
        }
        if (selectedItems.size() == 1 && !invoiced) {
            JMenuItem menuItem2 = new JMenuItem("Supprimer");
            menuItem2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                        @Override
                        protected Object doInBackground() throws Exception {
                            SQLRow rowBilling = (SQLRow)((GridItem)selectedItems.get(0)).getCookie();
                            ContractBillingPeriodSQLElement paymentSQLElem = (ContractBillingPeriodSQLElement)BillingPeriodGridListener.this.getDirectory().getElement(ContractBillingPeriodSQLElement.class);
                            paymentSQLElem.archive(rowBilling);
                            return null;
                        }

                        @Override
                        protected void done() {
                            try {
                                this.get();
                            }
                            catch (InterruptedException | ExecutionException e) {
                                ExceptionHandler.handle((String)"Impossible de supprimer", (Throwable)e);
                            }
                            BillingPeriodGridListener.this.panel.scheduleReload();
                        }
                    };
                    worker.execute();
                }
            });
            popup.add(menuItem2);
        }
        boolean bl = quoted = (r = (SQLRow)((GridItem)selectedItems.get(0)).getCookie()).getObject("ID_DEVIS") != null && !r.isForeignEmpty("ID_DEVIS");
        if (selectedItems.size() == 1 && !quoted) {
            JMenuItem menuItemChangeQuote = new JMenuItem("Affecter \u00e0 un devis existant");
            menuItemChangeQuote.addActionListener(new ActionListener(){
                int selID = -1;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ContractBillingPeriodSQLElement paymentSQLElem = (ContractBillingPeriodSQLElement)BillingPeriodGridListener.this.getDirectory().getElement(ContractBillingPeriodSQLElement.class);
                    SQLTable table = paymentSQLElem.getTable();
                    DevisSQLElement devisSQLElem = (DevisSQLElement)BillingPeriodGridListener.this.getDirectory().getElement(DevisSQLElement.class);
                    final SQLTable tableDevis = devisSQLElem.getTable();
                    SQLSelect select = new SQLSelect();
                    select.addSelect((FieldRef)table.getField("ID_DEVIS"));
                    select.setWhere(new Where((FieldRef)table.getField("ID_DEVIS"), ">", 1));
                    List l = table.getDBSystemRoot().getDataSource().executeCol(select.asString());
                    SQLRowValues rContrat = (SQLRowValues)BillingPeriodGridListener.this.rowsContract.get(((GridItem)selectedItems.get(0)).getY());
                    SQLRowValues rClient = rContrat.getForeign("ID_CLIENT").asRowValues();
                    System.err.println("BillingPeriodGridListener.triggerPopup(...).new ActionListener() {...}.actionPerformed() client : " + rClient);
                    SQLSelect select2 = new SQLSelect();
                    select2.addSelect((FieldRef)tableDevis.getKey());
                    select2.addSelect((FieldRef)tableDevis.getField("NUMERO"));
                    select2.addSelect((FieldRef)tableDevis.getField("DATE"));
                    select2.addSelect((FieldRef)tableDevis.getField("T_HT"));
                    Where where = Where.notInValues((FieldRef)tableDevis.getKey(), (Collection)l);
                    int idClient = rClient.getID();
                    where = where.and(new Where((FieldRef)tableDevis.getField("ID_CLIENT"), "=", idClient));
                    this.selID = -1;
                    ListeAddPanel panelList = new ListeAddPanel((SQLElement)devisSQLElem, new IListe((SQLTableModelSource)devisSQLElem.createTableSource(where)));
                    final IListFrame listFrame = new IListFrame((IListPanel)panelList);
                    listFrame.getPanel().getListe().getSelection().addPropertyChangeListener("userSelectedID", new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            int newID = ((Number)evt.getNewValue()).intValue();
                            selID = newID == -1 ? -1 : newID;
                        }
                    });
                    FrameUtil.show((Window)listFrame);
                    listFrame.setDefaultCloseOperation(0);
                    listFrame.addWindowListener((WindowListener)new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            SQLRow rowD;
                            int showConfirmDialog;
                            if (selID != -1 && (showConfirmDialog = JOptionPane.showConfirmDialog((Component)listFrame, "Voulez vous affecter le devis " + (rowD = tableDevis.getRow(selID)).getString("NUMERO") + " ?")) == 0) {
                                SQLRow rowBilling = (SQLRow)((GridItem)selectedItems.get(0)).getCookie();
                                final SQLRowValues rowValues = rowBilling.asRowValues();
                                rowValues.put("ID_DEVIS", selID);
                                SwingWorker<String, String> w = new SwingWorker<String, String>(){

                                    @Override
                                    protected String doInBackground() throws Exception {
                                        rowValues.commit();
                                        return null;
                                    }

                                    @Override
                                    protected void done() {
                                        try {
                                            this.get();
                                        }
                                        catch (Exception e) {
                                            ExceptionHandler.handle((String)"impossible d'affecter la facture", (Throwable)e);
                                        }
                                        BillingPeriodGridListener.this.panel.scheduleReload();
                                    }
                                };
                                w.execute();
                            }
                            listFrame.dispose();
                        }
                    });
                }
            });
            popup.add(menuItemChangeQuote);
        }
        popup.show((Component)grid, x, y);
    }

    public void selectionChanged(GridPanel grid) {
    }

    private SQLElementDirectory getDirectory() {
        return this.directory;
    }

    public boolean add(GridPanel gridPanel, GridItem newItem) {
        int result;
        int result2;
        int line = newItem.getY();
        SQLRowValues rContract = this.rowsContract.get(line);
        int nbMonthToBill = rContract.getInt("MONTHS_TO_BILL");
        if (nbMonthToBill != newItem.getW() && (result2 = JOptionPane.showConfirmDialog((Component)gridPanel, "La dur\u00e9e de facturation du contract est de " + nbMonthToBill + " mois.\nEn revanche la p\u00e9riode cr\u00e9\u00e9e est de " + newItem.getW() + " mois.\n", "Incoh\u00e9rence d\u00e9tect\u00e9e", 2)) != 0) {
            return false;
        }
        int year = this.baseYear;
        int m = newItem.getX();
        if (newItem.getX() >= 12) {
            ++year;
            m -= 12;
        }
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(5, 1);
        c.set(1, year);
        c.set(2, m);
        Calendar c2 = Calendar.getInstance();
        c2.setTimeInMillis(c.getTimeInMillis());
        c2.add(2, nbMonthToBill);
        Calendar dateStart = rContract.getDate("START_DATE");
        dateStart.clear(14);
        dateStart.clear(13);
        dateStart.clear(12);
        dateStart.clear(11);
        dateStart.set(5, 1);
        if (rContract.getObject("ACTUAL_END_DATE") != null) {
            int result3;
            Calendar dateEnd = rContract.getDate("ACTUAL_END_DATE");
            dateEnd.clear(14);
            dateEnd.clear(13);
            dateEnd.clear(12);
            dateEnd.clear(11);
            dateEnd.set(5, 1);
            if (c2.getTimeInMillis() > dateEnd.getTimeInMillis() && (result3 = JOptionPane.showConfirmDialog((Component)gridPanel, "La p\u00e9riode s\u00e9lectionn\u00e9e est apr\u00e8s la fin du contrat.\n", "Incoh\u00e9rence d\u00e9tect\u00e9e", 2)) != 0) {
                return false;
            }
        }
        if (c.getTimeInMillis() < dateStart.getTimeInMillis() && (result = JOptionPane.showConfirmDialog((Component)gridPanel, "La p\u00e9riode s\u00e9lectionn\u00e9e est avant le d\u00e9but du contrat.\n", "Incoh\u00e9rence d\u00e9tect\u00e9e", 2)) != 0) {
            return false;
        }
        try {
            SQLRowValues v = new SQLRowValues(this.rowsContract.get(0).getTable().getTable("CONTRACT_BILLING_PERIOD"));
            v.put("INVOICED_OUTSIDE", (Object)Boolean.FALSE);
            v.put("ID_TYPE_REGLEMENT", rContract.getInt("ID_TYPE_REGLEMENT"));
            v.put("ID_TAXE", rContract.getInt("ID_TAXE"));
            BigDecimal amount = rContract.getBigDecimal("TOTAL_AMOUNT").multiply(BigDecimal.valueOf(newItem.getW())).divide(BigDecimal.valueOf(rContract.getInt("MONTHS_TO_BILL")));
            v.put("AMOUNT", (Object)amount);
            v.put("DURATION_IN_MONTHS", newItem.getW());
            int day = rContract.getDate("PAYMENT_START").get(5);
            if (day > 28) {
                day = 28;
            }
            c.set(5, day);
            v.put("DATE", (Object)c.getTime());
            v.put("ID_CONTRACT", rContract.getID());
            v.put("ID_SAISIE_VENTE_FACTURE", null);
            SQLRow row = v.commit();
            newItem.setCookie((Object)row);
            newItem.setColor(ContractBillingPanel.NOT_INVOICED_COLOR);
            newItem.setBorderColor(ContractBillingPanel.NOT_INVOICED_BORDER_COLOR);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private ActionListener createActionListenerLinkInvoice(final List<GridItem> selectedItems, final String invoiceField) {
        boolean test = true;
        return new ActionListener(){
            int selID = -1;

            @Override
            public void actionPerformed(ActionEvent e) {
                ContractBillingPeriodSQLElement paymentSQLElem = (ContractBillingPeriodSQLElement)BillingPeriodGridListener.this.getDirectory().getElement(ContractBillingPeriodSQLElement.class);
                SQLTable table = paymentSQLElem.getTable();
                SaisieVenteFactureSQLElement factureSQLElem = (SaisieVenteFactureSQLElement)BillingPeriodGridListener.this.getDirectory().getElement(SaisieVenteFactureSQLElement.class);
                final SQLTable tableFacture = factureSQLElem.getTable();
                SQLSelect select = new SQLSelect();
                select.addSelect((FieldRef)table.getField(invoiceField));
                select.setWhere(new Where((FieldRef)table.getField(invoiceField), ">", 1));
                List l = table.getDBSystemRoot().getDataSource().executeCol(select.asString());
                SQLRowValues rContrat = (SQLRowValues)BillingPeriodGridListener.this.rowsContract.get(((GridItem)selectedItems.get(0)).getY());
                SQLRowValues rClient = rContrat.getForeign("ID_CLIENT").asRowValues();
                System.err.println("BillingPeriodGridListener.triggerPopup(...).new ActionListener() {...}.actionPerformed() client : " + rClient);
                SQLSelect select2 = new SQLSelect();
                select2.addSelect((FieldRef)tableFacture.getField("ID"));
                select2.addSelect((FieldRef)tableFacture.getField("NUMERO"));
                select2.addSelect((FieldRef)tableFacture.getField("DATE"));
                select2.addSelect((FieldRef)tableFacture.getField("T_HT"));
                Where where = new Where((FieldRef)tableFacture.getField("ID"), false, (Collection)l);
                int idClient = rClient.getID();
                where = where.and(new Where((FieldRef)tableFacture.getField("ID_CLIENT"), "=", idClient));
                this.selID = -1;
                ListeAddPanel panelList = new ListeAddPanel((SQLElement)factureSQLElem, new IListe((SQLTableModelSource)factureSQLElem.createTableSource(where)));
                final IListFrame listFrame = new IListFrame((IListPanel)panelList);
                listFrame.getPanel().getListe().getSelection().addPropertyChangeListener("userSelectedID", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        int newID = ((Number)evt.getNewValue()).intValue();
                        selID = newID == -1 ? -1 : newID;
                    }
                });
                FrameUtil.show((Window)listFrame);
                listFrame.setDefaultCloseOperation(0);
                listFrame.addWindowListener((WindowListener)new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        SQLRow rowF;
                        int showConfirmDialog;
                        if (selID != -1 && (showConfirmDialog = JOptionPane.showConfirmDialog((Component)listFrame, "Voulez vous affecter le facture " + (rowF = tableFacture.getRow(selID)).getString("NUMERO") + " ?")) == 0) {
                            SQLRow rowBilling = (SQLRow)((GridItem)selectedItems.get(0)).getCookie();
                            final SQLRowValues rowValues = rowBilling.asRowValues();
                            rowValues.put(invoiceField, selID);
                            if (invoiceField.equals("ID_SAISIE_VENTE_FACTURE")) {
                                rowValues.put("INVOICED_OUTSIDE", (Object)false);
                            }
                            SwingWorker<String, String> w = new SwingWorker<String, String>(){

                                @Override
                                protected String doInBackground() throws Exception {
                                    rowValues.commit();
                                    return null;
                                }

                                @Override
                                protected void done() {
                                    try {
                                        this.get();
                                    }
                                    catch (Exception e) {
                                        ExceptionHandler.handle((String)"impossible d'affecter la facture", (Throwable)e);
                                    }
                                    BillingPeriodGridListener.this.panel.scheduleReload();
                                }
                            };
                            w.execute();
                        }
                        listFrame.dispose();
                    }
                });
            }
        };
    }
}

