/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.filter.Filter;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.xml.Step;

public final class SimpleXMLPath<T> {
    private static final SimpleXMLPath<Attribute> ALL_ATTRIBUTES = SimpleXMLPath.allAttributes(null, null);
    private static final SimpleXMLPath<Element> ALL_ELEMENTS = SimpleXMLPath.allElements(null, null);
    private final List<Step<?>> items;
    private final Step<T> lastItem;

    public static <T> SimpleXMLPath<T> create(List<Step<?>> steps, Step<T> lastStep) {
        return new SimpleXMLPath<T>(Collections.unmodifiableList(new ArrayList(steps)), lastStep);
    }

    public static <T> SimpleXMLPath<T> create(Step<T> lastStep) {
        return new SimpleXMLPath<T>(Collections.emptyList(), lastStep);
    }

    public static <T> SimpleXMLPath<T> create(Step<?> first, Step<T> lastStep) {
        return new SimpleXMLPath<T>(Collections.singletonList(first), lastStep);
    }

    public static <T> SimpleXMLPath<T> create(Step<?> first, Step<?> second, Step<T> lastStep) {
        return new SimpleXMLPath<T>(Arrays.asList(first, second), lastStep);
    }

    public static SimpleXMLPath<Attribute> allAttributes() {
        return ALL_ATTRIBUTES;
    }

    public static SimpleXMLPath<Attribute> allAttributes(String name, String ns) {
        return SimpleXMLPath.create(Step.createElementStep(Step.Axis.descendantOrSelf, null), Step.createAttributeStep(name, ns));
    }

    public static SimpleXMLPath<Element> allElements() {
        return ALL_ELEMENTS;
    }

    public static SimpleXMLPath<Element> allElements(String name, String ns) {
        return SimpleXMLPath.create(Step.createElementStep(Step.Axis.descendantOrSelf, name, ns));
    }

    private SimpleXMLPath(List<Step<?>> steps, Step<T> lastStep) {
        this.lastItem = lastStep;
        this.items = steps;
    }

    public final T selectSingleNode(Object n) {
        return this.selectSingleNode(n, this.items);
    }

    private final T selectSingleNode(Object currentNode, List<Step<?>> steps) {
        int size = steps.size();
        if (size > 0) {
            Step<?> currentStep = steps.get(0);
            List<?> nextNodes = currentStep.nextNodes(Node.get(currentNode), currentNode);
            List<Step<?>> nextSteps = steps.subList(1, size);
            int stop = nextNodes.size();
            int i = 0;
            while (i < stop) {
                T finalNode = this.selectSingleNode(nextNodes.get(i), nextSteps);
                if (finalNode != null) {
                    return finalNode;
                }
                ++i;
            }
            return null;
        }
        return CollectionUtils.getFirst(this.lastItem.nextNodes(Node.get(currentNode), currentNode));
    }

    public final List<T> selectNodes(Object n) {
        return this.selectNodes(Collections.singletonList(n));
    }

    public final List<T> selectNodes(List<?> nodes) {
        List<?> currentNodes = nodes;
        int stop = this.items.size();
        int i = 0;
        while (i < stop) {
            Step<?> currentStep = this.items.get(i);
            List<?> nextNodes = currentStep.nextNodes(currentNodes);
            if (nextNodes.isEmpty()) {
                return Collections.emptyList();
            }
            currentNodes = nextNodes;
            ++i;
        }
        return this.lastItem.nextNodes(currentNodes);
    }

    public final List<String> selectValues(Object n) {
        return this.selectValues(Collections.singletonList(n));
    }

    public final List<String> selectValues(List<?> nodes) {
        List<T> lastNodes = this.selectNodes(nodes);
        return this.lastItem.getValues(lastNodes);
    }

    static class AttributeNode
    extends Node<Attribute> {
        AttributeNode() {
        }

        @Override
        public <S> void nextNodes(List<S> res, Attribute node, Step<S> step) {
            if (step.getAxis() != Step.Axis.ancestor) {
                throw new IllegalArgumentException(this + " cannot take the passed step: " + step);
            }
            step.add(node.getParent(), res);
        }

        @Override
        Attribute filter(Attribute elem, String name, String ns) {
            if (elem == null) {
                return null;
            }
            if (name != null && !name.equals(elem.getName())) {
                return null;
            }
            if (ns != null && !ns.equals(elem.getNamespacePrefix())) {
                return null;
            }
            return elem;
        }

        @Override
        protected String getValue(Attribute n) {
            return n.getValue();
        }
    }

    static class ElementNode
    extends Node<Element> {
        ElementNode() {
        }

        @Override
        public <S> void nextNodes(List<S> res, Element node, final Step<S> step) {
            Step.Axis axis = step.getAxis();
            if (axis == Step.Axis.ancestor) {
                step.add(node.getParent(), res);
            } else if (axis == Step.Axis.attribute) {
                List attributes = node.getAttributes();
                int stop = attributes.size();
                int i = 0;
                while (i < stop) {
                    step.add(attributes.get(i), res);
                    ++i;
                }
            } else if (axis == Step.Axis.child) {
                for (Object o : node.getChildren()) {
                    step.add(o, res);
                }
            } else if (axis == Step.Axis.descendantOrSelf) {
                step.add(node, res);
                Iterator iter = node.getDescendants(new Filter(){

                    @Override
                    public boolean matches(Object obj) {
                        if (!(obj instanceof Element)) {
                            return false;
                        }
                        return step.evaluate(obj) != null;
                    }
                });
                while (iter.hasNext()) {
                    res.add(iter.next());
                }
            } else {
                throw new IllegalArgumentException(this + " cannot take the passed step: " + (Object)((Object)axis));
            }
        }

        @Override
        Element filter(Element elem, String name, String ns) {
            if (elem == null) {
                return null;
            }
            if (name != null && !name.equals(elem.getName())) {
                return null;
            }
            if (ns != null && !ns.equals(elem.getNamespacePrefix())) {
                return null;
            }
            return elem;
        }

        @Override
        protected String getValue(Element n) {
            return n.getValue();
        }
    }

    static abstract class Node<T> {
        static final Node<Element> elem = new ElementNode();
        static final Node<Attribute> attr = new AttributeNode();

        Node() {
        }

        public static <TT> Node<TT> get(TT o) {
            if (o instanceof Attribute) {
                return attr;
            }
            if (o instanceof Element) {
                return elem;
            }
            throw new IllegalArgumentException("unknown Node: " + o);
        }

        public static <TT> Node<TT> get(Class<TT> clazz) {
            if (clazz == Attribute.class) {
                return attr;
            }
            if (clazz == Element.class) {
                return elem;
            }
            throw new IllegalArgumentException("unknown Node: " + clazz);
        }

        public abstract <S> void nextNodes(List<S> var1, T var2, Step<S> var3);

        abstract T filter(T var1, String var2, String var3);

        protected abstract String getValue(T var1);

        public final String toString() {
            return this.getClass().getSimpleName();
        }
    }
}

