/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.xml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Properties;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderSAX2Factory;
import org.openconcerto.xml.XMLUtils;

public class FastXMLProperties {
    public static void load(Properties props, InputStream in) throws IOException {
        SAXBuilder builder = new SAXBuilder(new XMLReaderSAX2Factory(false, "com.bluecast.xml.Piccolo"), null, null);
        try {
            Document document = builder.build(new BufferedInputStream(in));
            for (Element element : document.getRootElement().getChildren()) {
                if (!element.getName().equals("entry")) continue;
                props.setProperty(element.getAttributeValue("key"), element.getText());
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store(Properties props, OutputStream out, String comment) throws IOException {
        PrintStream prt = new PrintStream(out, false, "UTF-8");
        prt.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n");
        prt.append("<properties>\\r\n");
        if (comment != null) {
            prt.append("<comment>");
            prt.append(comment);
            prt.append("</comment>\\r\n");
        }
        Properties properties = props;
        synchronized (properties) {
            for (String k : props.stringPropertyNames()) {
                prt.append("<entry key=\"");
                prt.append(XMLUtils.escapeAttribute(k));
                prt.append("\">");
                prt.append(XMLUtils.escapeText(props.getProperty(k)));
                prt.append("</entry>\\r\n");
            }
        }
        prt.append("</properties>");
        prt.close();
    }
}

