/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.xml;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.cache.CacheResult;
import org.openconcerto.utils.cache.ICache;
import org.openconcerto.utils.cc.ExnTransformer;
import org.openconcerto.xml.XMLCodecUtils;

public abstract class AbstractXMLDecoder<S, E extends Exception> {
    private static final ICache<Object, Method, Object> cache = new ICache(60, -1, "methods for " + XMLCodecUtils.class);
    private static final ICache<Object, Constructor<?>, Object> cacheCtor = new ICache(60, -1, "constructors for " + XMLCodecUtils.class);
    private static final Map<String, Class> primitiveNames = new HashMap<String, Class>();

    static {
        primitiveNames.put("boolean", Boolean.TYPE);
        primitiveNames.put("byte", Byte.TYPE);
        primitiveNames.put("char", Character.TYPE);
        primitiveNames.put("short", Short.TYPE);
        primitiveNames.put("int", Integer.TYPE);
        primitiveNames.put("long", Long.TYPE);
        primitiveNames.put("float", Float.TYPE);
        primitiveNames.put("double", Double.TYPE);
    }

    protected abstract String getLocalName(S var1);

    protected abstract String getAttributeValue(S var1, String var2);

    protected abstract String getElementText(S var1) throws E;

    protected abstract S getFirstChild(S var1);

    protected abstract String toString(S var1);

    protected abstract Children<S> createChildren(S var1) throws E;

    public final <K, V> Map<K, V> decodeFromArray(S elem, Class<K> keyClass, Class<V> valueClass) {
        return XMLCodecUtils.decodeFromArray((Object[])this.decode1(elem), keyClass, valueClass);
    }

    public final Object decode1(S javaElem) {
        S elem = this.getFirstChild(javaElem);
        try {
            return this.eval(elem, new Stack<Object>(), new HashMap<String, Object>());
        }
        catch (Exception e) {
            throw new IllegalStateException("error decoding " + this.toString(javaElem), e);
        }
    }

    private final Object eval(S elem, Stack<Object> context, Map<String, Object> ids) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, E {
        this.preEval(elem);
        Object res = this._eval(elem, context, ids);
        this.postEval(elem, res);
        return res;
    }

    protected void preEval(S elem) throws E {
    }

    protected void nullDecoded(S elem) throws E {
    }

    protected void idRefDecoded(S elem) throws E {
    }

    protected void postEval(S elem, Object res) throws E {
    }

    /*
     * WARNING - void declaration
     */
    private final Object _eval(S elem, Stack<Object> context, Map<String, Object> ids) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, E {
        String n;
        switch (n = this.getLocalName(elem)) {
            case "string": {
                return this.getElementText(elem);
            }
            case "object": 
            case "void": {
                String idref = this.getAttributeValue(elem, "idref");
                if (idref != null) {
                    if (!ids.containsKey(idref)) {
                        throw new IllegalStateException("id '" + idref + "' wasn't defined");
                    }
                    this.idRefDecoded(elem);
                    return ids.get(idref);
                }
                String id = this.getAttributeValue(elem, "id");
                String targetClass = this.getAttributeValue(elem, "class");
                final Class<?> target = targetClass == null ? context.peek() : Class.forName(targetClass);
                final String propAttr = this.getAttributeValue(elem, "property");
                final String indexAttr = this.getAttributeValue(elem, "index");
                final String methodAttr = this.getAttributeValue(elem, "method");
                final String fieldAttr = this.getAttributeValue(elem, "field");
                Object res = this.evalContainer(elem, context, ids, (ExnTransformer<List<Object>, Object, Exception>)new ExnTransformer<List<Object>, Object, Exception>(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public Object transformChecked(List<Object> args) throws Exception {
                        if (propAttr != null) {
                            String methodName = String.valueOf(args.size() == 0 ? "get" : "set") + StringUtils.firstUp(propAttr);
                            return AbstractXMLDecoder.invoke(target, methodName, args);
                        }
                        if (indexAttr != null) {
                            if (target instanceof List) {
                                String methodName = args.size() == 0 ? "get" : "set";
                                args.add(0, Integer.valueOf(indexAttr));
                                return AbstractXMLDecoder.invoke(target, methodName, args);
                            }
                            if (!target.getClass().isArray()) throw new IllegalStateException("use index with neither List nor array: " + target);
                            Class<?> componentType = target.getClass().getComponentType();
                            String methodName = String.valueOf(args.size() == 0 ? "get" : "set") + (componentType.isPrimitive() ? StringUtils.firstUp(componentType.getSimpleName()) : "");
                            args.add(0, target);
                            args.add(1, Integer.valueOf(indexAttr));
                            return AbstractXMLDecoder.invoke(Array.class, methodName, args);
                        }
                        if (methodAttr != null) {
                            return AbstractXMLDecoder.invoke(target, methodAttr, args);
                        }
                        if (fieldAttr == null) return AbstractXMLDecoder.getCtor((Class)target, args).newInstance(args.toArray());
                        return ((Class)target).getField(fieldAttr).get(null);
                    }
                });
                if (id != null) {
                    ids.put(id, res);
                }
                return res;
            }
            case "int": {
                return Integer.valueOf(this.getElementText(elem));
            }
            case "null": {
                this.nullDecoded(elem);
                return null;
            }
            case "boolean": {
                return Boolean.valueOf(this.getElementText(elem));
            }
            case "byte": {
                return Byte.valueOf(this.getElementText(elem));
            }
            case "char": {
                return Character.valueOf(this.getElementText(elem).charAt(0));
            }
            case "short": {
                return Short.valueOf(this.getElementText(elem));
            }
            case "long": {
                return Long.valueOf(this.getElementText(elem));
            }
            case "float": {
                return Float.valueOf(this.getElementText(elem));
            }
            case "double": {
                return Double.valueOf(this.getElementText(elem));
            }
            case "array": {
                S child;
                String classAttr = this.getAttributeValue(elem, "class");
                String lengthAttr = this.getAttributeValue(elem, "length");
                Class<?> componentClass = AbstractXMLDecoder.parseClassName(classAttr);
                if (lengthAttr != null) {
                    S child2;
                    context.push(Array.newInstance(componentClass, Integer.parseInt(lengthAttr)));
                    Children<S> children = this.createChildren(elem);
                    while ((child2 = children.getNextChild()) != null) {
                        void child3;
                        this.eval(child3, context, ids);
                    }
                    return context.pop();
                }
                LinkedList<Object> items = new LinkedList<Object>();
                Children<S> children = this.createChildren(elem);
                while ((child = children.getNextChild()) != null) {
                    items.add(this.eval(child, context, ids));
                }
                Object resArray = Array.newInstance(componentClass, items.size());
                int i = 0;
                for (Object e : items) {
                    Array.set(resArray, i++, e);
                }
                return resArray;
            }
            case "class": {
                return Class.forName(this.getElementText(elem));
            }
        }
        throw new UnsupportedOperationException("doesn't yet support " + n);
    }

    /*
     * Unable to fully structure code
     */
    private final Object evalContainer(S parent, Stack<Object> context, Map<String, Object> ids, ExnTransformer<List<Object>, Object, ? extends Exception> transf) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, E {
        args = new ArrayList<Object>();
        children = this.createChildren(parent);
        noVoid = true;
        child = null;
        if (true) ** GOTO lbl12
        do {
            if (this.getLocalName(child).equals("void")) {
                noVoid = false;
            } else {
                args.add(this.eval(child, context, ids));
            }
lbl12:
            // 3 sources

            if (!noVoid) break;
            v0 = children.getNextChild();
            child = v0;
        } while (v0 != null);
        res = transf.transformCheckedWithExn(args, false, InvocationTargetException.class, InstantiationException.class, IllegalAccessException.class);
        context.push(res);
        if (child != null) {
            do {
                this.eval(child, context, ids);
                v1 = children.getNextChild();
                child = v1;
            } while (v1 != null);
        }
        return context.pop();
    }

    private static final Object invoke(Object target, String methodName, List<Object> args) throws IllegalAccessException, InvocationTargetException {
        Class<?> clazz = target instanceof Class ? (Class<?>)target : target.getClass();
        Method m = AbstractXMLDecoder.getMethod(clazz, methodName, args);
        return m.invoke(target, args.toArray());
    }

    private static final Method getMethod(Class<?> clazz, String name, List<Object> actualArgs) {
        List<Class<?>> actualClasses = AbstractXMLDecoder.objectsToClasses(actualArgs);
        ArrayList<Object> key = new ArrayList<Object>(3);
        key.add(clazz);
        key.add(name);
        key.add(actualClasses);
        CacheResult<Method> cacheRes = cache.check(key);
        if (cacheRes.getState() == CacheResult.State.VALID) {
            return cacheRes.getRes();
        }
        Method res = AbstractXMLDecoder.findMethod(clazz, name, actualClasses);
        if (res == null) {
            throw new IllegalStateException("No matching method " + name + " found in " + clazz);
        }
        cache.put(key, res);
        return res;
    }

    private static final Constructor getCtor(Class<?> clazz, List<Object> actualArgs) {
        List<Class<?>> actualClasses = AbstractXMLDecoder.objectsToClasses(actualArgs);
        ArrayList<Object> key = new ArrayList<Object>(3);
        key.add(clazz);
        key.add(actualClasses);
        CacheResult<Constructor<?>> cacheRes = cacheCtor.check(key);
        if (cacheRes.getState() == CacheResult.State.VALID) {
            return cacheRes.getRes();
        }
        Constructor res = AbstractXMLDecoder.findCtor(clazz, actualClasses);
        if (res == null) {
            throw new IllegalStateException("No constructor in " + clazz + " for arguments " + actualClasses);
        }
        cacheCtor.put(key, res);
        return res;
    }

    private static final List<Class<?>> objectsToClasses(List<Object> actualArgs) {
        ArrayList actualClasses = new ArrayList(actualArgs.size());
        for (Object actualArg : actualArgs) {
            actualClasses.add(actualArg == null ? null : actualArg.getClass());
        }
        return actualClasses;
    }

    private static final Method findMethod(Class<?> clazz, String name, List<Class<?>> actualArgs) {
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().equals(name) && AbstractXMLDecoder.callableWith(m.getParameterTypes(), actualArgs)) {
                return m;
            }
            ++n2;
        }
        return null;
    }

    private static final Constructor findCtor(Class<?> clazz, List<Class<?>> actualArgs) {
        Constructor<?>[] constructorArray = clazz.getConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> m = constructorArray[n2];
            if (AbstractXMLDecoder.callableWith(m.getParameterTypes(), actualArgs)) {
                return m;
            }
            ++n2;
        }
        return null;
    }

    private static final boolean callableWith(Class<?>[] formalArgs, List<Class<?>> actualArgs) {
        if (formalArgs.length != actualArgs.size()) {
            return false;
        }
        int i = 0;
        Class<?>[] classArray = formalArgs;
        int n = formalArgs.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> argClass = classArray[n2];
            Class<?> actualArg = actualArgs.get(i);
            if (actualArg != null && !argClass.isAssignableFrom(actualArg) && argClass != AbstractXMLDecoder.getPrimitive(actualArg)) {
                return false;
            }
            ++i;
            ++n2;
        }
        return true;
    }

    private static Class<?> getPrimitive(Class<?> argClass) {
        if (argClass == Boolean.class) {
            return Boolean.TYPE;
        }
        if (argClass == Character.class) {
            return Character.TYPE;
        }
        if (argClass == Byte.class) {
            return Byte.TYPE;
        }
        if (argClass == Short.class) {
            return Short.TYPE;
        }
        if (argClass == Integer.class) {
            return Integer.TYPE;
        }
        if (argClass == Long.class) {
            return Long.TYPE;
        }
        if (argClass == Float.class) {
            return Float.TYPE;
        }
        if (argClass == Double.class) {
            return Double.TYPE;
        }
        return null;
    }

    private static Class<?> parseClassName(String className) throws ClassNotFoundException {
        Class primitive = primitiveNames.get(className);
        if (primitive != null) {
            return primitive;
        }
        return Class.forName(className);
    }

    protected static interface Children<C> {
        public C getNextChild();
    }
}

