/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.text;

import java.util.List;
import net.jcip.annotations.Immutable;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.i18n.I18nUtils;
import org.openconcerto.utils.text.DateTimeSkeleton;

@Immutable
public final class TypesFormats {
    private final boolean yesNoBoolean;
    private final List<DateTimeSkeleton> dateSkeletons;
    private final List<DateTimeSkeleton> timeSkeletons;
    private final List<DateTimeSkeleton> datetimeSkeletons;

    public TypesFormats(boolean yesNoBoolean, List<DateTimeSkeleton> dateSkeletons, List<DateTimeSkeleton> timeSkeletons, List<DateTimeSkeleton> datetimeSkeletons) {
        this.yesNoBoolean = yesNoBoolean;
        this.dateSkeletons = CollectionUtils.toImmutableList(dateSkeletons);
        this.timeSkeletons = CollectionUtils.toImmutableList(timeSkeletons);
        this.datetimeSkeletons = CollectionUtils.toImmutableList(datetimeSkeletons);
    }

    public final String getBooleanKey(boolean b) {
        return this.yesNoBoolean ? I18nUtils.getYesNoKey(b) : I18nUtils.getBooleanKey(b);
    }

    public final List<DateTimeSkeleton> getDateSkeletons() {
        return this.dateSkeletons;
    }

    public final List<DateTimeSkeleton> getTimeSkeletons() {
        return this.timeSkeletons;
    }

    public final List<DateTimeSkeleton> getDatetimeSkeletons() {
        return this.datetimeSkeletons;
    }
}

