/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.sync;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Objects;
import org.openconcerto.utils.MessageDigestUtils;
import org.openconcerto.utils.sync.RollingChecksum32;

public class HashWriter {
    public static final int BLOCK_SIZE = 1024;
    private File in;
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public HashWriter(File inputFile) {
        this.in = inputFile;
    }

    public void saveHash(File outputFile) {
        block14: {
            BufferedInputStream fb = null;
            try {
                try {
                    if (!outputFile.exists()) {
                        new File(outputFile.getParent()).mkdirs();
                    }
                    DataOutputStream bOut = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
                    bOut.writeInt((int)this.in.length());
                    MessageDigest hashSum = MessageDigestUtils.getSHA256();
                    MessageDigest md5 = MessageDigestUtils.getMD5();
                    fb = new BufferedInputStream(new FileInputStream(this.in));
                    RollingChecksum32 r32 = new RollingChecksum32();
                    byte[] buffer = new byte[1024];
                    int readSize = fb.read(buffer);
                    while (readSize > 0) {
                        r32.check(buffer, 0, readSize);
                        md5.reset();
                        md5.update(buffer, 0, readSize);
                        hashSum.update(buffer, 0, readSize);
                        readSize = fb.read(buffer);
                        byte[] engineDigest = md5.digest();
                        bOut.writeInt(r32.getValue());
                        bOut.write(engineDigest);
                    }
                    byte[] fileHash = new byte[hashSum.getDigestLength()];
                    fileHash = hashSum.digest();
                    bOut.write(fileHash);
                    bOut.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (fb == null) break block14;
                    try {
                        fb.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (fb != null) {
                    try {
                        fb.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static byte[] getHash(File f) throws IOException {
        MessageDigest hashSum = MessageDigestUtils.getSHA256();
        return MessageDigestUtils.getHash(hashSum, f);
    }

    public static boolean compareHash(byte[] h1, byte[] h2) {
        Objects.requireNonNull(h1);
        Objects.requireNonNull(h2);
        return Arrays.equals(h1, h2);
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        int j = 0;
        while (j < bytes.length) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
            ++j;
        }
        return new String(hexChars);
    }
}

