/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.prog;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.OSFamily;
import org.openconcerto.utils.ProcessStreams;
import org.openconcerto.utils.PropertiesUtils;
import org.openconcerto.utils.prog.RemoteDebugArgs;

public abstract class VMLauncher {
    private static final String PROPERTIES_EXT = ".properties";
    public static final String NO_RESTART = "vm.noRestart";
    public static final String APPDIR_SYSPROP = "jpackage.app.dir";
    public static final String APP_EXE_SYSPROP = "jpackage.app-path";
    private static final NativeLauncherFinder UnknownLauncherFinder = new NativeLauncherFinder(){

        @Override
        public String getAppPath() {
            return null;
        }
    };
    public static final String ENV_VMARGS = "JAVA_VMARGS";
    public static final String PROPS_VMARGS = "VMARGS";
    public static final String ENV_PROGARGS = "JAVA_PROGARGS";
    private static final Pattern NL = Pattern.compile("\\p{Cntrl}+");
    private File wd = null;

    public static final File getJPackageAppDir() {
        String appPath = System.getProperty(APPDIR_SYSPROP, "");
        return appPath.isEmpty() ? null : new File(appPath);
    }

    private static final String getJPackageAppPath() {
        String appPath = System.getProperty(APP_EXE_SYSPROP, "");
        return appPath.isEmpty() ? null : appPath;
    }

    private static final void addJPackageSystemPropertyArgument(List<String> args, String propName) {
        String arg = VMLauncher.getJPackageSystemPropertyArg(propName);
        if (arg != null) {
            args.add(arg);
        }
    }

    private static final String getJPackageSystemPropertyArg(String propName) {
        String val = System.getProperty(propName);
        if (val == null) {
            return null;
        }
        return "-D" + propName + "=" + val;
    }

    private static NativeLauncherFinder getNativeAppLauncher() {
        OSFamily os = OSFamily.getInstance();
        NativeLauncherFinder l = os.equals(OSFamily.Windows) ? new WinLauncherFinder() : (os.equals(OSFamily.Mac) ? new MacLauncherFinder() : (os instanceof OSFamily.Unix ? new UnixLauncherFinder() : UnknownLauncherFinder));
        return l;
    }

    private static List<String> getNativeCommand(List<String> args) {
        NativeLauncherFinder l = VMLauncher.getNativeAppLauncher();
        return l.getAppPath() == null ? null : l.getCommand(args);
    }

    public static final Process restart(Class<?> mainClass, String ... args) throws IOException {
        return VMLauncher.restart(mainClass, Arrays.asList(args));
    }

    public static final Process restart(ProcessBuilder.Redirect action, Class<?> mainClass, String ... args) throws IOException {
        return VMLauncher.restart(action, mainClass, Arrays.asList(args));
    }

    public static final Process restart(Class<?> mainClass, List<String> args) throws IOException {
        return VMLauncher.restart(ProcessStreams.DISCARD, mainClass, args);
    }

    public static final Process restart(final ProcessBuilder.Redirect action, Class<?> mainClass, List<String> args) throws IOException {
        if (Boolean.getBoolean(NO_RESTART)) {
            return null;
        }
        final File wd = FileUtils.getWD();
        List<String> command = VMLauncher.getNativeCommand(args);
        if (command != null) {
            return new ProcessBuilder(command).directory(wd).redirectErrorStream(true).redirectOutput(action).start();
        }
        try {
            mainClass.getMethod("main", String[].class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(mainClass + " doesn't containt a main()", e);
        }
        return new VMLauncher(){

            @Override
            protected File getWD() {
                return wd;
            }

            @Override
            protected File getPropFile(String mainClass) {
                return null;
            }

            @Override
            protected ProcessBuilder.Redirect getStreamRedirect() {
                return action;
            }
        }.launch(mainClass.getName(), args);
    }

    public final File getLauncherWD() {
        if (this.wd == null) {
            NativeLauncherFinder nativeAppLauncher;
            String appPath;
            File appDir = VMLauncher.getJPackageAppDir();
            this.wd = appDir == null ? ((appPath = (nativeAppLauncher = VMLauncher.getNativeAppLauncher()).getAppPath()) != null ? new File(appPath).getAbsoluteFile().getParentFile() : (nativeAppLauncher.getFirstItem().equals(nativeAppLauncher.getClassPath()) && new File(nativeAppLauncher.getFirstItem()).isFile() ? new File(nativeAppLauncher.getFirstItem()).getParentFile() : FileUtils.getWD())) : appDir;
        }
        return this.wd;
    }

    private final List<String> split(String res) {
        if ((res = res.trim()).length() == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(NL.split(res));
    }

    private final List<String> getProp(File propFile, String propName) {
        return this.getProp(this.getProps(propFile), propName);
    }

    private final Properties getProps(File propFile) {
        if (propFile != null && propFile.canRead()) {
            try {
                return PropertiesUtils.createFromFile(propFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new Properties();
    }

    private final List<String> getProp(Properties props, String propName) {
        String res = "";
        if (props != null) {
            res = props.getProperty(propName, res);
        }
        return this.split(res);
    }

    public final Process launch(String mainClass) throws IOException {
        return this.launch(mainClass, Collections.emptyList());
    }

    public final Process launch(String mainClass, List<String> progParams) throws IOException {
        String envVMArgs;
        boolean debug = Boolean.getBoolean("launcher.debug");
        String javaBinary = this.getJavaBinary();
        File sameJava = new File(System.getProperty("java.home"), "bin/" + javaBinary);
        if (debug) {
            System.err.println("sameJava : " + sameJava);
        }
        String java = sameJava.canExecute() ? sameJava.getAbsolutePath() : javaBinary;
        File propFile = this.getPropFile(mainClass);
        Properties props = this.getProps(propFile);
        if (debug) {
            System.err.println("propFile : " + propFile);
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(java);
        if (this.enableRemoteDebug(props)) {
            command.add(RemoteDebugArgs.getArgs(props.getProperty("remoteDebugAddr")));
        }
        command.addAll(this.getVMArguments());
        if (propFile != null) {
            List<String> appProps = this.getProp(props, PROPS_VMARGS);
            command.addAll(appProps);
            if (debug) {
                System.err.println("VM arguments from " + propFile + " : " + appProps);
            }
            File localFile = FileUtils.prependSuffix(propFile, "-local", PROPERTIES_EXT);
            File userFile = new File(System.getProperty("user.home"), ".java/ilm/" + propFile.getName());
            for (File f : Arrays.asList(localFile, userFile)) {
                List<String> moreProps = this.getProp(f, PROPS_VMARGS);
                command.addAll(moreProps);
                if (!debug) continue;
                System.err.println("VM arguments from " + f + " : " + moreProps);
            }
        }
        if ((envVMArgs = System.getenv(ENV_VMARGS)) != null) {
            command.addAll(this.split(envVMArgs));
        }
        VMLauncher.addJPackageSystemPropertyArgument(command, APPDIR_SYSPROP);
        VMLauncher.addJPackageSystemPropertyArgument(command, APP_EXE_SYSPROP);
        command.add("-cp");
        command.add(this.getClassPath());
        command.add(mainClass);
        String envProgArgs = System.getenv(ENV_PROGARGS);
        if (envProgArgs != null) {
            command.addAll(this.split(envProgArgs));
        }
        command.addAll(progParams);
        ProcessBuilder procBuilder = new ProcessBuilder(command).directory(this.getWD());
        this.modifyEnv(procBuilder.environment());
        if (debug) {
            System.err.println("Command line : " + procBuilder.command());
            System.err.println("Dir : " + procBuilder.directory());
            System.err.println("Std out and err :");
        }
        procBuilder.redirectErrorStream(true).redirectOutput(debug ? ProcessBuilder.Redirect.INHERIT : this.getStreamRedirect());
        return procBuilder.start();
    }

    protected void modifyEnv(Map<String, String> environment) {
    }

    protected ProcessBuilder.Redirect getStreamRedirect() {
        return ProcessStreams.DISCARD;
    }

    protected boolean enableRemoteDebug(Properties props) {
        String prop = props.getProperty("remoteDebug");
        return prop == null ? this.remoteDebugDefault() : Boolean.parseBoolean(prop);
    }

    protected boolean remoteDebugDefault() {
        return false;
    }

    protected String getJavaBinary() {
        return OSFamily.getInstance() == OSFamily.Windows ? "javaw" : "java";
    }

    protected List<String> getVMArguments() {
        return Arrays.asList("-Dfile.encoding=UTF-8", "-Xms100M", "-Xmx256M");
    }

    protected String getClassPath() {
        return ManagementFactory.getRuntimeMXBean().getClassPath();
    }

    protected File getWD() {
        return this.getLauncherWD();
    }

    protected File getPropFile(String mainClass) {
        String className = mainClass.substring(mainClass.lastIndexOf(46) + 1);
        return new File(this.getWD(), String.valueOf(className) + PROPERTIES_EXT);
    }

    static /* synthetic */ String access$0() {
        return VMLauncher.getJPackageAppPath();
    }

    private static class MacLauncherFinder
    extends NativeLauncherFinder {
        private static final String APP_EXT = ".app";
        private static final Pattern MAC_PATTERN = Pattern.compile(String.valueOf(Pattern.quote(".app")) + "/Contents/(Resources(/Java)?|app)/[^/]+\\.jar$");

        private MacLauncherFinder() {
        }

        @Override
        public String getAppPath() {
            String appPath;
            File contentsDir;
            Matcher matcher = MAC_PATTERN.matcher(this.getFirstItem());
            if (matcher.matches() && new File(contentsDir = new File(appPath = this.getFirstItem().substring(0, matcher.start() + APP_EXT.length()), "Contents"), "Info.plist").isFile() && new File(contentsDir, "MacOS").isDirectory()) {
                return appPath;
            }
            return null;
        }

        @Override
        protected List<String> getCommand(String appPath, List<String> args) {
            ArrayList<String> command = new ArrayList<String>(4 + args.size());
            command.add("open");
            command.add("-n");
            command.add(appPath);
            command.add("--args");
            command.addAll(args);
            return command;
        }
    }

    private static abstract class NativeLauncherFinder {
        private final String cp = ManagementFactory.getRuntimeMXBean().getClassPath();
        private final String firstItem;

        public NativeLauncherFinder() {
            int sepIndex = this.cp.indexOf(File.pathSeparatorChar);
            this.firstItem = sepIndex < 0 ? this.cp : this.cp.substring(0, sepIndex);
        }

        public final String getClassPath() {
            return this.cp;
        }

        public final String getFirstItem() {
            return this.firstItem;
        }

        public abstract String getAppPath();

        public final List<String> getCommand(List<String> args) throws UnsupportedOperationException {
            String appPath = this.getAppPath();
            if (appPath == null) {
                throw new UnsupportedOperationException();
            }
            return this.getCommand(appPath, args);
        }

        protected List<String> getCommand(String appPath, List<String> args) {
            ArrayList<String> command = new ArrayList<String>(4 + args.size());
            command.add(appPath);
            command.addAll(args);
            return command;
        }
    }

    private static class UnixLauncherFinder
    extends NativeLauncherFinder {
        private final String jpackageApp = VMLauncher.access$0();

        @Override
        public String getAppPath() {
            return this.jpackageApp;
        }
    }

    private static class WinLauncherFinder
    extends NativeLauncherFinder {
        private WinLauncherFinder() {
        }

        @Override
        public String getAppPath() {
            if (this.getFirstItem().endsWith(".exe")) {
                return this.getFirstItem();
            }
            return null;
        }
    }
}

