/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.prog;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class RemoteDebugArgs {
    private static final DateFormat DBG_TIME_FORMAT = new SimpleDateFormat("HHmmss");

    public static void main(String[] args) {
        String debugArgs = Boolean.getBoolean("remoteDebug") ? RemoteDebugArgs.getArgs(System.getProperty("remoteDebugAddr")) : "";
        System.out.print(debugArgs);
    }

    public static String getArgs(String prop) {
        String debugAddr;
        if (prop == null || prop.trim().isEmpty()) {
            Date now = new Date();
            String time = DBG_TIME_FORMAT.format(now);
            if (time.startsWith("00")) {
                time = "24" + time.substring(2);
            } else if (time.startsWith("01")) {
                time = "25" + time.substring(2);
            }
            debugAddr = time.substring(0, time.length() - 1);
        } else {
            debugAddr = prop.trim();
        }
        return "-agentlib:jdwp=transport=dt_socket,address=" + debugAddr + ",server=y,suspend=n";
    }
}

