/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.ooxml;

import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;

public class XLSXFormat {
    private final int id;
    private final String format;
    private boolean isDateFormat = false;
    private Format jformat;

    public XLSXFormat(int id, String format) {
        this.id = id;
        this.format = format;
        String f = format.toLowerCase();
        if (f.contains("mm") || f.contains("dd") || f.contains("yy")) {
            this.isDateFormat = true;
        }
    }

    public XLSXFormat(int id, String format, boolean date) {
        this.id = id;
        this.format = format;
        this.isDateFormat = date;
    }

    public int getId() {
        return this.id;
    }

    public String getFormat() {
        return this.format;
    }

    public boolean isDateFormat() {
        return this.isDateFormat;
    }

    public String format(String txt) {
        if (this.format.equalsIgnoreCase("general")) {
            return txt;
        }
        if (this.jformat == null) {
            String javaFormat = this.format.replace("YYYY", "yyyy");
            javaFormat = javaFormat.replace("YY", "yy");
            javaFormat = javaFormat.replace("mm", "MM");
            javaFormat = javaFormat.replace("dd", "DD");
            this.jformat = this.isDateFormat ? new SimpleDateFormat(javaFormat) : new DecimalFormat(javaFormat);
        }
        return this.jformat.format(txt);
    }
}

