/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.net;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.mail.Message;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.StringUtils;

public class PlainMessage {
    private static final Pattern WS_PATTERN = Pattern.compile("[\\s&&[^ \t]]");
    private static final boolean strict = true;
    private String subject;
    private String body;
    private InternetAddress from;
    private final ListMap<Message.RecipientType, InternetAddress> recipients = new ListMap(8);
    private final Map<File, String> attachements = new LinkedHashMap<File, String>(8);

    public final String getSubject() {
        return this.subject;
    }

    public final void setSubject(String subject) {
        this.subject = subject == null ? null : WS_PATTERN.matcher(subject).replaceAll(" ");
    }

    public final void setBody(String text) {
        this.body = text;
    }

    public final String getBody() {
        return this.body;
    }

    public final Map<File, String> getAttachments() {
        return this.attachements;
    }

    public final InternetAddress getFrom() {
        return this.from;
    }

    public final void setFrom(String address) throws AddressException {
        this.setFrom(StringUtils.isEmpty(address) ? null : new InternetAddress(address, true));
    }

    public final void setFrom(InternetAddress address) {
        this.from = address;
    }

    public final List<InternetAddress> getRecipients(Message.RecipientType type) {
        return this.recipients.getOrDefault(type, (InternetAddress)Collections.emptyList());
    }

    public final void setRecipients(Message.RecipientType type, String list) throws AddressException {
        if (StringUtils.isEmpty(list)) {
            this.recipients.put(type, Collections.emptyList());
        } else {
            this.setRecipients(type, InternetAddress.parse((String)list, (boolean)true));
        }
    }

    public final void setRecipients(Message.RecipientType type, InternetAddress ... addresses) {
        this.setRecipients(type, Arrays.asList(addresses));
    }

    public final void setRecipients(Message.RecipientType type, Collection<InternetAddress> addresses) {
        this.recipients.putCollection(type, addresses);
    }

    public final void addRecipients(Message.RecipientType type, Collection<InternetAddress> addresses) {
        this.recipients.addAll(type, addresses);
    }
}

