/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.io;

import java.util.Objects;
import java.util.function.Function;
import net.minidev.json.JSONObject;
import org.openconcerto.utils.io.JSONConverter;

public final class JSONParameter<T> {
    private static final Function<Object, Object> DEFAULT_TO_JSON = JSONConverter::getJSON;
    private final String name;
    private final T defaultVal;
    private final Class<T> clazz;
    private final Function<? super T, ?> toJSON;
    private final Function<Object, T> fromJSON;

    public static <U> JSONParameter<U> createNoDefault(String name, Class<U> clazz) {
        return JSONParameter.create(name, clazz, null);
    }

    public static <U> JSONParameter<U> create(String name, Class<U> clazz, U def) {
        return new JSONParameter<Object>(name, clazz, DEFAULT_TO_JSON, o -> JSONConverter.getObjectFromJSON(o, clazz), def);
    }

    public static <U> JSONParameter<U> createWithFunction(String name, U def, Function<Object, U> fromJSON) {
        return JSONParameter.createWithFunction(name, def, DEFAULT_TO_JSON, fromJSON);
    }

    public static <U> JSONParameter<U> createWithFunction(String name, U def, Function<? super U, ?> toJSON, Function<Object, U> fromJSON) {
        return new JSONParameter<U>(name, null, toJSON, fromJSON, def);
    }

    protected JSONParameter(String name, Class<T> clazz, Function<? super T, ?> toJSON, Function<Object, T> fromJSON, T defaultVal) {
        this.name = Objects.requireNonNull(name);
        this.clazz = clazz;
        this.toJSON = Objects.requireNonNull(toJSON);
        this.fromJSON = Objects.requireNonNull(fromJSON);
        this.defaultVal = defaultVal;
    }

    public final String getName() {
        return this.name;
    }

    public final T getDefaultValue() {
        return this.defaultVal;
    }

    public final Class<T> getValueClass() {
        return this.clazz;
    }

    public final Function<? super T, ?> getToJSON() {
        return this.toJSON;
    }

    public final Function<Object, T> getFromJSON() {
        return this.fromJSON;
    }

    public final JSONObject put(JSONObject json, T val) {
        if (!Objects.equals(this.getDefaultValue(), val)) {
            json.put(this.getName(), this.getToJSON().apply(val));
        }
        return json;
    }

    public final T get(JSONObject json) {
        return JSONConverter.getParameterFromJSON(json, this.getName(), this.getFromJSON(), this.getDefaultValue());
    }
}

