/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.i18n;

import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class TranslationPool<T, X extends Exception> {
    private final Map<Locale, T> byLocale = new HashMap<Locale, T>(8);
    private final Function<Locale, T> createInstance;

    public TranslationPool() {
        this(null);
    }

    public TranslationPool(Function<Locale, T> createInstance) {
        this.createInstance = createInstance;
    }

    protected T createTM(Locale l) throws X {
        return this.createInstance.apply(l);
    }

    public final T get(Locale l) throws X {
        return this.get(l, Mode.GET_OR_CREATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T get(Locale l, Mode mode) throws X {
        T res;
        Objects.requireNonNull(l, "Missing locale");
        Objects.requireNonNull(mode, "Missing mode");
        TranslationPool translationPool = this;
        synchronized (translationPool) {
            res = this.byLocale.get(l);
            if (res == null && mode.allowCreation && (res = this.createTM(l)) != null) {
                this.byLocale.put(l, res);
            }
            if (res == null && !mode.allowNull) {
                throw new IllegalStateException("Missing instance for " + l);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T getCreated(Locale l) {
        Objects.requireNonNull(l, "Missing locale");
        TranslationPool translationPool = this;
        synchronized (translationPool) {
            T res = this.byLocale.get(l);
            if (res == null) {
                throw new IllegalStateException("Missing instance for " + l);
            }
            return res;
        }
    }

    final Collection<T> getCreated() {
        assert (Thread.holdsLock(this));
        return this.byLocale.values();
    }

    public static enum Mode {
        OPTIONAL_CREATE(true, true),
        GET_OR_CREATE(true, false),
        GET_CREATED(false, false);

        private final boolean allowCreation;
        private final boolean allowNull;

        private Mode(boolean allowCreation, boolean allowNull) {
            this.allowCreation = allowCreation;
            this.allowNull = allowNull;
        }
    }
}

