/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.i18n;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.openconcerto.utils.Log;
import org.openconcerto.utils.i18n.I18nUtils;
import org.openconcerto.utils.i18n.TM;
import org.openconcerto.utils.i18n.TranslationPool;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@ThreadSafe
public class TranslationManager {
    private static final Locale FALLBACK_LOCALE = Locale.ENGLISH;
    private static final ResourceBundle.Control CONTROL = new I18nUtils.SameLanguageControl(){

        @Override
        public Locale getFallbackLocale(String baseName, Locale locale) {
            if (!locale.equals(FALLBACK_LOCALE)) {
                return FALLBACK_LOCALE;
            }
            return null;
        }
    };
    private static final String BASENAME = "translation";
    private static final TranslationPool<TranslationManager, RuntimeException> POOL = new TranslationPool<TranslationManager, RuntimeException>(){

        @Override
        protected TranslationManager createTM(Locale l) throws RuntimeException {
            if (!$assertionsDisabled && !Thread.holdsLock(POOL)) {
                throw new AssertionError();
            }
            if (classes.isEmpty()) {
                return null;
            }
            TranslationManager res = new TranslationManager(l, null);
            res.setTranslations(classes, true);
            return res;
        }
    };
    @GuardedBy(value="POOL")
    private static final List<Object> classes = new ArrayList<Object>();
    private final Locale locale;
    private final Object trMutex = new Object();
    @GuardedBy(value="trMutex")
    private Map<String, String> menuTranslation;
    @GuardedBy(value="trMutex")
    private Map<String, String> itemTranslation;
    @GuardedBy(value="trMutex")
    private Map<String, String> actionTranslation;

    public static final void setVMLocale(Locale locale) {
        Locale.setDefault(locale);
        TranslationManager.createDefaultInstance();
    }

    public static final ResourceBundle.Control getControl() {
        return CONTROL;
    }

    public static final TranslationManager createDefaultInstance() {
        return POOL.get(TM.getDefaultLocale(), TranslationPool.Mode.OPTIONAL_CREATE);
    }

    public static final TranslationManager getInstance() {
        return TranslationManager.getInstance(TM.getDefaultLocale());
    }

    public static final TranslationManager createInstance(Locale l) {
        return POOL.get(l);
    }

    public static final TranslationManager getInstance(Locale l) {
        return POOL.getCreated(l);
    }

    public static final void addTranslationStreamFromClass(Class<?> c) {
        TranslationManager._addLoader(c);
    }

    public static final void addLoader(Loader loader) {
        TranslationManager._addLoader(loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void _addLoader(Object loader) {
        TranslationPool<TranslationManager, RuntimeException> translationPool = POOL;
        synchronized (translationPool) {
            classes.add(loader);
            for (TranslationManager tm : POOL.getCreated()) {
                tm.addTranslations(loader, true);
            }
        }
    }

    public static final void removeTranslationStreamFromClass(Class<?> c) {
        TranslationManager._removeLoader(c);
    }

    public static final void removeLoader(Loader loader) {
        TranslationManager._removeLoader(loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void _removeLoader(Object o) {
        TranslationPool<TranslationManager, RuntimeException> translationPool = POOL;
        synchronized (translationPool) {
            if (classes.remove(o)) {
                for (TranslationManager tm : POOL.getCreated()) {
                    tm.setTranslations(classes, false);
                }
            }
        }
    }

    private TranslationManager(Locale locale) {
        this.locale = locale;
    }

    public final Locale getLocale() {
        return this.locale;
    }

    private void checkNulls(String id, String label) {
        if (id == null) {
            throw new NullPointerException("null id");
        }
        if (label == null) {
            throw new NullPointerException("null label");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTranslationForMenu(String id) {
        Object object = this.trMutex;
        synchronized (object) {
            return this.menuTranslation.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTranslationForMenu(String id, String label) {
        this.checkNulls(id, label);
        Object object = this.trMutex;
        synchronized (object) {
            this.menuTranslation.put(id, label);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTranslationForItem(String id) {
        Object object = this.trMutex;
        synchronized (object) {
            return this.itemTranslation.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTranslationForItem(String id, String label) {
        this.checkNulls(id, label);
        Object object = this.trMutex;
        synchronized (object) {
            this.itemTranslation.put(id, label);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTranslationForAction(String id) {
        Object object = this.trMutex;
        synchronized (object) {
            return this.actionTranslation.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTranslationForAction(String id, String label) {
        this.checkNulls(id, label);
        Object object = this.trMutex;
        synchronized (object) {
            this.actionTranslation.put(id, label);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTranslations(Collection<?> classes, boolean warn) {
        Object object = this.trMutex;
        synchronized (object) {
            this.menuTranslation = new HashMap<String, String>();
            this.itemTranslation = new HashMap<String, String>();
            this.actionTranslation = new HashMap<String, String>();
            if (warn && classes.isEmpty()) {
                Log.get().warning("TranslationManager has no resources to load (" + this.getLocale() + ")");
            }
            for (Object o : classes) {
                this.addTranslations(o, warn);
            }
        }
    }

    private void addTranslations(Object o, boolean warn) {
        if (o instanceof Class) {
            Class c = (Class)o;
            boolean loaded = this.loadTranslation(this.getLocale(), c);
            if (warn && !loaded) {
                Log.get().warning("TranslationManager was unable to load translation " + c.getCanonicalName() + " for locale " + this.getLocale());
            }
        } else {
            Loader loader = (Loader)o;
            loader.accept(this);
        }
    }

    private List<String> findResources(Locale locale, Class<?> c, boolean rootLast) {
        ResourceBundle.Control cntrl = CONTROL;
        ArrayList<String> res = new ArrayList<String>();
        String baseName = String.valueOf(c.getPackage().getName()) + "." + BASENAME;
        Locale targetLocale = locale;
        while (targetLocale != null && res.isEmpty()) {
            for (Locale candidate : cntrl.getCandidateLocales(baseName, targetLocale)) {
                res.add(cntrl.toResourceName(cntrl.toBundleName(baseName, candidate), "xml"));
            }
            targetLocale = cntrl.getFallbackLocale(baseName, targetLocale);
        }
        if (!rootLast) {
            Collections.reverse(res);
        }
        return res;
    }

    private boolean loadTranslation(Locale l, Class<?> c) {
        DocumentBuilder dBuilder;
        boolean translationLoaded = false;
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            dbFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            dbFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Couldn't create DocumentBuilder", e);
        }
        for (String rsrcName : this.findResources(l, c, false)) {
            HashMap<String, String> menuTranslation = new HashMap<String, String>();
            HashMap<String, String> itemTranslation = new HashMap<String, String>();
            HashMap<String, String> actionTranslation = new HashMap<String, String>();
            try {
                Throwable throwable = null;
                Object var12_15 = null;
                try (InputStream input = c.getClassLoader().getResourceAsStream(rsrcName);){
                    if (input == null) continue;
                    Document doc = dBuilder.parse(input);
                    TranslationManager.loadTranslation(doc, "menu", menuTranslation);
                    TranslationManager.loadTranslation(doc, "item", itemTranslation);
                    TranslationManager.loadTranslation(doc, "action", actionTranslation);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | SAXException e) {
                e.printStackTrace();
            }
            this.menuTranslation.putAll(menuTranslation);
            this.itemTranslation.putAll(itemTranslation);
            this.actionTranslation.putAll(actionTranslation);
            translationLoaded = true;
        }
        return translationLoaded;
    }

    private static void loadTranslation(Document doc, String tagName, Map<String, String> m) {
        NodeList menuChildren = doc.getElementsByTagName(tagName);
        int size = menuChildren.getLength();
        int i = 0;
        while (i < size) {
            Element element = (Element)menuChildren.item(i);
            String id = element.getAttributeNode("id").getValue();
            String label = element.getAttributeNode("label").getValue();
            if (m.containsKey(id)) {
                throw new IllegalStateException("Duplicate " + tagName + " translation entry for " + id + " (" + label + ")");
            }
            m.put(id, label);
            ++i;
        }
    }

    /* synthetic */ TranslationManager(Locale locale, TranslationManager translationManager) {
        this(locale);
    }

    public static interface Loader
    extends Consumer<TranslationManager> {
    }
}

