/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.i18n;

import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.MessagePattern;
import java.beans.Introspector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jcip.annotations.ThreadSafe;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.Log;
import org.openconcerto.utils.PropertiesUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.i18n.DynamicMap;
import org.openconcerto.utils.i18n.I18nUtils;
import org.openconcerto.utils.i18n.LocalizedInstances;
import org.openconcerto.utils.i18n.MessageArgs;
import org.openconcerto.utils.i18n.NounClass;
import org.openconcerto.utils.i18n.Phrase;
import org.openconcerto.utils.i18n.TMPool;
import org.openconcerto.utils.i18n.TranslationManager;
import org.openconcerto.utils.i18n.Translator;
import org.openconcerto.utils.i18n.TranslatorChain;

@ThreadSafe
public class TM {
    public static final String NOUN_CLASS_PROP = "nounClass";
    private static final MissingMode DEFAULT_MISSING_MODE;
    private static final TMPool<TM> POOL;
    private static final Pattern splitPtrn;
    private static boolean USE_DYNAMIC_MAP;
    private Locale locale;
    private TranslatorChain translations;
    private Locale translationsLocale;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        boolean bl = $assertionsDisabled = !TM.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !NOUN_CLASS_PROP.equals(Introspector.decapitalize(NounClass.class.getSimpleName()))) {
            throw new AssertionError();
        }
        DEFAULT_MISSING_MODE = MissingMode.STRING;
        POOL = new TMPool<TM>(TM::new);
        splitPtrn = Pattern.compile("__", 16);
        USE_DYNAMIC_MAP = true;
    }

    public static synchronized void setUseDynamicMap(boolean b) {
        USE_DYNAMIC_MAP = b;
    }

    public static synchronized boolean useDynamicMap() {
        return USE_DYNAMIC_MAP;
    }

    public static final Locale getDefaultLocale() {
        return Locale.getDefault();
    }

    public static TM getInstance() {
        return TM.getInstance(TM.getDefaultLocale());
    }

    public static TM getInstance(Locale l) {
        return (TM)POOL.get(l);
    }

    public static String tr(Locale l, String key, Object ... args) {
        return TM.getInstance(l).translate(key, args);
    }

    public static String tr(String key, Object ... args) {
        return TM.getInstance().translate(key, args);
    }

    protected TM(Locale locale) {
        this.setLocale(locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setLocale(Locale locale) {
        LocalizedInstances<Translator> localizedInstances = new LocalizedInstances<Translator>(Translator.class, TranslationManager.getControl()){

            @Override
            protected Translator createInstance(String bundleName, final Locale l, Class<?> cl) throws IOException {
                final Properties props = PropertiesUtils.createFromResource(cl, String.valueOf('/') + this.getControl().toResourceName(bundleName, "properties"));
                if (props == null) {
                    return null;
                }
                return new Translator(){

                    @Override
                    public String translate(String key, MessageArgs args) {
                        String msg = props.getProperty(key);
                        if (msg == null) {
                            return null;
                        }
                        return new MessageFormat(msg, l).format(TM.this.replaceMap(args, msg).getAll());
                    }
                };
            }
        };
        Tuple2 createInstances = localizedInstances.createInstances(this.getBaseName(), locale);
        TM tM = this;
        synchronized (tM) {
            this.locale = locale;
            this.translationsLocale = createInstances.get0();
            this.translations = new TranslatorChain(createInstances.get1());
        }
    }

    public final synchronized Locale getLocale() {
        return this.locale;
    }

    public final synchronized Locale getTranslationsLocale() {
        return this.translationsLocale;
    }

    private final synchronized TranslatorChain getTranslations() {
        return this.translations;
    }

    protected String getBaseName() {
        return I18nUtils.getBaseName(this.getClass());
    }

    public final String trA(String key, Object ... args) {
        return this.translate(key, args);
    }

    public final String translate(String key, Object ... args) {
        return this.translate(DEFAULT_MISSING_MODE, key, args);
    }

    public final String trM(String key, String name1, Object arg1) {
        return this.trM(key, Collections.singletonMap(name1, arg1));
    }

    public final String trM(String key, String name1, Object arg1, String name2, Object arg2) {
        return this.trM(key, CollectionUtils.createMap(name1, arg1, name2, arg2));
    }

    public final String trM(String key, Map<String, ?> args) {
        return this.trM(DEFAULT_MISSING_MODE, key, args);
    }

    public final String trM(MissingMode mode, String key, Map<String, ?> map) throws MissingResourceException {
        return this.translate(mode, key, new MessageArgs(map));
    }

    public final String translate(MissingMode mode, String key, Object ... args) throws MissingResourceException {
        return this.translate(mode, key, args.length == 0 ? MessageArgs.getEmpty() : new MessageArgs(args));
    }

    public final String translateFirst(MissingMode mode, String ... keys) throws MissingResourceException {
        return this.translateFirst(mode, MessageArgs.getEmpty(), keys);
    }

    public final String translateFirst(MissingMode mode, MessageArgs args, String ... keys) throws MissingResourceException {
        String res = null;
        int i = 0;
        while (i < keys.length && res == null) {
            String key = keys[i];
            if (key != null) {
                res = this.translate(MissingMode.NULL, key, args);
            }
            ++i;
        }
        return mode.returnResult(this, res, keys);
    }

    private final String translate(MissingMode mode, String key, MessageArgs args) throws MissingResourceException {
        Objects.requireNonNull(mode, "Null mode");
        Objects.requireNonNull(key, "Null key");
        Objects.requireNonNull(args, "Null arguments");
        String res = this.getTranslations().translate(key, args);
        return mode.returnResult(this, res, key);
    }

    protected MessageArgs replaceMap(MessageArgs args, String msg) {
        MessageArgs res;
        if (args.isMapPrimary()) {
            Map<String, Object> newMap;
            Map<String, ?> map = args.getMap();
            HashMap copy = MessageArgs.isOrdered(map) ? new LinkedHashMap(map) : new HashMap(map);
            final Object[] array = args.getArray();
            if (TM.useDynamicMap()) {
                newMap = new DynamicMap<Object>(copy){

                    @Override
                    protected Object createValueNonNull(String key) {
                        return TM.this.createValue(this, array, key);
                    }
                };
            } else {
                newMap = copy;
                MessagePattern messagePattern = new MessagePattern(msg);
                if (messagePattern.hasNamedArguments()) {
                    int countParts = messagePattern.countParts();
                    int i = 0;
                    while (i < countParts) {
                        Object createValue;
                        String argName;
                        MessagePattern.Part part = messagePattern.getPart(i);
                        if (part.getType() == MessagePattern.Part.Type.ARG_NAME && !newMap.containsKey(argName = messagePattern.getSubstring(part)) && (createValue = this.createValue(newMap, array, argName)) != null) {
                            newMap.put(argName, createValue);
                        }
                        ++i;
                    }
                }
            }
            res = new MessageArgs(newMap);
        } else {
            res = args;
        }
        return res;
    }

    protected Object createValue(Map<String, Object> map, Object[] objects, String key) {
        Phrase phrase;
        if (key.length() == 1 && Character.isDigit(key.charAt(0))) {
            int index = Integer.parseInt(key);
            if (index < objects.length) {
                return objects[index];
            }
            Log.get().warning("Only " + objects.length + " arguments : " + index);
            return null;
        }
        Matcher m = splitPtrn.matcher(key);
        String pattern = splitPtrn.pattern();
        int patternL = pattern.length();
        StringBuffer sb = new StringBuffer(key.length());
        ArrayList<String> l = new ArrayList<String>();
        int pos = 0;
        while (m.find(pos)) {
            if (key.length() >= m.end() + patternL && pattern.equals(key.substring(m.end(), m.end() + patternL))) {
                sb.append(key.substring(pos, m.end()));
                pos = m.end() + patternL;
                continue;
            }
            sb.append(key.substring(pos, m.start()));
            l.add(sb.toString());
            sb.setLength(0);
            pos = m.end();
        }
        sb.append(key.substring(pos));
        l.add(sb.toString());
        String first = (String)CollectionUtils.getFirst(l);
        if (!$assertionsDisabled && first == null) {
            throw new AssertionError();
        }
        Object firstObj = this.handleGet(map, first);
        Phrase phrase2 = phrase = firstObj instanceof Phrase ? (Phrase)firstObj : null;
        if (phrase != null && l.size() == 2 && NOUN_CLASS_PROP.equals(l.get(1))) {
            if (phrase.getNounClass() == null) {
                Log.get().warning("No noun class for " + phrase);
                return phrase.getBase();
            }
            return phrase.getNounClass().getName();
        }
        if (phrase != null && phrase.getGrammar() != null) {
            Object countObj = this.handleGet(map, String.valueOf(first) + "Count");
            if (!(countObj instanceof Number)) {
                countObj = this.handleGet(map, "count");
            }
            Number count = countObj instanceof Number ? (Number)((Number)countObj) : (Number)null;
            return phrase.getGrammar().eval(phrase, count, l.subList(1, l.size()));
        }
        if (phrase != null) {
            Log.get().warning("While splitting " + key + ", " + first + " is a Phrase without grammar : " + phrase);
            return phrase.getBase();
        }
        Log.get().warning("While splitting " + key + " : " + first + " isn't a Phrase");
        return null;
    }

    private final Object handleGet(Map<String, Object> map, String key) {
        if (map instanceof DynamicMap) {
            return ((DynamicMap)map).handleGet(key);
        }
        return map.get(key);
    }

    public static enum MissingMode {
        EXCEPTION{

            @Override
            protected String returnMissing(TM tm, String key) throws MissingResourceException {
                throw new MissingResourceException("Missing translation", tm.getBaseName(), key);
            }
        }
        ,
        NULL{

            @Override
            protected String returnMissing(TM tm, String key) {
                return null;
            }
        }
        ,
        STRING{

            @Override
            protected String returnMissing(TM tm, String key) {
                return String.valueOf('!') + key + '!';
            }
        };


        protected abstract String returnMissing(TM var1, String var2) throws MissingResourceException;

        protected final String returnResult(TM tm, String res, String key) throws MissingResourceException {
            return res == null ? this.returnMissing(tm, key) : res;
        }

        protected final String returnResult(TM tm, String res, String ... keys) throws MissingResourceException {
            return res == null ? this.returnMissing(tm, Arrays.toString(keys)) : res;
        }
    }
}

