/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.i18n;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class MessageArgs {
    private static final MessageArgs EMPTY = new MessageArgs(new Object[0]);
    private final boolean mapPrimary;
    private Object[] array;
    private Map<String, ?> map;

    protected static boolean isOrdered(Map<?, ?> m) {
        return m instanceof LinkedHashMap;
    }

    public static final MessageArgs getEmpty() {
        return EMPTY;
    }

    public static final MessageArgs create(String key, Object value) {
        return new MessageArgs(Collections.singletonMap(key, value));
    }

    public MessageArgs(Object[] array) {
        this(null, array);
    }

    public MessageArgs(Map<String, ?> map) {
        this(map, null);
    }

    private MessageArgs(Map<String, ?> map, Object[] array) {
        if (map == null && array == null) {
            throw new NullPointerException();
        }
        boolean bl = this.mapPrimary = map != null;
        assert (this.mapPrimary == (array == null));
        this.array = array;
        this.map = map;
    }

    public final boolean isMapPrimary() {
        return this.mapPrimary;
    }

    public final synchronized Object getAll() {
        return this.mapPrimary ? this.map : this.array;
    }

    protected synchronized Object[] getArray() {
        if (this.array == null) {
            this.array = new Object[this.map.size()];
            int i = 0;
            if (MessageArgs.isOrdered(this.map)) {
                for (Object v : this.map.values()) {
                    this.array[i++] = v;
                }
            } else {
                for (String name : new TreeSet<String>(this.map.keySet())) {
                    this.array[i++] = this.map.get(name);
                }
            }
            assert (i == this.array.length);
        }
        return this.array;
    }

    protected synchronized Map<String, ?> getMap() {
        if (this.map == null) {
            int stop = this.array.length;
            if (stop == 0) {
                this.map = Collections.emptyMap();
            } else {
                LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>(stop);
                int i = 0;
                while (i < stop) {
                    res.put(String.valueOf(i), this.array[i]);
                    ++i;
                }
                this.map = Collections.unmodifiableMap(res);
            }
        }
        return this.map;
    }

    public final Object getArgument(int i) {
        return this.getArray()[i];
    }

    public final Object getArgument(String name) {
        return this.getMap().get(name);
    }
}

