/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.i18n;

import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import net.jcip.annotations.Immutable;
import org.openconcerto.utils.i18n.Grammar;
import org.openconcerto.utils.i18n.NounClass;
import org.openconcerto.utils.i18n.Phrase;
import org.openconcerto.utils.i18n.VariantKey;

@Immutable
public class Grammar_es
extends Grammar {
    private static final Grammar_es INSTANCE = new Grammar_es();

    public static Grammar_es getInstance() {
        return INSTANCE;
    }

    private Grammar_es() {
        this(Locale.forLanguageTag("es"));
    }

    protected Grammar_es(Locale l) {
        super(l);
    }

    @Override
    protected Collection<? extends VariantKey> createVariantKeys() {
        return Arrays.asList(SINGULAR, PLURAL, INDEFINITE_ARTICLE_SINGULAR, INDEFINITE_ARTICLE_PLURAL, DEFINITE_ARTICLE_SINGULAR, DEFINITE_ARTICLE_PLURAL, DEMONSTRATIVE_SINGULAR, DEMONSTRATIVE_PLURAL, INDEFINITE_NUMERAL, DEFINITE_NUMERAL, DEMONSTRATIVE_NUMERAL, INDEFINITE_ORDINAL, DEFINITE_ORDINAL);
    }

    @Override
    protected Collection<? extends NounClass> createNounClasses() {
        return Arrays.asList(NounClass.FEMININE, NounClass.MASCULINE);
    }

    public final Phrase createPhrase(String singular) {
        return this.createPhrase(singular, null);
    }

    public final Phrase createPhrase(String singular, String plural) {
        Phrase res = new Phrase(this, singular, null);
        if (plural != null) {
            res.putVariant(PLURAL, plural);
        }
        return res;
    }

    @Override
    public String getVariant(Phrase noun, VariantKey key) {
        String res;
        if (key.equals(SINGULAR)) {
            res = noun.getBase();
        } else if (key.equals(INDEFINITE_ARTICLE_SINGULAR)) {
            res = String.valueOf(noun.getNounClass() == NounClass.FEMININE ? "una " : "un ") + this.getSingular(noun);
        } else if (key.equals(DEFINITE_ARTICLE_SINGULAR)) {
            res = String.valueOf(this.getDefiniteArticle(noun)) + this.getSingular(noun);
        } else if (key.equals(DEMONSTRATIVE_SINGULAR)) {
            res = String.valueOf(noun.getNounClass() == NounClass.FEMININE ? "esta " : "este ") + this.getSingular(noun);
        } else if (key.equals(PLURAL)) {
            res = this.getPlural(noun.getBase());
        } else if (key.equals(INDEFINITE_ARTICLE_PLURAL)) {
            res = String.valueOf(noun.getNounClass() == NounClass.FEMININE ? "unas " : "unos ") + this.getPlural(noun);
        } else if (key.equals(DEFINITE_ARTICLE_PLURAL)) {
            res = String.valueOf(noun.getNounClass() == NounClass.FEMININE ? "las " : "los ") + this.getPlural(noun);
        } else if (key.equals(DEMONSTRATIVE_PLURAL)) {
            res = String.valueOf(noun.getNounClass() == NounClass.FEMININE ? "estas " : "estos ") + this.getPlural(noun);
        } else if (key.equals(INDEFINITE_NUMERAL)) {
            res = "{0, plural, =0 {" + this.getZero(noun) + "} one {# " + this.getSingular(noun) + "} other {# " + this.getPlural(noun) + "}}";
        } else if (key.equals(DEFINITE_NUMERAL)) {
            res = "{0, plural, =0 {" + this.getZero(noun) + "} one {" + this.getVariant(noun, DEFINITE_ARTICLE_SINGULAR) + "} other {" + (noun.getNounClass() == NounClass.FEMININE ? "las " : "los ") + " # " + this.getPlural(noun) + "}}";
        } else if (key.equals(DEMONSTRATIVE_NUMERAL)) {
            res = "{0, plural, =0 {" + this.getZero(noun) + "} one {" + this.getVariant(noun, DEMONSTRATIVE_SINGULAR) + "} other {" + (noun.getNounClass() == NounClass.FEMININE ? "estas " : "estos ") + " # " + this.getPlural(noun) + "}}";
        } else if (key.equals(DEFINITE_ORDINAL) || key.equals(INDEFINITE_ORDINAL)) {
            boolean estF\u00e9minin;
            boolean bl = estF\u00e9minin = noun.getNounClass() == NounClass.FEMININE;
            String article = key.equals(DEFINITE_ORDINAL) ? (estF\u00e9minin ? "la " : "el ") : "";
            res = String.valueOf(article) + "{0, ordinal, %digits-ordinal" + (estF\u00e9minin ? "-feminine" : "") + "} " + this.getSingular(noun);
        } else {
            res = null;
        }
        return res;
    }

    protected String getZero(Phrase noun) {
        return String.valueOf(noun.getNounClass() == NounClass.MASCULINE ? "ning\u00fan " : "ninguna ") + noun.getBase();
    }

    protected String getDefiniteArticle(Phrase noun) {
        if (noun.getNounClass() == NounClass.MASCULINE || noun.getBase().startsWith("a") || noun.getBase().startsWith("ha")) {
            return "el ";
        }
        return "la ";
    }

    protected String getSingular(Phrase noun) {
        String res = noun.getVariant(SINGULAR);
        return res == null ? noun.getBase() : res;
    }

    protected String getPlural(Phrase noun) {
        String res = noun.getVariant(PLURAL);
        return res == null ? this.getPlural(noun.getBase()) : res;
    }

    protected String getPlural(String noun) {
        return String.valueOf(noun) + 's';
    }
}

