/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.function;

import java.util.Objects;
import java.util.function.Supplier;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.openconcerto.utils.function.ConstantSupplier;

@ThreadSafe
public abstract class FunctionalSupplier<T>
implements Supplier<T> {
    public static final <U> FunctionalSupplier<U> get(Supplier<U> orig) {
        return orig instanceof FunctionalSupplier ? (FunctionalSupplier<Object>)orig : new LazyValue<U>(orig);
    }

    public static final <U> ConstantSupplier<U> getConstant(U value) {
        return new ConstantSupplier<U>(value);
    }

    FunctionalSupplier() {
    }

    @ThreadSafe
    static final class LazyValue<T>
    extends FunctionalSupplier<T> {
        private final Supplier<T> supplier;
        @GuardedBy(value="this")
        private boolean set;
        @GuardedBy(value="this")
        private T value;

        LazyValue(Supplier<T> supplier) {
            this.supplier = Objects.requireNonNull(supplier);
            this.set = false;
        }

        @Override
        public synchronized T get() {
            if (!this.set) {
                this.value = this.supplier.get();
                this.set = true;
            }
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " for " + this.supplier;
        }
    }
}

