/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.function;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.openconcerto.utils.CollectionUtils;

public class FirstNonNull<T, R>
implements Function<T, R> {
    private static final Function EMPTY = v -> null;
    private final List<Function<? super T, ? extends R>> functions;

    public static final <T, R> Function<T, R> empty() {
        return EMPTY;
    }

    public static final <T, R> Function<T, R> create(Collection<? extends Function<? super T, ? extends R>> functions) {
        if (functions.isEmpty()) {
            return FirstNonNull.empty();
        }
        return new FirstNonNull<T, R>(CollectionUtils.toImmutableList(functions));
    }

    @SafeVarargs
    public static final <T, R> Function<T, R> create(Function<? super T, ? extends R> ... functions) {
        if (functions.length == 0) {
            return FirstNonNull.empty();
        }
        return new FirstNonNull<T, R>(CollectionUtils.toImmutableList(functions));
    }

    private FirstNonNull(List<Function<? super T, ? extends R>> functions) {
        this.functions = functions;
        if (this.functions.contains(null)) {
            throw new IllegalArgumentException("Null function : " + this.functions);
        }
    }

    @Override
    public R apply(T t) {
        for (Function<T, R> f : this.functions) {
            R res = f.apply(t);
            if (res == null) continue;
            return res;
        }
        return null;
    }
}

