/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.doml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import org.openconcerto.utils.doml.DOMLStreamReader;
import org.openconcerto.utils.doml.Element;

public class Document {
    private Element root;
    private byte[] buffer = new byte[64];

    public Document() {
    }

    public Document(String rootName) {
        this.root = new Element(rootName);
    }

    public Document(Element root) {
        this.root = root;
    }

    public void loadFrom(BufferedReader br) throws IOException {
        this.root = this.readElement(new DOMLStreamReader(br), 0);
    }

    private Element readElement(DOMLStreamReader r, int depth) throws IOException {
        int t = r.readNextToken();
        if (t == 0 || t == 4) {
            return null;
        }
        if (t != 1) {
            throw new IOException("not element start found (" + t + ")");
        }
        String tagName = r.readTagName();
        Element current = new Element(tagName);
        t = r.readNextToken();
        if (t == 3) {
            return current;
        }
        if (t == 2) {
            this.readChildren(r, depth, tagName, current);
            return current;
        }
        if (t == 4) {
            while (t == 4) {
                String name = r.readAttributeName();
                String value = r.readAttributeValue();
                current.setAttribute(name, value);
                t = r.readNextToken();
            }
            if (t == 2) {
                this.readChildren(r, depth, tagName, current);
            }
            return current;
        }
        return null;
    }

    private void readChildren(DOMLStreamReader r, int depth, String tagName, Element current) throws IOException {
        boolean tryReadNextChild = false;
        do {
            char n1 = r.readNextChar();
            while (n1 < '!') {
                n1 = r.readNextChar();
            }
            if (n1 == '\uffff') {
                return;
            }
            tryReadNextChild = false;
            if (n1 != '<') continue;
            char n2 = r.readNextChar();
            if (n2 != '/') {
                tryReadNextChild = true;
                r.unread(n2);
                r.unread(n1);
                Element e = this.readElement(r, depth + 1);
                if (e == null) continue;
                current.addChild(e);
                continue;
            }
            r.unread(n2);
            r.unread(n1);
        } while (tryReadNextChild);
        int t = r.readNextToken();
        if (t != 1) {
            throw new IOException("not closing element start found for " + tagName + " (" + t + ") : '" + r.readNextChar());
        }
        String ctagName = r.readTagName();
        t = r.readNextToken();
        if (t != 2) {
            throw new IOException("closing element end tag for '" + ctagName + "' is missing " + t);
        }
    }

    public void writeTo(BufferedWriter writer) throws IOException {
        if (this.root == null) {
            return;
        }
        this.writeTo(writer, 0, this.root);
        writer.flush();
    }

    private Element readElement(BufferedInputStream in) throws IOException {
        String name = this.readUTF(in);
        int attributeCount = this.readInt(in);
        int childrenCount = this.readInt(in);
        Element e = new Element(name, attributeCount, childrenCount);
        int i = 0;
        while (i < attributeCount) {
            String n = this.readUTF(in);
            String v = this.readUTF(in);
            e.addAttributeNoCheck(n, v);
            ++i;
        }
        i = 0;
        while (i < childrenCount) {
            e.addChildNoCheck(this.readElement(in));
            ++i;
        }
        return e;
    }

    public void loadFromBinary(BufferedInputStream in) throws IOException {
        this.root = this.readElement(in);
    }

    public void loadFromBinary(File file) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            this.root = this.readElement(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void loadFromBinary(byte[] bytes) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(bytes));){
            this.root = this.readElement(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void writeToBinary(BufferedOutputStream out) throws IOException {
        if (this.root == null) {
            return;
        }
        this.writeTo(out, this.root);
        out.flush();
    }

    public void writeToBinary(File file) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
            this.writeToBinary(out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void writeTo(BufferedOutputStream out, Element e) throws IOException {
        Document.writeUTF(out, e.getName());
        int attributeCount = e.getAttributeCount();
        Document.writeInt(out, attributeCount);
        Document.writeInt(out, e.getChildrenCount());
        if (attributeCount > 0) {
            e.writeAttributes(out);
        }
        for (Element c : e.getChildren()) {
            this.writeTo(out, c);
        }
    }

    public byte[] toByteArray() throws IOException {
        if (this.root == null) {
            return new byte[0];
        }
        ByteArrayOutputStream out2 = new ByteArrayOutputStream(1024 + this.root.getChildrenCount() * 32);
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedOutputStream out = new BufferedOutputStream(out2);){
            this.writeToBinary(out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return out2.toByteArray();
    }

    private static final void writeInt(BufferedOutputStream out, int v) throws IOException {
        out.write(v >>> 24 & 0xFF);
        out.write(v >>> 16 & 0xFF);
        out.write(v >>> 8 & 0xFF);
        out.write(v & 0xFF);
    }

    static final void writeUTF(BufferedOutputStream out, String str) throws IOException {
        byte[] buf = str.getBytes(StandardCharsets.UTF_8);
        Document.writeInt(out, buf.length);
        out.write(buf);
    }

    private final int readInt(BufferedInputStream in) throws IOException {
        int ch1 = in.read();
        int ch2 = in.read();
        int ch3 = in.read();
        int ch4 = in.read();
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    private final String readUTF(BufferedInputStream in) throws IOException {
        int size = this.readInt(in);
        if (this.buffer.length < size) {
            this.buffer = new byte[size + 32];
        }
        int s = in.read(this.buffer, 0, size);
        return new String(this.buffer, 0, s, StandardCharsets.UTF_8);
    }

    public String toString() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.writeTo(new BufferedWriter(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8)));
            return out.toString(StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }

    private void writeTo(BufferedWriter writer, int depth, Element e) throws IOException {
        if (e.getChildrenCount() == 0) {
            int i = 0;
            while (i < depth) {
                writer.append(' ');
                ++i;
            }
            writer.append('<');
            writer.append(e.getName());
            e.appendAttributes(writer);
            writer.append(" />\n");
        } else {
            int i = 0;
            while (i < depth) {
                writer.append(' ');
                ++i;
            }
            writer.append('<');
            writer.append(e.getName());
            e.appendAttributes(writer);
            writer.append(">\n");
            int d = depth + 1;
            for (Element child : e.getChildren()) {
                this.writeTo(writer, d, child);
            }
            int i2 = 0;
            while (i2 < depth) {
                writer.append(' ');
                ++i2;
            }
            writer.append("</");
            writer.append(e.getName());
            writer.append(">\n");
        }
    }

    public Element getRoot() {
        return this.root;
    }
}

