/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.convertor;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.openconcerto.utils.convertor.ValueConvertor;

public abstract class NumberConvertor<T extends Number, U extends Number>
implements ValueConvertor<T, U> {
    public static final NumberConvertor<Integer, Long> INT_TO_LONG = new NumberConvertor<Integer, Long>(){

        @Override
        public Long convert(Integer o) {
            return o.longValue();
        }

        @Override
        public Integer unconvert(Long o) {
            return Math.toIntExact(o);
        }
    };
    public static final NumberConvertor<Short, Integer> SHORT_TO_INT = new NumberConvertor<Short, Integer>(){

        @Override
        public Integer convert(Short o) {
            return o.intValue();
        }

        @Override
        public Short unconvert(Integer o) {
            short res = o.shortValue();
            if (res != o) {
                throw new OverflowException(o, Short.class);
            }
            return res;
        }
    };
    public static final NumberConvertor<Integer, BigDecimal> INT_TO_BIGDECIMAL_EXACT = new NumberConvertor<Integer, BigDecimal>(){

        @Override
        public BigDecimal convert(Integer o) {
            return BigDecimal.valueOf(o.longValue());
        }

        @Override
        public Integer unconvert(BigDecimal o) {
            return o.intValueExact();
        }
    };
    public static final BigDecimal MAX_FLOAT = BigDecimal.valueOf(3.4028234663852886E38);
    public static final BigDecimal MIN_FLOAT = MAX_FLOAT.negate();
    public static final BigDecimal MAX_DOUBLE = BigDecimal.valueOf(Double.MAX_VALUE);
    public static final BigDecimal MIN_DOUBLE = MAX_DOUBLE.negate();

    public static final <N1 extends Number, N2 extends Number> NumberConvertor<N1, N2> create(final Class<N1> c1, final Class<N2> c2, final boolean exact) {
        return new NumberConvertor<N1, N2>(){

            @Override
            public N2 convert(N1 o) {
                return exact ? 4.convertExact(o, c2) : 4.convert(o, c2);
            }

            @Override
            public N1 unconvert(N2 o) {
                return exact ? 4.convertExact(o, c1) : 4.convert(o, c1);
            }
        };
    }

    public static <N extends Number> N convert(Number n, Class<N> clazz) {
        Number res;
        if (n == null || n.getClass() == clazz || clazz == Number.class) {
            res = n;
        } else if (clazz == Short.class) {
            res = n.shortValue();
        } else if (clazz == Integer.class) {
            res = n.intValue();
        } else if (clazz == Long.class) {
            res = n.longValue();
        } else if (clazz == Byte.class) {
            res = n.byteValue();
        } else if (clazz == BigInteger.class) {
            res = n instanceof BigDecimal ? ((BigDecimal)n).toBigInteger() : (n instanceof Byte || n instanceof Short || n instanceof Integer || n instanceof AtomicInteger || n instanceof Long || n instanceof AtomicLong ? BigInteger.valueOf(n.longValue()) : (n instanceof Float || n instanceof Double ? BigDecimal.valueOf(n.doubleValue()).toBigInteger() : new BigInteger(n.toString())));
        } else if (clazz == AtomicInteger.class) {
            res = new AtomicInteger(n.intValue());
        } else if (clazz == AtomicLong.class) {
            res = new AtomicLong(n.longValue());
        } else if (clazz == BigDecimal.class) {
            res = NumberConvertor.toBigDecimal(n);
        } else if (clazz == Double.class) {
            res = n.doubleValue();
        } else if (clazz == Float.class) {
            res = Float.valueOf(n.floatValue());
        } else {
            throw new IllegalArgumentException("unknown class: " + clazz);
        }
        return (N)((Number)clazz.cast(res));
    }

    public static BigDecimal toBigDecimal(Number n) {
        BigDecimal res = n == null || n instanceof BigDecimal ? (BigDecimal)n : (n instanceof Byte || n instanceof Short || n instanceof Integer || n instanceof AtomicInteger || n instanceof Long || n instanceof AtomicLong ? BigDecimal.valueOf(n.longValue()) : (n instanceof Float || n instanceof Double ? BigDecimal.valueOf(n.doubleValue()) : (n instanceof BigInteger ? new BigDecimal((BigInteger)n) : new BigDecimal(n.toString()))));
        return res;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <N extends Number> N convertExact(Number n, Class<N> clazz) throws OverflowException, RoundingException {
        void var2_15;
        if (n == null || n.getClass() == clazz || clazz == Number.class) {
            Number number = n;
            return (N)((Number)clazz.cast(var2_15));
        }
        if (n instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)n;
            if (clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == AtomicInteger.class || clazz == Long.class || clazz == AtomicLong.class || clazz == BigInteger.class) {
                BigInteger bi;
                try {
                    bi = bd.toBigIntegerExact();
                }
                catch (ArithmeticException e) {
                    throw new RoundingException(n, clazz);
                }
                if (clazz == BigInteger.class) {
                    BigInteger bigInteger = bi;
                    return (N)((Number)clazz.cast(var2_15));
                } else {
                    try {
                        N n2 = NumberConvertor.convertExact(bi, clazz);
                        return (N)((Number)clazz.cast(var2_15));
                    }
                    catch (RoundingException e) {
                        throw new IllegalStateException(e);
                    }
                    catch (OverflowException e) {
                        throw new OverflowException(n, clazz).initCause(e);
                    }
                }
            }
            if (clazz == Float.class) {
                if (bd.compareTo(MAX_FLOAT) > 0 || bd.compareTo(MIN_FLOAT) < 0) {
                    throw new OverflowException(n, clazz);
                }
                Float f = Float.valueOf(n.floatValue());
                return (N)((Number)clazz.cast(var2_15));
            } else {
                if (clazz != Double.class) throw new IllegalStateException("Unknown class " + n.getClass());
                if (bd.compareTo(MAX_DOUBLE) > 0 || bd.compareTo(MIN_DOUBLE) < 0) {
                    throw new OverflowException(n, clazz);
                }
                Double d = n.doubleValue();
            }
            return (N)((Number)clazz.cast(var2_15));
        }
        if (clazz == Byte.class) {
            byte value = n.byteValue();
            if (n instanceof Short || n instanceof Integer || n instanceof AtomicInteger || n instanceof Long || n instanceof AtomicLong) {
                if ((long)value != n.longValue()) {
                    throw new OverflowException(n, clazz);
                }
            } else if (n instanceof BigInteger) {
                if (((BigInteger)n).bitLength() >= 8) {
                    throw new OverflowException(n, clazz);
                }
            } else {
                if (!(n instanceof Float) && !(n instanceof Double)) throw new IllegalStateException("Unknown class " + n.getClass());
                if (!(n.doubleValue() > 127.0) && !(n.doubleValue() < -128.0)) throw new RoundingException(n, clazz);
                throw new OverflowException(n, clazz);
            }
            Byte by = value;
            return (N)((Number)clazz.cast(var2_15));
        } else if (clazz == Short.class) {
            short value = n.shortValue();
            if (n instanceof Integer || n instanceof AtomicInteger || n instanceof Long || n instanceof AtomicLong) {
                if ((long)value != n.longValue()) {
                    throw new OverflowException(n, clazz);
                }
            } else if (!(n instanceof Byte)) {
                if (n instanceof BigInteger) {
                    if (((BigInteger)n).bitLength() >= 16) {
                        throw new OverflowException(n, clazz);
                    }
                } else {
                    if (!(n instanceof Float) && !(n instanceof Double)) throw new IllegalStateException("Unknown class " + n.getClass());
                    if (!(n.doubleValue() > 32767.0) && !(n.doubleValue() < -32768.0)) throw new RoundingException(n, clazz);
                    throw new OverflowException(n, clazz);
                }
            }
            Short s = value;
            return (N)((Number)clazz.cast(var2_15));
        } else if (clazz == Integer.class || clazz == AtomicInteger.class) {
            int value = n.intValue();
            if (n instanceof Long || n instanceof AtomicLong) {
                if ((long)value != n.longValue()) {
                    throw new OverflowException(n, clazz);
                }
            } else if (!(n instanceof Byte || n instanceof Short || n instanceof Integer || n instanceof AtomicInteger)) {
                if (n instanceof BigInteger) {
                    if (((BigInteger)n).bitLength() >= 32) {
                        throw new OverflowException(n, clazz);
                    }
                } else {
                    if (!(n instanceof Float) && !(n instanceof Double)) throw new IllegalStateException("Unknown class " + n.getClass());
                    if (!(n.doubleValue() > 2.147483647E9) && !(n.doubleValue() < -2.147483648E9)) throw new RoundingException(n, clazz);
                    throw new OverflowException(n, clazz);
                }
            }
            Number number = clazz == Integer.class ? Integer.valueOf(value) : new AtomicInteger(value);
            return (N)((Number)clazz.cast(var2_15));
        } else if (clazz == Long.class || clazz == AtomicLong.class) {
            long value = n.longValue();
            if (!(n instanceof Byte || n instanceof Short || n instanceof Integer || n instanceof AtomicInteger || n instanceof Long || n instanceof AtomicLong)) {
                if (n instanceof BigInteger) {
                    if (((BigInteger)n).bitLength() >= 64) {
                        throw new OverflowException(n, clazz);
                    }
                } else {
                    if (!(n instanceof Float) && !(n instanceof Double)) throw new IllegalStateException("Unknown class " + n.getClass());
                    if (!(n.doubleValue() >= 9.223372036854776E18) && !(n.doubleValue() <= -9.223372036854776E18)) throw new RoundingException(n, clazz);
                    throw new OverflowException(n, clazz);
                }
            }
            Number number = clazz == Long.class ? Long.valueOf(value) : new AtomicLong(value);
            return (N)((Number)clazz.cast(var2_15));
        } else if (clazz == BigInteger.class) {
            if (!(n instanceof Byte || n instanceof Short || n instanceof Integer || n instanceof AtomicInteger || n instanceof Long || n instanceof AtomicLong)) {
                if (!(n instanceof Float) && !(n instanceof Double)) throw new IllegalStateException("Unknown class " + n.getClass());
                throw new RoundingException(n, clazz);
            }
            BigInteger bigInteger = BigInteger.valueOf(n.longValue());
            return (N)((Number)clazz.cast(var2_15));
        } else if (clazz == BigDecimal.class) {
            BigDecimal bigDecimal = NumberConvertor.toBigDecimal(n);
            return (N)((Number)clazz.cast(var2_15));
        } else if (clazz == Double.class) {
            if (!(n instanceof Byte || n instanceof Short || n instanceof Integer || n instanceof AtomicInteger || n instanceof Long || n instanceof AtomicLong || n instanceof Float)) {
                if (!(n instanceof BigInteger)) throw new IllegalStateException("Unknown class " + n.getClass());
                BigInteger bi = (BigInteger)n;
                if (bi.compareTo(MAX_DOUBLE.toBigIntegerExact()) > 0 || bi.compareTo(MIN_DOUBLE.toBigIntegerExact()) < 0) {
                    throw new OverflowException(n, clazz);
                }
            }
            Double d = n.doubleValue();
            return (N)((Number)clazz.cast(var2_15));
        } else {
            if (clazz != Float.class) throw new IllegalArgumentException("Unknown class: " + clazz);
            if (!(n instanceof Byte || n instanceof Short || n instanceof Integer || n instanceof AtomicInteger || n instanceof Long || n instanceof AtomicLong)) {
                if (n instanceof Double) {
                    if (Math.abs(n.doubleValue()) > 3.4028234663852886E38) {
                        throw new OverflowException(n, clazz);
                    }
                } else {
                    if (!(n instanceof BigInteger)) throw new IllegalStateException("Unknown class " + n.getClass());
                    BigInteger bi = (BigInteger)n;
                    if (bi.compareTo(MAX_FLOAT.toBigIntegerExact()) > 0 || bi.compareTo(MIN_FLOAT.toBigIntegerExact()) < 0) {
                        throw new OverflowException(n, clazz);
                    }
                }
            }
            Float f = Float.valueOf(n.floatValue());
        }
        return (N)((Number)clazz.cast(var2_15));
    }

    public static class OverflowException
    extends ArithmeticException {
        public OverflowException(Number n, Class<? extends Number> clazz) {
            super("Cannot convert to " + clazz + " : " + n);
        }

        @Override
        public OverflowException initCause(Throwable cause) {
            super.initCause(cause);
            return this;
        }
    }

    public static class RoundingException
    extends ArithmeticException {
        public RoundingException(Number n, Class<? extends Number> clazz) {
            super("Rounding necessary for " + clazz + " : " + n + " (" + n.getClass() + ")");
        }
    }
}

