/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.checks;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.function.Consumer;

public final class ChainPropertyListener
implements PropertyChangeListener {
    private final Consumer<PropertyChangeEvent> delegate;
    private final Object target;
    private final String propName;

    public static final PropertyChangeEvent copyEvent(Object bean, PropertyChangeEvent evt) {
        return ChainPropertyListener.copyEvent(bean, evt.getPropertyName(), evt);
    }

    public static final PropertyChangeEvent copyEvent(Object bean, String propName, PropertyChangeEvent evt) {
        PropertyChangeEvent res = new PropertyChangeEvent(bean, propName, evt.getOldValue(), evt.getNewValue());
        res.setPropagationId(evt.getPropagationId());
        return res;
    }

    public ChainPropertyListener(Object target, PropertyChangeListener delegate) {
        this(target, null, delegate::propertyChange);
    }

    public ChainPropertyListener(Object target, String propName, Consumer<PropertyChangeEvent> delegate) {
        if (target == null || delegate == null) {
            throw new NullPointerException();
        }
        this.target = target;
        this.propName = propName;
        this.delegate = delegate;
    }

    public final String getPropName() {
        return this.propName;
    }

    private final String getPropName(PropertyChangeEvent evt) {
        return this.propName != null ? this.propName : evt.getPropertyName();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.delegate.accept(ChainPropertyListener.copyEvent(this.target, this.getPropName(evt), evt));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.delegate.hashCode();
        result = 31 * result + this.target.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChainPropertyListener other = (ChainPropertyListener)obj;
        return this.delegate.equals(other.delegate) && this.target.equals(other.target);
    }
}

