/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.cc;

import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.jcip.annotations.Immutable;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.utils.cc.TruncatableList;

@Immutable
public class MatchedList<T> {
    private static final MatchedList EMPTY_LIST = new MatchedList(TruncatableList.empty(), null, Collections.emptyList());
    private final TruncatableList<T> items;
    private final Function<? super T, String> asString;
    private final List<BitSet> matchedIndexes;

    public static final <T> MatchedList<T> empty() {
        return EMPTY_LIST;
    }

    public static final <T> MatchedList<T> createNotFiltered(TruncatableList<T> truncatableItems) {
        return new MatchedList<T>(truncatableItems, null, null);
    }

    public static final <T> MatchedList<T> createFiltered(TruncatableList<T> truncatableItems, Function<? super T, String> asString, List<BitSet> matchedIndexes) {
        return new MatchedList<T>(truncatableItems, Objects.requireNonNull(asString), Objects.requireNonNull(matchedIndexes));
    }

    private MatchedList(TruncatableList<T> truncatableItems, Function<? super T, String> asString, List<BitSet> matchedIndexes) {
        this.items = Objects.requireNonNull(truncatableItems);
        this.asString = asString;
        this.matchedIndexes = matchedIndexes;
        if (matchedIndexes != null) {
            ExceptionUtils.requireEquals(truncatableItems.getList().size(), matchedIndexes.size(), "Size mismatch");
        }
    }

    public final TruncatableList<T> getTruncatableList() {
        return this.items;
    }

    public final List<T> getList() {
        return this.getTruncatableList().getList();
    }

    public final Function<? super T, String> getAsString() {
        return this.asString;
    }

    public final List<BitSet> getMatchedIndexes() {
        return this.matchedIndexes;
    }
}

